/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import java.util.Collections;
import org.apache.commons.cli.Options;
import org.apache.flink.client.cli.CliFrontend;
import org.apache.flink.client.cli.CliFrontendTestBase;
import org.apache.flink.client.cli.CliFrontendTestUtils;
import org.apache.flink.client.cli.GenericCLI;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.runtime.execution.librarycache.FlinkUserCodeClassLoaders;
import org.apache.flink.util.ChildFirstClassLoader;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class CliFrontendDynamicPropertiesTest
extends CliFrontendTestBase {
    private GenericCLI cliUnderTest;
    private Configuration configuration;
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();

    @BeforeClass
    public static void init() {
        CliFrontendTestUtils.pipeSystemOutToNull();
    }

    @AfterClass
    public static void shutdown() {
        CliFrontendTestUtils.restoreSystemOut();
    }

    @Before
    public void setup() {
        Options testOptions = new Options();
        this.configuration = new Configuration();
        this.configuration.set(CoreOptions.CHECK_LEAKED_CLASSLOADER, (Object)false);
        this.cliUnderTest = new GenericCLI(this.configuration, this.tmp.getRoot().getAbsolutePath());
        this.cliUnderTest.addGeneralOptions(testOptions);
    }

    @Test
    public void testDynamicPropertiesWithParentFirstClassloader() throws Exception {
        String[] args = new String[]{"-e", "test-executor", "-D" + CoreOptions.DEFAULT_PARALLELISM.key() + "=5", "-Dclassloader.resolve-order=parent-first", CliFrontendTestUtils.getTestJarPath(), "-a", "--debug", "true", "arg1", "arg2"};
        CliFrontendDynamicPropertiesTest.verifyCliFrontend(this.configuration, args, this.cliUnderTest, "parent-first", FlinkUserCodeClassLoaders.ParentFirstClassLoader.class.getName());
    }

    @Test
    public void testDynamicPropertiesWithDefaultChildFirstClassloader() throws Exception {
        String[] args = new String[]{"-e", "test-executor", "-D" + CoreOptions.DEFAULT_PARALLELISM.key() + "=5", CliFrontendTestUtils.getTestJarPath(), "-a", "--debug", "true", "arg1", "arg2"};
        CliFrontendDynamicPropertiesTest.verifyCliFrontend(this.configuration, args, this.cliUnderTest, "child-first", ChildFirstClassLoader.class.getName());
    }

    @Test
    public void testDynamicPropertiesWithChildFirstClassloader() throws Exception {
        String[] args = new String[]{"-e", "test-executor", "-D" + CoreOptions.DEFAULT_PARALLELISM.key() + "=5", "-Dclassloader.resolve-order=child-first", CliFrontendTestUtils.getTestJarPath(), "-a", "--debug", "true", "arg1", "arg2"};
        CliFrontendDynamicPropertiesTest.verifyCliFrontend(this.configuration, args, this.cliUnderTest, "child-first", ChildFirstClassLoader.class.getName());
    }

    public static void verifyCliFrontend(Configuration configuration, String[] parameters, GenericCLI cliUnderTest, String expectedResolveOrderOption, String userCodeClassLoaderClassName) throws Exception {
        TestingCliFrontend testFrontend = new TestingCliFrontend(configuration, cliUnderTest, expectedResolveOrderOption, userCodeClassLoaderClassName);
        testFrontend.run(parameters);
    }

    private static final class TestingCliFrontend
    extends CliFrontend {
        private final String expectedResolveOrder;
        private final String userCodeClassLoaderClassName;

        private TestingCliFrontend(Configuration configuration, GenericCLI cliUnderTest, String expectedResolveOrderOption, String userCodeClassLoaderClassName) {
            super(configuration, Collections.singletonList(cliUnderTest));
            this.expectedResolveOrder = expectedResolveOrderOption;
            this.userCodeClassLoaderClassName = userCodeClassLoaderClassName;
        }

        protected void executeProgram(Configuration configuration, PackagedProgram program) {
            Assert.assertEquals((Object)"org.apache.flink.client.testjar.TestJob", (Object)program.getMainClassName());
            Assert.assertEquals((Object)this.expectedResolveOrder, (Object)configuration.get(CoreOptions.CLASSLOADER_RESOLVE_ORDER));
            Assert.assertEquals((Object)this.userCodeClassLoaderClassName, (Object)program.getUserCodeClassLoader().getClass().getName());
        }
    }
}

