/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.time.Duration;
import java.util.Collections;
import org.apache.flink.client.cli.CliFrontend;
import org.apache.flink.client.cli.CliFrontendTestUtils;
import org.apache.flink.client.cli.DefaultCLI;
import org.apache.flink.client.cli.GenericCLI;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CliFrontendITCase {
    private PrintStream originalPrintStream;
    private ByteArrayOutputStream testOutputStream;

    @Before
    public void before() {
        this.originalPrintStream = System.out;
        this.testOutputStream = new ByteArrayOutputStream();
        System.setOut(new PrintStream(this.testOutputStream));
    }

    @After
    public void finalize() {
        System.setOut(this.originalPrintStream);
    }

    private String getStdoutString() {
        return this.testOutputStream.toString();
    }

    @Test
    public void configurationIsForwarded() throws Exception {
        Configuration config = new Configuration();
        DefaultCLI commandLine = new DefaultCLI();
        config.set(PipelineOptions.AUTO_WATERMARK_INTERVAL, (Object)Duration.ofMillis(42L));
        CliFrontend cliFrontend = new CliFrontend(config, Collections.singletonList(commandLine));
        cliFrontend.parseAndRun(new String[]{"run", "-c", TestingJob.class.getName(), CliFrontendTestUtils.getTestJarPath()});
        Assert.assertThat((Object)this.getStdoutString(), (Matcher)CoreMatchers.containsString((String)"Watermark interval is 42"));
    }

    @Test
    public void commandlineOverridesConfiguration() throws Exception {
        Configuration config = new Configuration();
        GenericCLI commandLine = new GenericCLI(config, "/dev/null");
        config.set(PipelineOptions.AUTO_WATERMARK_INTERVAL, (Object)Duration.ofMillis(42L));
        CliFrontend cliFrontend = new CliFrontend(config, Collections.singletonList(commandLine));
        cliFrontend.parseAndRun(new String[]{"run", "-t", "local", "-c", TestingJob.class.getName(), "-D" + PipelineOptions.AUTO_WATERMARK_INTERVAL.key() + "=142", CliFrontendTestUtils.getTestJarPath()});
        Assert.assertThat((Object)this.getStdoutString(), (Matcher)CoreMatchers.containsString((String)"Watermark interval is 142"));
    }

    public static class TestingJob {
        public static void main(String[] args) {
            StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
            System.out.println("Watermark interval is " + env.getConfig().getAutoWatermarkInterval());
        }
    }
}

