/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Collections;
import org.apache.flink.client.cli.CliArgsException;
import org.apache.flink.client.cli.CliFrontend;
import org.apache.flink.client.cli.CliFrontendTestBase;
import org.apache.flink.client.cli.CliFrontendTestUtils;
import org.apache.flink.configuration.Configuration;
import org.junit.Assert;
import org.junit.Test;

public class CliFrontendInfoTest
extends CliFrontendTestBase {
    private static PrintStream stdOut;
    private static PrintStream capture;
    private static ByteArrayOutputStream buffer;

    @Test(expected=CliArgsException.class)
    public void testMissingOption() throws Exception {
        String[] parameters = new String[]{};
        Configuration configuration = this.getConfiguration();
        CliFrontend testFrontend = new CliFrontend(configuration, Collections.singletonList(CliFrontendInfoTest.getCli()));
        testFrontend.cancel(parameters);
    }

    @Test(expected=CliArgsException.class)
    public void testUnrecognizedOption() throws Exception {
        String[] parameters = new String[]{"-v", "-l"};
        Configuration configuration = this.getConfiguration();
        CliFrontend testFrontend = new CliFrontend(configuration, Collections.singletonList(CliFrontendInfoTest.getCli()));
        testFrontend.cancel(parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShowExecutionPlan() throws Exception {
        CliFrontendInfoTest.replaceStdOut();
        try {
            String[] parameters = new String[]{CliFrontendTestUtils.getTestJarPath(), "-f", "true", "--arg", "suffix"};
            Configuration configuration = this.getConfiguration();
            CliFrontend testFrontend = new CliFrontend(configuration, Collections.singletonList(CliFrontendInfoTest.getCli()));
            testFrontend.info(parameters);
            Assert.assertTrue((boolean)buffer.toString().contains("\"parallelism\" : 4"));
        }
        finally {
            CliFrontendInfoTest.restoreStdOut();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShowExecutionPlanWithParallelism() {
        CliFrontendInfoTest.replaceStdOut();
        try {
            String[] parameters = new String[]{"-p", "17", CliFrontendTestUtils.getTestJarPath(), "--arg", "suffix"};
            Configuration configuration = this.getConfiguration();
            CliFrontend testFrontend = new CliFrontend(configuration, Collections.singletonList(CliFrontendInfoTest.getCli()));
            testFrontend.info(parameters);
            Assert.assertTrue((boolean)buffer.toString().contains("\"parallelism\" : 17"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Program caused an exception: " + e.getMessage()));
        }
        finally {
            CliFrontendInfoTest.restoreStdOut();
        }
    }

    private static void replaceStdOut() {
        stdOut = System.out;
        buffer = new ByteArrayOutputStream();
        capture = new PrintStream(buffer);
        System.setOut(capture);
    }

    private static void restoreStdOut() {
        System.setOut(stdOut);
    }
}

