/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.cli.Options;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.client.cli.CliArgsException;
import org.apache.flink.client.cli.CliFrontend;
import org.apache.flink.client.cli.CliFrontendParser;
import org.apache.flink.client.cli.CliFrontendTestBase;
import org.apache.flink.client.cli.CliFrontendTestUtils;
import org.apache.flink.client.cli.ListOptions;
import org.apache.flink.client.cli.util.MockedCliFrontend;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.client.JobStatusMessage;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class CliFrontendListTest
extends CliFrontendTestBase {
    @BeforeClass
    public static void init() {
        CliFrontendTestUtils.pipeSystemOutToNull();
    }

    @AfterClass
    public static void shutdown() {
        CliFrontendTestUtils.restoreSystemOut();
    }

    @Test
    public void testListOptions() throws Exception {
        String[] parameters = new String[]{"-a"};
        ListOptions options = new ListOptions(CliFrontendParser.parse((Options)CliFrontendParser.getListCommandOptions(), (String[])parameters, (boolean)true));
        Assert.assertTrue((boolean)options.showAll());
        Assert.assertFalse((boolean)options.showRunning());
        Assert.assertFalse((boolean)options.showScheduled());
        parameters = new String[]{"-r"};
        options = new ListOptions(CliFrontendParser.parse((Options)CliFrontendParser.getListCommandOptions(), (String[])parameters, (boolean)true));
        Assert.assertFalse((boolean)options.showAll());
        Assert.assertTrue((boolean)options.showRunning());
        Assert.assertFalse((boolean)options.showScheduled());
        parameters = new String[]{"-s"};
        options = new ListOptions(CliFrontendParser.parse((Options)CliFrontendParser.getListCommandOptions(), (String[])parameters, (boolean)true));
        Assert.assertFalse((boolean)options.showAll());
        Assert.assertFalse((boolean)options.showRunning());
        Assert.assertTrue((boolean)options.showScheduled());
    }

    @Test(expected=CliArgsException.class)
    public void testUnrecognizedOption() throws Exception {
        String[] parameters = new String[]{"-v", "-k"};
        Configuration configuration = this.getConfiguration();
        CliFrontend testFrontend = new CliFrontend(configuration, Collections.singletonList(CliFrontendListTest.getCli()));
        testFrontend.list(parameters);
    }

    @Test
    public void testList() throws Exception {
        String[] parameters = new String[]{"-r", "-s", "-a"};
        ClusterClient<String> clusterClient = CliFrontendListTest.createClusterClient();
        MockedCliFrontend testFrontend = new MockedCliFrontend(clusterClient);
        testFrontend.list(parameters);
        ((ClusterClient)Mockito.verify(clusterClient, (VerificationMode)Mockito.times((int)1))).listJobs();
    }

    private static ClusterClient<String> createClusterClient() throws Exception {
        ClusterClient clusterClient = (ClusterClient)Mockito.mock(ClusterClient.class);
        Mockito.when((Object)clusterClient.listJobs()).thenReturn(CompletableFuture.completedFuture(Arrays.asList(new JobStatusMessage(new JobID(), "job1", JobStatus.RUNNING, 1L), new JobStatusMessage(new JobID(), "job2", JobStatus.CREATED, 1L), new JobStatusMessage(new JobID(), "job3", JobStatus.FINISHED, 3L))));
        return clusterClient;
    }
}

