/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Collections;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.client.FlinkPipelineTranslationUtil;
import org.apache.flink.client.cli.CliArgsException;
import org.apache.flink.client.cli.CliFrontend;
import org.apache.flink.client.cli.CliFrontendParser;
import org.apache.flink.client.cli.CliFrontendTestUtils;
import org.apache.flink.client.cli.DefaultCLI;
import org.apache.flink.client.cli.ProgramOptions;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.PackagedProgramUtils;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.Optimizer;
import org.apache.flink.optimizer.costs.CostEstimator;
import org.apache.flink.optimizer.costs.DefaultCostEstimator;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.util.TestLogger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class CliFrontendPackageProgramTest
extends TestLogger {
    private CliFrontend frontend;

    @BeforeClass
    public static void init() {
        CliFrontendTestUtils.pipeSystemOutToNull();
    }

    @AfterClass
    public static void shutdown() {
        CliFrontendTestUtils.restoreSystemOut();
    }

    @Before
    public void setup() throws Exception {
        Configuration configuration = new Configuration();
        this.frontend = new CliFrontend(configuration, Collections.singletonList(new DefaultCLI()));
    }

    @Test
    public void testNonExistingJarFile() throws Exception {
        ProgramOptions programOptions = (ProgramOptions)Mockito.mock(ProgramOptions.class);
        Mockito.when((Object)programOptions.getJarFilePath()).thenReturn((Object)"/some/none/existing/path");
        try {
            this.frontend.buildProgram(programOptions);
            Assert.fail((String)"should throw an exception");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testFileNotJarFile() throws Exception {
        ProgramOptions programOptions = (ProgramOptions)Mockito.mock(ProgramOptions.class);
        Mockito.when((Object)programOptions.getJarFilePath()).thenReturn((Object)CliFrontendTestUtils.getNonJarFilePath());
        Mockito.when((Object)programOptions.getProgramArgs()).thenReturn((Object)new String[0]);
        Mockito.when((Object)programOptions.getSavepointRestoreSettings()).thenReturn((Object)SavepointRestoreSettings.none());
        try {
            this.frontend.buildProgram(programOptions);
            Assert.fail((String)"should throw an exception");
        }
        catch (ProgramInvocationException programInvocationException) {
            // empty catch block
        }
    }

    @Test
    public void testVariantWithExplicitJarAndArgumentsOption() throws Exception {
        String[] arguments = new String[]{"--classpath", "file:///tmp/foo", "--classpath", "file:///tmp/bar", "-j", CliFrontendTestUtils.getTestJarPath(), "-a", "--debug", "true", "arg1", "arg2"};
        Object[] classpath = new URL[]{new URL("file:///tmp/foo"), new URL("file:///tmp/bar")};
        Object[] reducedArguments = new String[]{"--debug", "true", "arg1", "arg2"};
        CommandLine commandLine = CliFrontendParser.parse((Options)CliFrontendParser.RUN_OPTIONS, (String[])arguments, (boolean)true);
        ProgramOptions programOptions = ProgramOptions.create((CommandLine)commandLine);
        Assert.assertEquals((Object)CliFrontendTestUtils.getTestJarPath(), (Object)programOptions.getJarFilePath());
        Assert.assertArrayEquals((Object[])classpath, (Object[])programOptions.getClasspaths().toArray());
        Assert.assertArrayEquals((Object[])reducedArguments, (Object[])programOptions.getProgramArgs());
        PackagedProgram prog = this.frontend.buildProgram(programOptions);
        Assert.assertArrayEquals((Object[])reducedArguments, (Object[])prog.getArguments());
        Assert.assertEquals((Object)"org.apache.flink.client.testjar.TestJob", (Object)prog.getMainClassName());
    }

    @Test
    public void testVariantWithExplicitJarAndNoArgumentsOption() throws Exception {
        String[] arguments = new String[]{"--classpath", "file:///tmp/foo", "--classpath", "file:///tmp/bar", "-j", CliFrontendTestUtils.getTestJarPath(), "--debug", "true", "arg1", "arg2"};
        Object[] classpath = new URL[]{new URL("file:///tmp/foo"), new URL("file:///tmp/bar")};
        Object[] reducedArguments = new String[]{"--debug", "true", "arg1", "arg2"};
        CommandLine commandLine = CliFrontendParser.parse((Options)CliFrontendParser.RUN_OPTIONS, (String[])arguments, (boolean)true);
        ProgramOptions programOptions = ProgramOptions.create((CommandLine)commandLine);
        Assert.assertEquals((Object)CliFrontendTestUtils.getTestJarPath(), (Object)programOptions.getJarFilePath());
        Assert.assertArrayEquals((Object[])classpath, (Object[])programOptions.getClasspaths().toArray());
        Assert.assertArrayEquals((Object[])reducedArguments, (Object[])programOptions.getProgramArgs());
        PackagedProgram prog = this.frontend.buildProgram(programOptions);
        Assert.assertArrayEquals((Object[])reducedArguments, (Object[])prog.getArguments());
        Assert.assertEquals((Object)"org.apache.flink.client.testjar.TestJob", (Object)prog.getMainClassName());
    }

    @Test
    public void testValidVariantWithNoJarAndNoArgumentsOption() throws Exception {
        String[] arguments = new String[]{"--classpath", "file:///tmp/foo", "--classpath", "file:///tmp/bar", CliFrontendTestUtils.getTestJarPath(), "--debug", "true", "arg1", "arg2"};
        Object[] classpath = new URL[]{new URL("file:///tmp/foo"), new URL("file:///tmp/bar")};
        Object[] reducedArguments = new String[]{"--debug", "true", "arg1", "arg2"};
        CommandLine commandLine = CliFrontendParser.parse((Options)CliFrontendParser.RUN_OPTIONS, (String[])arguments, (boolean)true);
        ProgramOptions programOptions = ProgramOptions.create((CommandLine)commandLine);
        Assert.assertEquals((Object)CliFrontendTestUtils.getTestJarPath(), (Object)programOptions.getJarFilePath());
        Assert.assertArrayEquals((Object[])classpath, (Object[])programOptions.getClasspaths().toArray());
        Assert.assertArrayEquals((Object[])reducedArguments, (Object[])programOptions.getProgramArgs());
        PackagedProgram prog = this.frontend.buildProgram(programOptions);
        Assert.assertArrayEquals((Object[])reducedArguments, (Object[])prog.getArguments());
        Assert.assertEquals((Object)"org.apache.flink.client.testjar.TestJob", (Object)prog.getMainClassName());
    }

    @Test(expected=CliArgsException.class)
    public void testNoJarNoArgumentsAtAll() throws Exception {
        this.frontend.run(new String[0]);
    }

    @Test
    public void testNonExistingFileWithArguments() throws Exception {
        String[] arguments = new String[]{"--classpath", "file:///tmp/foo", "--classpath", "file:///tmp/bar", "/some/none/existing/path", "--debug", "true", "arg1", "arg2"};
        Object[] classpath = new URL[]{new URL("file:///tmp/foo"), new URL("file:///tmp/bar")};
        Object[] reducedArguments = new String[]{"--debug", "true", "arg1", "arg2"};
        CommandLine commandLine = CliFrontendParser.parse((Options)CliFrontendParser.RUN_OPTIONS, (String[])arguments, (boolean)true);
        ProgramOptions programOptions = ProgramOptions.create((CommandLine)commandLine);
        Assert.assertEquals((Object)arguments[4], (Object)programOptions.getJarFilePath());
        Assert.assertArrayEquals((Object[])classpath, (Object[])programOptions.getClasspaths().toArray());
        Assert.assertArrayEquals((Object[])reducedArguments, (Object[])programOptions.getProgramArgs());
        try {
            this.frontend.buildProgram(programOptions);
            Assert.fail((String)"Should fail with an exception");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testNonExistingFileWithoutArguments() throws Exception {
        String[] arguments = new String[]{"/some/none/existing/path"};
        CommandLine commandLine = CliFrontendParser.parse((Options)CliFrontendParser.RUN_OPTIONS, (String[])arguments, (boolean)true);
        ProgramOptions programOptions = ProgramOptions.create((CommandLine)commandLine);
        Assert.assertEquals((Object)arguments[0], (Object)programOptions.getJarFilePath());
        Assert.assertArrayEquals((Object[])new String[0], (Object[])programOptions.getProgramArgs());
        try {
            this.frontend.buildProgram(programOptions);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testPlanWithExternalClass() throws Exception {
        final boolean[] callme = new boolean[]{false};
        try {
            String[] arguments = new String[]{"--classpath", "file:///tmp/foo", "--classpath", "file:///tmp/bar", "-c", "org.apache.flink.client.testjar.JobWithExternalDependency", CliFrontendTestUtils.getTestJarPath(), "true", "arg1", "arg2"};
            Object[] classpath = new URL[]{new URL("file:///tmp/foo"), new URL("file:///tmp/bar")};
            Object[] reducedArguments = new String[]{"true", "arg1", "arg2"};
            CommandLine commandLine = CliFrontendParser.parse((Options)CliFrontendParser.RUN_OPTIONS, (String[])arguments, (boolean)true);
            ProgramOptions programOptions = ProgramOptions.create((CommandLine)commandLine);
            Assert.assertEquals((Object)CliFrontendTestUtils.getTestJarPath(), (Object)programOptions.getJarFilePath());
            Assert.assertArrayEquals((Object[])classpath, (Object[])programOptions.getClasspaths().toArray());
            Assert.assertEquals((Object)"org.apache.flink.client.testjar.JobWithExternalDependency", (Object)programOptions.getEntryPointClassName());
            Assert.assertArrayEquals((Object[])reducedArguments, (Object[])programOptions.getProgramArgs());
            PackagedProgram prog = (PackagedProgram)Mockito.spy((Object)this.frontend.buildProgram(programOptions));
            ClassLoader testClassLoader = new ClassLoader(prog.getUserCodeClassLoader()){

                @Override
                public Class<?> loadClass(String name) throws ClassNotFoundException {
                    if ("org.apache.hadoop.hive.ql.io.RCFileInputFormat".equals(name)) {
                        callme[0] = true;
                        return String.class;
                    }
                    return super.loadClass(name);
                }
            };
            Mockito.when((Object)prog.getUserCodeClassLoader()).thenReturn((Object)testClassLoader);
            Assert.assertEquals((Object)"org.apache.flink.client.testjar.JobWithExternalDependency", (Object)prog.getMainClassName());
            Assert.assertArrayEquals((Object[])reducedArguments, (Object[])prog.getArguments());
            Configuration c = new Configuration();
            Optimizer compiler = new Optimizer(new DataStatistics(), (CostEstimator)new DefaultCostEstimator(), c);
            Pipeline pipeline = PackagedProgramUtils.getPipelineFromProgram((PackagedProgram)prog, (Configuration)c, (int)666, (boolean)true);
            FlinkPipelineTranslationUtil.translateToJSONExecutionPlan((Pipeline)pipeline);
            Assert.fail((String)"Should have failed with a ClassNotFoundException");
        }
        catch (ProgramInvocationException e) {
            if (!(e.getCause() instanceof ClassNotFoundException)) {
                e.printStackTrace();
                Assert.fail((String)"Program didn't throw ClassNotFoundException");
            }
            Assert.assertTrue((String)"Classloader was not called", (boolean)callme[0]);
        }
    }
}

