/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import java.util.Collections;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.flink.client.cli.AbstractCustomCommandLine;
import org.apache.flink.client.cli.CliArgsException;
import org.apache.flink.client.cli.CliFrontend;
import org.apache.flink.client.cli.CliFrontendParser;
import org.apache.flink.client.cli.CliFrontendTestBase;
import org.apache.flink.client.cli.CliFrontendTestUtils;
import org.apache.flink.client.cli.ExecutionConfigAccessor;
import org.apache.flink.client.cli.ProgramOptions;
import org.apache.flink.client.deployment.ClusterClientServiceLoader;
import org.apache.flink.client.deployment.DefaultClusterClientServiceLoader;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class CliFrontendRunTest
extends CliFrontendTestBase {
    @BeforeClass
    public static void init() {
        CliFrontendTestUtils.pipeSystemOutToNull();
    }

    @AfterClass
    public static void shutdown() {
        CliFrontendTestUtils.restoreSystemOut();
    }

    @Test
    public void testRun() throws Exception {
        Configuration configuration = this.getConfiguration();
        String[] parameters = new String[]{"-v", CliFrontendTestUtils.getTestJarPath()};
        CliFrontendRunTest.verifyCliFrontend(configuration, CliFrontendRunTest.getCli(), parameters, 4, false);
        parameters = new String[]{"-v", "-d", CliFrontendTestUtils.getTestJarPath()};
        CliFrontendRunTest.verifyCliFrontend(configuration, CliFrontendRunTest.getCli(), parameters, 4, true);
        parameters = new String[]{"-v", "-p", "42", CliFrontendTestUtils.getTestJarPath()};
        CliFrontendRunTest.verifyCliFrontend(configuration, CliFrontendRunTest.getCli(), parameters, 42, false);
        parameters = new String[]{"-p", "2", "-d", CliFrontendTestUtils.getTestJarPath()};
        CliFrontendRunTest.verifyCliFrontend(configuration, CliFrontendRunTest.getCli(), parameters, 2, true);
        parameters = new String[]{"-s", "expectedSavepointPath", CliFrontendTestUtils.getTestJarPath()};
        CommandLine commandLine = CliFrontendParser.parse((Options)CliFrontendParser.RUN_OPTIONS, (String[])parameters, (boolean)true);
        ProgramOptions programOptions = ProgramOptions.create((CommandLine)commandLine);
        ExecutionConfigAccessor executionOptions = ExecutionConfigAccessor.fromProgramOptions((ProgramOptions)programOptions, Collections.emptyList());
        SavepointRestoreSettings savepointSettings = executionOptions.getSavepointRestoreSettings();
        Assert.assertTrue((boolean)savepointSettings.restoreSavepoint());
        Assert.assertEquals((Object)"expectedSavepointPath", (Object)savepointSettings.getRestorePath());
        Assert.assertFalse((boolean)savepointSettings.allowNonRestoredState());
        parameters = new String[]{"-s", "expectedSavepointPath", "-n", CliFrontendTestUtils.getTestJarPath()};
        commandLine = CliFrontendParser.parse((Options)CliFrontendParser.RUN_OPTIONS, (String[])parameters, (boolean)true);
        programOptions = ProgramOptions.create((CommandLine)commandLine);
        executionOptions = ExecutionConfigAccessor.fromProgramOptions((ProgramOptions)programOptions, Collections.emptyList());
        savepointSettings = executionOptions.getSavepointRestoreSettings();
        Assert.assertTrue((boolean)savepointSettings.restoreSavepoint());
        Assert.assertEquals((Object)"expectedSavepointPath", (Object)savepointSettings.getRestorePath());
        Assert.assertTrue((boolean)savepointSettings.allowNonRestoredState());
        parameters = new String[]{CliFrontendTestUtils.getTestJarPath(), "-arg1", "value1", "justavalue", "--arg2", "value2"};
        commandLine = CliFrontendParser.parse((Options)CliFrontendParser.RUN_OPTIONS, (String[])parameters, (boolean)true);
        programOptions = ProgramOptions.create((CommandLine)commandLine);
        Assert.assertEquals((Object)"-arg1", (Object)programOptions.getProgramArgs()[0]);
        Assert.assertEquals((Object)"value1", (Object)programOptions.getProgramArgs()[1]);
        Assert.assertEquals((Object)"justavalue", (Object)programOptions.getProgramArgs()[2]);
        Assert.assertEquals((Object)"--arg2", (Object)programOptions.getProgramArgs()[3]);
        Assert.assertEquals((Object)"value2", (Object)programOptions.getProgramArgs()[4]);
    }

    @Test(expected=CliArgsException.class)
    public void testUnrecognizedOption() throws Exception {
        String[] parameters = new String[]{"-v", "-l", "-a", "some", "program", "arguments"};
        Configuration configuration = this.getConfiguration();
        CliFrontend testFrontend = new CliFrontend(configuration, Collections.singletonList(CliFrontendRunTest.getCli()));
        testFrontend.run(parameters);
    }

    @Test(expected=CliArgsException.class)
    public void testInvalidParallelismOption() throws Exception {
        String[] parameters = new String[]{"-v", "-p", "text", CliFrontendTestUtils.getTestJarPath()};
        Configuration configuration = this.getConfiguration();
        CliFrontend testFrontend = new CliFrontend(configuration, Collections.singletonList(CliFrontendRunTest.getCli()));
        testFrontend.run(parameters);
    }

    @Test(expected=CliArgsException.class)
    public void testParallelismWithOverflow() throws Exception {
        String[] parameters = new String[]{"-v", "-p", "475871387138", CliFrontendTestUtils.getTestJarPath()};
        Configuration configuration = new Configuration();
        CliFrontend testFrontend = new CliFrontend(configuration, Collections.singletonList(CliFrontendRunTest.getCli()));
        testFrontend.run(parameters);
    }

    public static void verifyCliFrontend(Configuration configuration, AbstractCustomCommandLine cli, String[] parameters, int expectedParallelism, boolean isDetached) throws Exception {
        RunTestingCliFrontend testFrontend = new RunTestingCliFrontend(configuration, (ClusterClientServiceLoader)new DefaultClusterClientServiceLoader(), cli, expectedParallelism, isDetached);
        testFrontend.run(parameters);
    }

    public static void verifyCliFrontend(Configuration configuration, ClusterClientServiceLoader clusterClientServiceLoader, AbstractCustomCommandLine cli, String[] parameters, int expectedParallelism, boolean isDetached) throws Exception {
        RunTestingCliFrontend testFrontend = new RunTestingCliFrontend(configuration, clusterClientServiceLoader, cli, expectedParallelism, isDetached);
        testFrontend.run(parameters);
    }

    private static final class RunTestingCliFrontend
    extends CliFrontend {
        private final int expectedParallelism;
        private final boolean isDetached;

        private RunTestingCliFrontend(Configuration configuration, ClusterClientServiceLoader clusterClientServiceLoader, AbstractCustomCommandLine cli, int expectedParallelism, boolean isDetached) {
            super(configuration, clusterClientServiceLoader, Collections.singletonList(cli));
            this.expectedParallelism = expectedParallelism;
            this.isDetached = isDetached;
        }

        protected void executeProgram(Configuration configuration, PackagedProgram program) {
            ExecutionConfigAccessor executionConfigAccessor = ExecutionConfigAccessor.fromConfiguration((Configuration)configuration);
            Assert.assertEquals((Object)this.isDetached, (Object)executionConfigAccessor.getDetachedMode());
            Assert.assertEquals((long)this.expectedParallelism, (long)executionConfigAccessor.getParallelism());
        }
    }
}

