/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.zip.ZipOutputStream;
import org.apache.flink.api.common.JobID;
import org.apache.flink.client.cli.CliArgsException;
import org.apache.flink.client.cli.CliFrontendTestBase;
import org.apache.flink.client.cli.util.MockedCliFrontend;
import org.apache.flink.client.deployment.StandaloneClusterId;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.client.program.rest.RestClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class CliFrontendSavepointTest
extends CliFrontendTestBase {
    private static PrintStream stdOut;
    private static PrintStream stdErr;
    private static ByteArrayOutputStream buffer;
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTriggerSavepointSuccess() throws Exception {
        CliFrontendSavepointTest.replaceStdOutAndStdErr();
        JobID jobId = new JobID();
        String savepointPath = "expectedSavepointPath";
        ClusterClient<String> clusterClient = CliFrontendSavepointTest.createClusterClient(savepointPath);
        try {
            MockedCliFrontend frontend = new MockedCliFrontend(clusterClient);
            String[] parameters = new String[]{jobId.toString()};
            frontend.savepoint(parameters);
            ((ClusterClient)Mockito.verify(clusterClient, (VerificationMode)Mockito.times((int)1))).triggerSavepoint((JobID)org.mockito.Matchers.eq((Object)jobId), (String)org.mockito.Matchers.isNull(String.class));
            Assert.assertTrue((boolean)buffer.toString().contains(savepointPath));
        }
        finally {
            clusterClient.close();
            CliFrontendSavepointTest.restoreStdOutAndStdErr();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTriggerSavepointFailure() throws Exception {
        CliFrontendSavepointTest.replaceStdOutAndStdErr();
        JobID jobId = new JobID();
        String expectedTestException = "expectedTestException";
        Exception testException = new Exception(expectedTestException);
        ClusterClient<String> clusterClient = CliFrontendSavepointTest.createFailingClusterClient(testException);
        try {
            MockedCliFrontend frontend = new MockedCliFrontend(clusterClient);
            String[] parameters = new String[]{jobId.toString()};
            try {
                frontend.savepoint(parameters);
                Assert.fail((String)"Savepoint should have failed.");
            }
            catch (FlinkException e) {
                Assert.assertTrue((boolean)ExceptionUtils.findThrowableWithMessage((Throwable)e, (String)expectedTestException).isPresent());
            }
        }
        finally {
            clusterClient.close();
            CliFrontendSavepointTest.restoreStdOutAndStdErr();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTriggerSavepointFailureIllegalJobID() throws Exception {
        CliFrontendSavepointTest.replaceStdOutAndStdErr();
        try {
            MockedCliFrontend frontend = new MockedCliFrontend((ClusterClient<?>)new RestClusterClient(this.getConfiguration(), (Object)StandaloneClusterId.getInstance()));
            String[] parameters = new String[]{"invalid job id"};
            try {
                frontend.savepoint(parameters);
                Assert.fail((String)"Should have failed.");
            }
            catch (CliArgsException e) {
                Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Cannot parse JobID"));
            }
        }
        finally {
            CliFrontendSavepointTest.restoreStdOutAndStdErr();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTriggerSavepointCustomTarget() throws Exception {
        CliFrontendSavepointTest.replaceStdOutAndStdErr();
        JobID jobId = new JobID();
        String savepointDirectory = "customTargetDirectory";
        ClusterClient<String> clusterClient = CliFrontendSavepointTest.createClusterClient(savepointDirectory);
        try {
            MockedCliFrontend frontend = new MockedCliFrontend(clusterClient);
            String[] parameters = new String[]{jobId.toString(), savepointDirectory};
            frontend.savepoint(parameters);
            ((ClusterClient)Mockito.verify(clusterClient, (VerificationMode)Mockito.times((int)1))).triggerSavepoint((JobID)org.mockito.Matchers.eq((Object)jobId), (String)org.mockito.Matchers.eq((Object)savepointDirectory));
            Assert.assertTrue((boolean)buffer.toString().contains(savepointDirectory));
        }
        finally {
            clusterClient.close();
            CliFrontendSavepointTest.restoreStdOutAndStdErr();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisposeSavepointSuccess() throws Exception {
        CliFrontendSavepointTest.replaceStdOutAndStdErr();
        String savepointPath = "expectedSavepointPath";
        DisposeSavepointClusterClient clusterClient = new DisposeSavepointClusterClient(path -> CompletableFuture.completedFuture(Acknowledge.get()), this.getConfiguration());
        try {
            MockedCliFrontend frontend = new MockedCliFrontend((ClusterClient<?>)clusterClient);
            String[] parameters = new String[]{"-d", savepointPath};
            frontend.savepoint(parameters);
            String outMsg = buffer.toString();
            Assert.assertTrue((boolean)outMsg.contains(savepointPath));
            Assert.assertTrue((boolean)outMsg.contains("disposed"));
        }
        finally {
            clusterClient.close();
            CliFrontendSavepointTest.restoreStdOutAndStdErr();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisposeWithJar() throws Exception {
        CliFrontendSavepointTest.replaceStdOutAndStdErr();
        CompletableFuture disposeSavepointFuture = new CompletableFuture();
        DisposeSavepointClusterClient clusterClient = new DisposeSavepointClusterClient(savepointPath -> {
            disposeSavepointFuture.complete(savepointPath);
            return CompletableFuture.completedFuture(Acknowledge.get());
        }, this.getConfiguration());
        try {
            MockedCliFrontend frontend = new MockedCliFrontend((ClusterClient<?>)clusterClient);
            File f = this.tmp.newFile();
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(f));
            out.close();
            String disposePath = "any-path";
            String[] parameters = new String[]{"-d", "any-path", "-j", f.getAbsolutePath()};
            frontend.savepoint(parameters);
            String actualSavepointPath = (String)disposeSavepointFuture.get();
            Assert.assertEquals((Object)"any-path", (Object)actualSavepointPath);
        }
        finally {
            clusterClient.close();
            CliFrontendSavepointTest.restoreStdOutAndStdErr();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisposeSavepointFailure() throws Exception {
        CliFrontendSavepointTest.replaceStdOutAndStdErr();
        String savepointPath = "expectedSavepointPath";
        Exception testException = new Exception("expectedTestException");
        DisposeSavepointClusterClient clusterClient = new DisposeSavepointClusterClient(path -> FutureUtils.completedExceptionally((Throwable)testException), this.getConfiguration());
        try {
            MockedCliFrontend frontend = new MockedCliFrontend((ClusterClient<?>)clusterClient);
            String[] parameters = new String[]{"-d", savepointPath};
            try {
                frontend.savepoint(parameters);
                Assert.fail((String)"Savepoint should have failed.");
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)ExceptionUtils.findThrowableWithMessage((Throwable)e, (String)testException.getMessage()).isPresent());
            }
        }
        finally {
            clusterClient.close();
            CliFrontendSavepointTest.restoreStdOutAndStdErr();
        }
    }

    private static void replaceStdOutAndStdErr() {
        stdOut = System.out;
        stdErr = System.err;
        buffer = new ByteArrayOutputStream();
        PrintStream capture = new PrintStream(buffer);
        System.setOut(capture);
        System.setErr(capture);
    }

    private static void restoreStdOutAndStdErr() {
        System.setOut(stdOut);
        System.setErr(stdErr);
    }

    private static ClusterClient<String> createClusterClient(String expectedResponse) throws Exception {
        ClusterClient clusterClient = (ClusterClient)Mockito.mock(ClusterClient.class);
        Mockito.when((Object)clusterClient.triggerSavepoint((JobID)org.mockito.Matchers.any(JobID.class), (String)ArgumentMatchers.nullable(String.class))).thenReturn(CompletableFuture.completedFuture(expectedResponse));
        return clusterClient;
    }

    private static ClusterClient<String> createFailingClusterClient(Exception expectedException) throws Exception {
        ClusterClient clusterClient = (ClusterClient)Mockito.mock(ClusterClient.class);
        Mockito.when((Object)clusterClient.triggerSavepoint((JobID)org.mockito.Matchers.any(JobID.class), (String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)FutureUtils.completedExceptionally((Throwable)expectedException));
        return clusterClient;
    }

    private static final class DisposeSavepointClusterClient
    extends RestClusterClient<StandaloneClusterId> {
        private final Function<String, CompletableFuture<Acknowledge>> disposeSavepointFunction;

        DisposeSavepointClusterClient(Function<String, CompletableFuture<Acknowledge>> disposeSavepointFunction, Configuration configuration) throws Exception {
            super(configuration, (Object)StandaloneClusterId.getInstance());
            this.disposeSavepointFunction = (Function)Preconditions.checkNotNull(disposeSavepointFunction);
        }

        public CompletableFuture<Acknowledge> disposeSavepoint(String savepointPath) {
            return this.disposeSavepointFunction.apply(savepointPath);
        }
    }
}

