/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.JobID;
import org.apache.flink.client.cli.CliArgsException;
import org.apache.flink.client.cli.CliFrontend;
import org.apache.flink.client.cli.CliFrontendTestBase;
import org.apache.flink.client.cli.CliFrontendTestUtils;
import org.apache.flink.client.cli.util.MockedCliFrontend;
import org.apache.flink.client.program.TestingClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.concurrent.FutureUtils;
import org.apache.flink.util.function.TriFunction;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class CliFrontendStopWithSavepointTest
extends CliFrontendTestBase {
    @BeforeClass
    public static void setup() {
        CliFrontendTestUtils.pipeSystemOutToNull();
    }

    @AfterClass
    public static void shutdown() {
        CliFrontendTestUtils.restoreSystemOut();
    }

    @Test
    public void testStopWithOnlyJobId() throws Exception {
        JobID jid = new JobID();
        String jidString = jid.toString();
        String[] parameters = new String[]{jidString};
        OneShotLatch stopWithSavepointLatch = new OneShotLatch();
        TestingClusterClient clusterClient = new TestingClusterClient();
        clusterClient.setStopWithSavepointFunction((TriFunction<JobID, Boolean, String, CompletableFuture<String>>)((TriFunction)(jobID, advanceToEndOfEventTime, savepointDirectory) -> {
            Assert.assertThat((Object)jobID, (Matcher)CoreMatchers.is((Object)jid));
            Assert.assertThat((Object)advanceToEndOfEventTime, (Matcher)CoreMatchers.is((Object)false));
            Assert.assertNull((Object)savepointDirectory);
            stopWithSavepointLatch.trigger();
            return CompletableFuture.completedFuture(savepointDirectory);
        }));
        MockedCliFrontend testFrontend = new MockedCliFrontend(clusterClient);
        testFrontend.stop(parameters);
        stopWithSavepointLatch.await();
    }

    @Test
    public void testStopWithDefaultSavepointDir() throws Exception {
        JobID jid = new JobID();
        String[] parameters = new String[]{jid.toString()};
        OneShotLatch stopWithSavepointLatch = new OneShotLatch();
        TestingClusterClient clusterClient = new TestingClusterClient();
        clusterClient.setStopWithSavepointFunction((TriFunction<JobID, Boolean, String, CompletableFuture<String>>)((TriFunction)(jobID, advanceToEndOfEventTime, savepointDirectory) -> {
            Assert.assertThat((Object)jobID, (Matcher)CoreMatchers.is((Object)jid));
            Assert.assertThat((Object)advanceToEndOfEventTime, (Matcher)CoreMatchers.is((Object)false));
            Assert.assertNull((Object)savepointDirectory);
            stopWithSavepointLatch.trigger();
            return CompletableFuture.completedFuture(savepointDirectory);
        }));
        MockedCliFrontend testFrontend = new MockedCliFrontend(clusterClient);
        testFrontend.stop(parameters);
        stopWithSavepointLatch.await();
    }

    @Test
    public void testStopWithExplicitSavepointDir() throws Exception {
        JobID jid = new JobID();
        String[] parameters = new String[]{"-p", "test-target-dir", jid.toString()};
        OneShotLatch stopWithSavepointLatch = new OneShotLatch();
        TestingClusterClient clusterClient = new TestingClusterClient();
        clusterClient.setStopWithSavepointFunction((TriFunction<JobID, Boolean, String, CompletableFuture<String>>)((TriFunction)(jobID, advanceToEndOfEventTime, savepointDirectory) -> {
            Assert.assertThat((Object)jobID, (Matcher)CoreMatchers.is((Object)jid));
            Assert.assertThat((Object)advanceToEndOfEventTime, (Matcher)CoreMatchers.is((Object)false));
            Assert.assertThat((Object)savepointDirectory, (Matcher)CoreMatchers.is((Object)"test-target-dir"));
            stopWithSavepointLatch.trigger();
            return CompletableFuture.completedFuture(savepointDirectory);
        }));
        MockedCliFrontend testFrontend = new MockedCliFrontend(clusterClient);
        testFrontend.stop(parameters);
        stopWithSavepointLatch.await();
    }

    @Test
    public void testStopOnlyWithMaxWM() throws Exception {
        JobID jid = new JobID();
        String[] parameters = new String[]{"-d", jid.toString()};
        OneShotLatch stopWithSavepointLatch = new OneShotLatch();
        TestingClusterClient clusterClient = new TestingClusterClient();
        clusterClient.setStopWithSavepointFunction((TriFunction<JobID, Boolean, String, CompletableFuture<String>>)((TriFunction)(jobID, advanceToEndOfEventTime, savepointDirectory) -> {
            Assert.assertThat((Object)jobID, (Matcher)CoreMatchers.is((Object)jid));
            Assert.assertThat((Object)advanceToEndOfEventTime, (Matcher)CoreMatchers.is((Object)true));
            Assert.assertNull((Object)savepointDirectory);
            stopWithSavepointLatch.trigger();
            return CompletableFuture.completedFuture(savepointDirectory);
        }));
        MockedCliFrontend testFrontend = new MockedCliFrontend(clusterClient);
        testFrontend.stop(parameters);
        stopWithSavepointLatch.await();
    }

    @Test
    public void testStopWithMaxWMAndDefaultSavepointDir() throws Exception {
        JobID jid = new JobID();
        String[] parameters = new String[]{"-p", "-d", jid.toString()};
        OneShotLatch stopWithSavepointLatch = new OneShotLatch();
        TestingClusterClient clusterClient = new TestingClusterClient();
        clusterClient.setStopWithSavepointFunction((TriFunction<JobID, Boolean, String, CompletableFuture<String>>)((TriFunction)(jobID, advanceToEndOfEventTime, savepointDirectory) -> {
            Assert.assertThat((Object)jobID, (Matcher)CoreMatchers.is((Object)jid));
            Assert.assertThat((Object)advanceToEndOfEventTime, (Matcher)CoreMatchers.is((Object)true));
            Assert.assertNull((Object)savepointDirectory);
            stopWithSavepointLatch.trigger();
            return CompletableFuture.completedFuture(savepointDirectory);
        }));
        MockedCliFrontend testFrontend = new MockedCliFrontend(clusterClient);
        testFrontend.stop(parameters);
        stopWithSavepointLatch.await();
    }

    @Test
    public void testStopWithMaxWMAndExplicitSavepointDir() throws Exception {
        JobID jid = new JobID();
        String[] parameters = new String[]{"-d", "-p", "test-target-dir", jid.toString()};
        OneShotLatch stopWithSavepointLatch = new OneShotLatch();
        TestingClusterClient clusterClient = new TestingClusterClient();
        clusterClient.setStopWithSavepointFunction((TriFunction<JobID, Boolean, String, CompletableFuture<String>>)((TriFunction)(jobID, advanceToEndOfEventTime, savepointDirectory) -> {
            Assert.assertThat((Object)jobID, (Matcher)CoreMatchers.is((Object)jid));
            Assert.assertThat((Object)advanceToEndOfEventTime, (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)savepointDirectory, (Matcher)CoreMatchers.is((Object)"test-target-dir"));
            stopWithSavepointLatch.trigger();
            return CompletableFuture.completedFuture(savepointDirectory);
        }));
        MockedCliFrontend testFrontend = new MockedCliFrontend(clusterClient);
        testFrontend.stop(parameters);
        stopWithSavepointLatch.await();
    }

    @Test(expected=CliArgsException.class)
    public void testUnrecognizedOption() throws Exception {
        String[] parameters = new String[]{"-v", "-l"};
        Configuration configuration = this.getConfiguration();
        CliFrontend testFrontend = new CliFrontend(configuration, Collections.singletonList(CliFrontendStopWithSavepointTest.getCli()));
        testFrontend.stop(parameters);
    }

    @Test(expected=CliArgsException.class)
    public void testMissingJobId() throws Exception {
        String[] parameters = new String[]{};
        Configuration configuration = this.getConfiguration();
        CliFrontend testFrontend = new CliFrontend(configuration, Collections.singletonList(CliFrontendStopWithSavepointTest.getCli()));
        testFrontend.stop(parameters);
    }

    @Test(expected=CliArgsException.class)
    public void testWrongSavepointDirOrder() throws Exception {
        JobID jid = new JobID();
        String[] parameters = new String[]{"-s", "-d", "test-target-dir", jid.toString()};
        MockedCliFrontend testFrontend = new MockedCliFrontend(new TestingClusterClient());
        testFrontend.stop(parameters);
    }

    @Test
    public void testUnknownJobId() throws Exception {
        JobID jid = new JobID();
        String[] parameters = new String[]{"-p", "test-target-dir", jid.toString()};
        String expectedMessage = "Test exception";
        FlinkException testException = new FlinkException(expectedMessage);
        TestingClusterClient clusterClient = new TestingClusterClient();
        clusterClient.setStopWithSavepointFunction((TriFunction<JobID, Boolean, String, CompletableFuture<String>>)((TriFunction)(jobID, advanceToEndOfEventTime, savepointDirectory) -> FutureUtils.completedExceptionally((Throwable)testException)));
        MockedCliFrontend testFrontend = new MockedCliFrontend(clusterClient);
        try {
            testFrontend.stop(parameters);
            Assert.fail((String)"Should have failed.");
        }
        catch (FlinkException e) {
            Assert.assertTrue((boolean)ExceptionUtils.findThrowableWithMessage((Throwable)e, (String)expectedMessage).isPresent());
        }
    }
}

