/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.flink.client.cli.CliFrontendRunTest;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.junit.Assert;

public class CliFrontendTestUtils {
    public static final String TEST_JAR_MAIN_CLASS = "org.apache.flink.client.testjar.TestJob";
    public static final String TEST_JAR_CLASSLOADERTEST_CLASS = "org.apache.flink.client.testjar.JobWithExternalDependency";
    public static final String TEST_JOB_MANAGER_ADDRESS = "192.168.1.33";
    public static final int TEST_JOB_MANAGER_PORT = 55443;
    private static final PrintStream previousSysout = System.out;

    public static String getTestJarPath() throws FileNotFoundException, MalformedURLException {
        String projectBaseDir = System.getProperty("project.basedir");
        Path testJarPath = Paths.get(projectBaseDir, "target", "maven-test-jar.jar");
        File f = testJarPath.toFile();
        if (!f.exists()) {
            throw new FileNotFoundException("Test jar not present. Invoke tests using maven or build the jar using 'mvn process-test-classes' in flink-clients");
        }
        return f.getAbsolutePath();
    }

    public static String getNonJarFilePath() {
        return CliFrontendRunTest.class.getResource("/testconfig/flink-conf.yaml").getFile();
    }

    public static String getConfigDir() {
        String confFile = CliFrontendRunTest.class.getResource("/testconfig/flink-conf.yaml").getFile();
        return new File(confFile).getAbsoluteFile().getParent();
    }

    public static String getInvalidConfigDir() {
        String confFile = CliFrontendRunTest.class.getResource("/invalidtestconfig/flink-conf.yaml").getFile();
        return new File(confFile).getAbsoluteFile().getParent();
    }

    public static void pipeSystemOutToNull() {
        System.setOut(new PrintStream(new BlackholeOutputSteam()));
    }

    public static void restoreSystemOut() {
        System.setOut(previousSysout);
    }

    public static void checkJobManagerAddress(Configuration config, String expectedAddress, int expectedPort) {
        String jobManagerAddress = config.getString(JobManagerOptions.ADDRESS);
        int jobManagerPort = config.getInteger(JobManagerOptions.PORT, -1);
        Assert.assertEquals((Object)expectedAddress, (Object)jobManagerAddress);
        Assert.assertEquals((long)expectedPort, (long)jobManagerPort);
    }

    private CliFrontendTestUtils() {
    }

    private static final class BlackholeOutputSteam
    extends OutputStream {
        private BlackholeOutputSteam() {
        }

        @Override
        public void write(int b) {
        }
    }
}

