/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import java.time.Duration;
import org.apache.commons.cli.CommandLine;
import org.apache.flink.client.cli.DefaultCLI;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.RestOptions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class DefaultCLITest {
    @Test
    public void testCommandLineMaterialization() throws Exception {
        String hostname = "home-sweet-home";
        int port = 1234;
        String[] args = new String[]{"-m", "home-sweet-home:1234"};
        DefaultCLI defaultCLI = new DefaultCLI();
        CommandLine commandLine = defaultCLI.parseCommandLineOptions(args, false);
        Configuration configuration = defaultCLI.toConfiguration(commandLine);
        Assert.assertThat((Object)configuration.get(RestOptions.ADDRESS), (Matcher)CoreMatchers.is((Object)"home-sweet-home"));
        Assert.assertThat((Object)configuration.get(RestOptions.PORT), (Matcher)CoreMatchers.is((Object)1234));
    }

    @Test
    public void testDynamicPropertyMaterialization() throws Exception {
        String[] args = new String[]{"-D" + PipelineOptions.AUTO_WATERMARK_INTERVAL.key() + "=42", "-D" + PipelineOptions.AUTO_GENERATE_UIDS.key() + "=true"};
        DefaultCLI defaultCLI = new DefaultCLI();
        CommandLine commandLine = defaultCLI.parseCommandLineOptions(args, false);
        Configuration configuration = defaultCLI.toConfiguration(commandLine);
        Assert.assertThat((Object)configuration.get(PipelineOptions.AUTO_WATERMARK_INTERVAL), (Matcher)CoreMatchers.is((Object)Duration.ofMillis(42L)));
        Assert.assertThat((Object)configuration.get(PipelineOptions.AUTO_GENERATE_UIDS), (Matcher)CoreMatchers.is((Object)true));
    }
}

