/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.flink.client.cli.CliArgsException;
import org.apache.flink.client.cli.CliFrontendParser;
import org.apache.flink.client.cli.GenericCLI;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.DeploymentOptions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class GenericCLITest {
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();
    private Options testOptions;

    @Before
    public void initOptions() {
        this.testOptions = new Options();
        GenericCLI cliUnderTest = new GenericCLI(new Configuration(), this.tmp.getRoot().getAbsolutePath());
        cliUnderTest.addGeneralOptions(this.testOptions);
    }

    @Test
    public void isActiveWhenTargetOnlyInConfig() throws CliArgsException {
        String expectedExecutorName = "test-executor";
        Configuration loadedConfig = new Configuration();
        loadedConfig.set(DeploymentOptions.TARGET, (Object)"test-executor");
        GenericCLI cliUnderTest = new GenericCLI(loadedConfig, this.tmp.getRoot().getAbsolutePath());
        CommandLine emptyCommandLine = CliFrontendParser.parse((Options)this.testOptions, (String[])new String[0], (boolean)true);
        Assert.assertTrue((boolean)cliUnderTest.isActive(emptyCommandLine));
    }

    @Test
    public void testWithPreexistingConfigurationInConstructor() throws CliArgsException {
        Configuration loadedConfig = new Configuration();
        loadedConfig.setInteger(CoreOptions.DEFAULT_PARALLELISM, 2);
        loadedConfig.setBoolean(DeploymentOptions.ATTACHED, false);
        ConfigOption listOption = ConfigOptions.key((String)"test.list").intType().asList().noDefaultValue();
        List<Integer> listValue = Arrays.asList(41, 42, 23);
        String encodedListValue = listValue.stream().map(Object::toString).collect(Collectors.joining(";"));
        String[] args = new String[]{"-e", "test-executor", "-D" + listOption.key() + "=" + encodedListValue, "-D" + CoreOptions.DEFAULT_PARALLELISM.key() + "=5"};
        GenericCLI cliUnderTest = new GenericCLI(loadedConfig, this.tmp.getRoot().getAbsolutePath());
        CommandLine commandLine = CliFrontendParser.parse((Options)this.testOptions, (String[])args, (boolean)true);
        Configuration configuration = cliUnderTest.toConfiguration(commandLine);
        Assert.assertEquals((Object)"test-executor", (Object)configuration.getString(DeploymentOptions.TARGET));
        Assert.assertEquals((long)5L, (long)configuration.getInteger(CoreOptions.DEFAULT_PARALLELISM));
        Assert.assertFalse((boolean)configuration.getBoolean(DeploymentOptions.ATTACHED));
        Assert.assertEquals(listValue, (Object)configuration.get(listOption));
    }

    @Test
    public void testIsActiveLong() throws CliArgsException {
        this.testIsActiveHelper("--executor");
    }

    @Test
    public void testIsActiveShort() throws CliArgsException {
        this.testIsActiveHelper("-e");
    }

    private void testIsActiveHelper(String executorOption) throws CliArgsException {
        String expectedExecutorName = "test-executor";
        ConfigOption configOption = ConfigOptions.key((String)"test.int").intType().noDefaultValue();
        int expectedValue = 42;
        GenericCLI cliUnderTest = new GenericCLI(new Configuration(), this.tmp.getRoot().getAbsolutePath());
        String[] args = new String[]{executorOption, "test-executor", "-D" + configOption.key() + "=" + 42};
        CommandLine commandLine = CliFrontendParser.parse((Options)this.testOptions, (String[])args, (boolean)true);
        Configuration configuration = cliUnderTest.toConfiguration(commandLine);
        Assert.assertEquals((Object)"test-executor", (Object)configuration.get(DeploymentOptions.TARGET));
        Assert.assertEquals((long)42L, (long)configuration.getInteger(configOption));
    }
}

