/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment;

import javax.annotation.Nullable;
import org.apache.flink.client.deployment.ClusterClientFactory;
import org.apache.flink.client.deployment.ClusterClientServiceLoader;
import org.apache.flink.client.deployment.ClusterDescriptor;
import org.apache.flink.client.deployment.ClusterSpecification;
import org.apache.flink.client.deployment.DefaultClusterClientServiceLoader;
import org.apache.flink.client.deployment.StandaloneClientFactory;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ClusterClientServiceLoaderTest {
    private static final String VALID_TARGET = "existing";
    private static final String AMBIGUOUS_TARGET = "duplicate";
    private static final String NON_EXISTING_TARGET = "non-existing";
    private static final int VALID_ID = 42;
    private ClusterClientServiceLoader serviceLoaderUnderTest;

    @Before
    public void init() {
        this.serviceLoaderUnderTest = new DefaultClusterClientServiceLoader();
    }

    @Test
    public void testStandaloneClusterClientFactoryDiscovery() {
        Configuration config = new Configuration();
        config.setString(DeploymentOptions.TARGET, "remote");
        ClusterClientFactory factory = this.serviceLoaderUnderTest.getClusterClientFactory(config);
        Assert.assertTrue((boolean)(factory instanceof StandaloneClientFactory));
    }

    @Test
    public void testFactoryDiscovery() {
        Configuration config = new Configuration();
        config.setString(DeploymentOptions.TARGET, VALID_TARGET);
        ClusterClientFactory factory = this.serviceLoaderUnderTest.getClusterClientFactory(config);
        Assert.assertNotNull((Object)factory);
        Integer id = (Integer)factory.getClusterId(config);
        Assert.assertThat((Object)id, (Matcher)CoreMatchers.allOf((Matcher)Is.is((Matcher)CoreMatchers.notNullValue()), (Matcher)CoreMatchers.equalTo((Object)42)));
    }

    @Test(expected=IllegalStateException.class)
    public void testMoreThanOneCompatibleFactoriesException() {
        Configuration config = new Configuration();
        config.setString(DeploymentOptions.TARGET, AMBIGUOUS_TARGET);
        this.serviceLoaderUnderTest.getClusterClientFactory(config);
        Assert.fail();
    }

    @Test(expected=IllegalStateException.class)
    public void testNoFactoriesFound() {
        Configuration config = new Configuration();
        config.setString(DeploymentOptions.TARGET, NON_EXISTING_TARGET);
        ClusterClientFactory factory = this.serviceLoaderUnderTest.getClusterClientFactory(config);
    }

    public static class BaseTestingClusterClientFactory
    implements ClusterClientFactory<Integer> {
        public boolean isCompatibleWith(Configuration configuration) {
            throw new UnsupportedOperationException();
        }

        public ClusterDescriptor<Integer> createClusterDescriptor(Configuration configuration) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public Integer getClusterId(Configuration configuration) {
            throw new UnsupportedOperationException();
        }

        public ClusterSpecification getClusterSpecification(Configuration configuration) {
            throw new UnsupportedOperationException();
        }
    }

    public static class SecondCollidingClusterClientFactory
    extends BaseTestingClusterClientFactory {
        public static final String ID = "duplicate";

        @Override
        public boolean isCompatibleWith(Configuration configuration) {
            return configuration.getString(DeploymentOptions.TARGET).equals("duplicate");
        }
    }

    public static class FirstCollidingClusterClientFactory
    extends BaseTestingClusterClientFactory {
        public static final String ID = "duplicate";

        @Override
        public boolean isCompatibleWith(Configuration configuration) {
            return configuration.getString(DeploymentOptions.TARGET).equals("duplicate");
        }
    }

    public static class ValidClusterClientFactory
    extends BaseTestingClusterClientFactory {
        public static final String ID = "existing";

        @Override
        public boolean isCompatibleWith(Configuration configuration) {
            return configuration.getString(DeploymentOptions.TARGET).equals("existing");
        }

        @Override
        @Nullable
        public Integer getClusterId(Configuration configuration) {
            return 42;
        }
    }
}

