/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment.application;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.io.FilenameUtils;
import org.apache.flink.client.deployment.application.FromClasspathEntryClassInformationProvider;
import org.apache.flink.client.testjar.ClasspathProvider;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Rule;
import org.junit.Test;

public class FromClasspathEntryClassInformationProviderTest
extends TestLogger {
    @Rule
    public ClasspathProvider noEntryClassClasspathProvider = ClasspathProvider.createWithNoEntryClass();
    @Rule
    public ClasspathProvider singleEntryClassClasspathProvider = ClasspathProvider.createWithSingleEntryClass();
    @Rule
    public ClasspathProvider multipleEntryClassesClasspathProvider = ClasspathProvider.createWithMultipleEntryClasses();
    @Rule
    public ClasspathProvider testJobEntryClassClasspathProvider = ClasspathProvider.createWithTestJobOnly();
    @Rule
    public ClasspathProvider onlyTextFileClasspathProvider = ClasspathProvider.createWithTextFileOnly();

    @Test
    public void testJobClassOnUserClasspathWithExplicitJobClassName() throws IOException, FlinkException {
        FromClasspathEntryClassInformationProvider testInstance = FromClasspathEntryClassInformationProvider.create((String)this.singleEntryClassClasspathProvider.getJobClassName(), this.singleEntryClassClasspathProvider.getURLUserClasspath());
        MatcherAssert.assertThat((Object)testInstance.getJobClassName().isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat(testInstance.getJobClassName().get(), (Matcher)Is.is((Object)this.singleEntryClassClasspathProvider.getJobClassName()));
        MatcherAssert.assertThat((Object)testInstance.getJarFile().isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test(expected=FlinkException.class)
    public void testJobClassOnUserClasspathWithOnlyTestFileOnClasspath() throws IOException, FlinkException {
        FromClasspathEntryClassInformationProvider.create((String)"SomeJobClassName", this.onlyTextFileClasspathProvider.getURLUserClasspath());
    }

    @Test(expected=NullPointerException.class)
    public void testJobClassOnUserClasspathWithMissingJobClassName() throws IOException, FlinkException {
        FromClasspathEntryClassInformationProvider.create(null, this.singleEntryClassClasspathProvider.getURLUserClasspath());
    }

    @Test(expected=NullPointerException.class)
    public void testJobClassOnUserClasspathWithMissingUserClasspath() throws IOException, FlinkException {
        FromClasspathEntryClassInformationProvider.create((String)"jobClassName", null);
    }

    @Test
    public void testJobClassOnUserClasspathWithoutExplicitJobClassName() throws IOException, FlinkException {
        FromClasspathEntryClassInformationProvider testInstance = FromClasspathEntryClassInformationProvider.createFromClasspath(this.singleEntryClassClasspathProvider.getURLUserClasspath());
        MatcherAssert.assertThat((Object)testInstance.getJobClassName().isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat(testInstance.getJobClassName().get(), (Matcher)Is.is((Object)this.singleEntryClassClasspathProvider.getJobClassName()));
        MatcherAssert.assertThat((Object)testInstance.getJarFile().isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test(expected=FlinkException.class)
    public void testMissingJobClassOnUserClasspathWithoutExplicitJobClassName() throws IOException, FlinkException {
        FromClasspathEntryClassInformationProvider.createFromClasspath(this.noEntryClassClasspathProvider.getURLUserClasspath());
    }

    @Test(expected=FlinkException.class)
    public void testTooManyMainMethodsOnUserClasspath() throws IOException, FlinkException {
        FromClasspathEntryClassInformationProvider.createFromClasspath(this.multipleEntryClassesClasspathProvider.getURLUserClasspath());
    }

    @Test(expected=NullPointerException.class)
    public void testJobClassOnUserClasspathWithoutExplicitJobClassNameAndMissingUserClasspath() throws IOException, FlinkException {
        FromClasspathEntryClassInformationProvider.createFromClasspath(null);
    }

    @Test
    public void testJobClassNameFromSystemClasspath() throws IOException, FlinkException {
        this.singleEntryClassClasspathProvider.setSystemClasspath();
        FromClasspathEntryClassInformationProvider testInstance = FromClasspathEntryClassInformationProvider.createFromSystemClasspath();
        MatcherAssert.assertThat((Object)testInstance.getJobClassName().isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat(testInstance.getJobClassName().get(), (Matcher)Is.is((Object)this.singleEntryClassClasspathProvider.getJobClassName()));
        MatcherAssert.assertThat((Object)testInstance.getJarFile().isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test(expected=FlinkException.class)
    public void testMissingJobClassNameFromSystemClasspath() throws IOException, FlinkException {
        this.noEntryClassClasspathProvider.setSystemClasspath();
        FromClasspathEntryClassInformationProvider.createFromSystemClasspath();
    }

    @Test(expected=FlinkException.class)
    public void testTooManyMainMethodsOnSystemClasspath() throws IOException, FlinkException {
        this.multipleEntryClassesClasspathProvider.setSystemClasspath();
        FromClasspathEntryClassInformationProvider.createFromSystemClasspath();
    }

    @Test
    public void testJarFromSystemClasspathSanityCheck() {
        Iterable systemClasspath = FromClasspathEntryClassInformationProvider.extractSystemClasspath();
        MatcherAssert.assertThat(StreamSupport.stream(systemClasspath.spliterator(), false).map(File::getName).collect(Collectors.toList()), (Matcher)IsCollectionContaining.hasItem((Matcher)CoreMatchers.containsString((String)"junit")));
    }

    @Test
    public void testJarFromSystemClasspath() throws MalformedURLException {
        this.multipleEntryClassesClasspathProvider.setSystemClasspath();
        Collection systemClasspath = StreamSupport.stream(FromClasspathEntryClassInformationProvider.extractSystemClasspath().spliterator(), false).map(File::getName).collect(Collectors.toList());
        Collection expectedContent = StreamSupport.stream(this.multipleEntryClassesClasspathProvider.getURLUserClasspath().spliterator(), false).map(URL::getPath).map(FilenameUtils::getName).filter(name -> name.endsWith("jar")).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)systemClasspath, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])expectedContent.toArray()));
    }
}

