/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment.application;

import java.io.File;
import org.apache.flink.client.deployment.application.FromJarEntryClassInformationProvider;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class FromJarEntryClassInformationProviderTest
extends TestLogger {
    @Test
    public void testCustomJarFile() {
        File jarFile = new File("some/path/to/jar");
        String jobClassName = "JobClassName";
        FromJarEntryClassInformationProvider testInstance = FromJarEntryClassInformationProvider.createFromCustomJar((File)jarFile, (String)"JobClassName");
        MatcherAssert.assertThat((Object)testInstance.getJarFile().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(testInstance.getJarFile().get(), (Matcher)CoreMatchers.is((Object)jarFile));
        MatcherAssert.assertThat((Object)testInstance.getJobClassName().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(testInstance.getJobClassName().get(), (Matcher)CoreMatchers.is((Object)"JobClassName"));
    }

    @Test(expected=NullPointerException.class)
    public void testMissingJar() {
        FromJarEntryClassInformationProvider testInstance = FromJarEntryClassInformationProvider.createFromCustomJar(null, (String)"JobClassName");
    }

    @Test
    public void testMissingJobClassName() {
        File jarFile = new File("some/path/to/jar");
        FromJarEntryClassInformationProvider testInstance = FromJarEntryClassInformationProvider.createFromCustomJar((File)jarFile, null);
        MatcherAssert.assertThat((Object)testInstance.getJarFile().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(testInstance.getJarFile().get(), (Matcher)CoreMatchers.is((Object)jarFile));
        MatcherAssert.assertThat((Object)testInstance.getJobClassName().isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test(expected=NullPointerException.class)
    public void testEitherJobClassNameOrJarHasToBeSet() {
        FromJarEntryClassInformationProvider.createFromCustomJar(null, null);
    }
}

