/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment.application;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.flink.client.deployment.application.JarManifestParser;
import org.apache.flink.client.testjar.TestJob;
import org.apache.flink.shaded.guava30.com.google.common.collect.ImmutableList;
import org.apache.flink.shaded.guava30.com.google.common.collect.ImmutableMap;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class JarManifestParserTest
extends TestLogger {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testFindEntryClassNoEntry() throws IOException {
        File jarFile = this.createJarFileWithManifest((Map<String, String>)ImmutableMap.of());
        Optional entry = JarManifestParser.findEntryClass((File)jarFile);
        Assert.assertFalse((boolean)entry.isPresent());
    }

    @Test
    public void testFindEntryClassAssemblerClass() throws IOException {
        File jarFile = this.createJarFileWithManifest((Map<String, String>)ImmutableMap.of((Object)"program-class", (Object)"AssemblerClass"));
        Optional entry = JarManifestParser.findEntryClass((File)jarFile);
        Assert.assertTrue((boolean)entry.isPresent());
        Assert.assertThat(entry.get(), (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)"AssemblerClass")));
    }

    @Test
    public void testFindEntryClassMainClass() throws IOException {
        File jarFile = this.createJarFileWithManifest((Map<String, String>)ImmutableMap.of((Object)"Main-Class", (Object)"MainClass"));
        Optional entry = JarManifestParser.findEntryClass((File)jarFile);
        Assert.assertTrue((boolean)entry.isPresent());
        Assert.assertThat(entry.get(), (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)"MainClass")));
    }

    @Test
    public void testFindEntryClassAssemblerClassAndMainClass() throws IOException {
        File jarFile = this.createJarFileWithManifest((Map<String, String>)ImmutableMap.of((Object)"program-class", (Object)"AssemblerClass", (Object)"Main-Class", (Object)"MainClass"));
        Optional entry = JarManifestParser.findEntryClass((File)jarFile);
        Assert.assertTrue((boolean)entry.isPresent());
        Assert.assertThat(entry.get(), (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)"AssemblerClass")));
    }

    @Test
    public void testFindEntryClassWithTestJobJar() throws IOException {
        File jarFile = TestJob.getTestJobJar();
        Optional entryClass = JarManifestParser.findEntryClass((File)jarFile);
        Assert.assertTrue((boolean)entryClass.isPresent());
        Assert.assertThat(entryClass.get(), (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)TestJob.class.getCanonicalName())));
    }

    @Test(expected=NoSuchElementException.class)
    public void testFindOnlyEntryClassEmptyArgument() throws IOException {
        JarManifestParser.findOnlyEntryClass(Collections.emptyList());
    }

    @Test(expected=NoSuchElementException.class)
    public void testFindOnlyEntryClassSingleJarWithNoManifest() throws IOException {
        File jarWithNoManifest = this.createJarFileWithManifest((Map<String, String>)ImmutableMap.of());
        JarManifestParser.findOnlyEntryClass((Iterable)ImmutableList.of((Object)jarWithNoManifest));
    }

    @Test
    public void testFindOnlyEntryClassSingleJar() throws IOException {
        File jarFile = TestJob.getTestJobJar();
        JarManifestParser.JarFileWithEntryClass jarFileWithEntryClass = JarManifestParser.findOnlyEntryClass((Iterable)ImmutableList.of((Object)jarFile));
        Assert.assertThat((Object)jarFileWithEntryClass.getEntryClass(), (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)TestJob.class.getCanonicalName())));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFindOnlyEntryClassMultipleJarsWithMultipleManifestEntries() throws IOException {
        File jarFile = TestJob.getTestJobJar();
        JarManifestParser.findOnlyEntryClass((Iterable)ImmutableList.of((Object)jarFile, (Object)jarFile, (Object)jarFile));
    }

    @Test
    public void testFindOnlyEntryClassMultipleJarsWithSingleManifestEntry() throws IOException {
        File jarWithNoManifest = this.createJarFileWithManifest((Map<String, String>)ImmutableMap.of());
        File jarFile = TestJob.getTestJobJar();
        JarManifestParser.JarFileWithEntryClass jarFileWithEntryClass = JarManifestParser.findOnlyEntryClass((Iterable)ImmutableList.of((Object)jarWithNoManifest, (Object)jarFile));
        Assert.assertThat((Object)jarFileWithEntryClass.getEntryClass(), (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)TestJob.class.getCanonicalName())));
    }

    @Test
    public void testFindFirstManifestAttributeWithNoAttribute() throws IOException {
        Assert.assertThat((Object)JarManifestParser.findFirstManifestAttribute((File)TestJob.getTestJobJar(), (String[])new String[0]).isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testFindFirstManifestAttributeWithAttributes() throws IOException {
        Optional optionalValue = JarManifestParser.findFirstManifestAttribute((File)TestJob.getTestJobJar(), (String[])new String[]{"Main-Class"});
        Assert.assertThat((Object)optionalValue.isPresent(), (Matcher)Is.is((Object)true));
        Assert.assertThat(optionalValue.get(), (Matcher)Is.is((Object)"org.apache.flink.client.testjar.TestJob"));
    }

    private File createJarFileWithManifest(Map<String, String> manifest) throws IOException {
        File jarFile = this.temporaryFolder.newFile();
        try (ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(jarFile)));
             PrintWriter pw = new PrintWriter(zos);){
            zos.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
            manifest.forEach((key, value) -> pw.println(String.format("%s: %s", key, value)));
        }
        return jarFile;
    }
}

