/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment.application;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.client.deployment.application.JobStatusPollingUtils;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.util.ExecutorUtils;
import org.apache.flink.util.SerializedThrowable;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.apache.flink.util.concurrent.ScheduledExecutorServiceAdapter;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class JobStatusPollingUtilsTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPolling() {
        int maxAttemptCounter = 3;
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        try {
            ScheduledExecutorServiceAdapter scheduledExecutor = new ScheduledExecutorServiceAdapter(executor);
            CallCountingJobStatusSupplier jobStatusSupplier = new CallCountingJobStatusSupplier(3);
            CompletableFuture result = JobStatusPollingUtils.pollJobResultAsync((Supplier)jobStatusSupplier, () -> CompletableFuture.completedFuture(JobStatusPollingUtilsTest.createSuccessfulJobResult(new JobID(0L, 0L))), (ScheduledExecutor)scheduledExecutor, (long)10L);
            result.join();
            Assert.assertThat((Object)jobStatusSupplier.getAttemptCounter(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)3)));
        }
        catch (Throwable throwable) {
            ExecutorUtils.gracefulShutdown((long)5L, (TimeUnit)TimeUnit.SECONDS, (ExecutorService[])new ExecutorService[]{executor});
            throw throwable;
        }
        ExecutorUtils.gracefulShutdown((long)5L, (TimeUnit)TimeUnit.SECONDS, (ExecutorService[])new ExecutorService[]{executor});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHappyPath() throws ExecutionException, InterruptedException {
        boolean maxAttemptCounter = true;
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        try {
            ScheduledExecutorServiceAdapter scheduledExecutor = new ScheduledExecutorServiceAdapter(executor);
            CallCountingJobStatusSupplier jobStatusSupplier = new CallCountingJobStatusSupplier(1);
            CompletableFuture result = JobStatusPollingUtils.pollJobResultAsync((Supplier)jobStatusSupplier, () -> CompletableFuture.completedFuture(JobStatusPollingUtilsTest.createSuccessfulJobResult(new JobID(0L, 0L))), (ScheduledExecutor)scheduledExecutor, (long)10L);
            result.join();
            Assert.assertThat((Object)jobStatusSupplier.getAttemptCounter(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1)));
            Assert.assertTrue((result.isDone() && ((JobResult)result.get()).isSuccess() ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            ExecutorUtils.gracefulShutdown((long)5L, (TimeUnit)TimeUnit.SECONDS, (ExecutorService[])new ExecutorService[]{executor});
            throw throwable;
        }
        ExecutorUtils.gracefulShutdown((long)5L, (TimeUnit)TimeUnit.SECONDS, (ExecutorService[])new ExecutorService[]{executor});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailedJobResult() throws ExecutionException, InterruptedException {
        boolean maxAttemptCounter = true;
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        try {
            ScheduledExecutorServiceAdapter scheduledExecutor = new ScheduledExecutorServiceAdapter(executor);
            CallCountingJobStatusSupplier jobStatusSupplier = new CallCountingJobStatusSupplier(1);
            CompletableFuture result = JobStatusPollingUtils.pollJobResultAsync((Supplier)jobStatusSupplier, () -> CompletableFuture.completedFuture(JobStatusPollingUtilsTest.createFailedJobResult(new JobID(0L, 0L))), (ScheduledExecutor)scheduledExecutor, (long)10L);
            result.join();
            Assert.assertThat((Object)jobStatusSupplier.getAttemptCounter(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1)));
            Assert.assertTrue((result.isDone() && ((JobResult)result.get()).getSerializedThrowable().isPresent() ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            ExecutorUtils.gracefulShutdown((long)5L, (TimeUnit)TimeUnit.SECONDS, (ExecutorService[])new ExecutorService[]{executor});
            throw throwable;
        }
        ExecutorUtils.gracefulShutdown((long)5L, (TimeUnit)TimeUnit.SECONDS, (ExecutorService[])new ExecutorService[]{executor});
    }

    private static JobResult createFailedJobResult(JobID jobId) {
        return new JobResult.Builder().jobId(jobId).netRuntime(2L).applicationStatus(ApplicationStatus.FAILED).serializedThrowable(new SerializedThrowable((Throwable)new Exception("bla bla bla"))).build();
    }

    private static JobResult createSuccessfulJobResult(JobID jobId) {
        return new JobResult.Builder().jobId(jobId).netRuntime(2L).applicationStatus(ApplicationStatus.SUCCEEDED).build();
    }

    private static final class CallCountingJobStatusSupplier
    implements Supplier<CompletableFuture<JobStatus>> {
        private final int maxAttempts;
        private int attemptCounter;

        public CallCountingJobStatusSupplier(int maxAttempts) {
            this.maxAttempts = maxAttempts;
        }

        public int getAttemptCounter() {
            return this.attemptCounter;
        }

        @Override
        public CompletableFuture<JobStatus> get() {
            if (++this.attemptCounter < this.maxAttempts) {
                return CompletableFuture.completedFuture(JobStatus.RUNNING);
            }
            return CompletableFuture.completedFuture(JobStatus.FINISHED);
        }
    }
}

