/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.client.deployment.application.EntryClassInformationProvider;
import org.apache.flink.client.deployment.executors.PipelineExecutorUtils;
import org.apache.flink.client.program.DefaultPackagedProgramRetriever;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.PackagedProgramRetriever;
import org.apache.flink.client.program.PackagedProgramUtils;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.client.testjar.ClasspathProvider;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.PipelineOptionsInternal;
import org.apache.flink.configuration.WritableConfig;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.runtime.execution.librarycache.FlinkUserCodeClassLoaders;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.util.ChildFirstClassLoader;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class DefaultPackagedProgramRetrieverTest
extends TestLogger {
    @Rule
    public ClasspathProvider noEntryClassClasspathProvider = ClasspathProvider.createWithNoEntryClass();
    @Rule
    public ClasspathProvider singleEntryClassClasspathProvider = ClasspathProvider.createWithSingleEntryClass();
    @Rule
    public ClasspathProvider multipleEntryClassesClasspathProvider = ClasspathProvider.createWithMultipleEntryClasses();
    @Rule
    public ClasspathProvider testJobEntryClassClasspathProvider = ClasspathProvider.createWithTestJobOnly();

    @Test
    public void testDeriveEntryClassInformationForCustomJar() throws FlinkException, MalformedURLException {
        this.noEntryClassClasspathProvider.setSystemClasspath();
        String jobClassName = "SomeJobClassName";
        File jarFile = new File("some/jar/file.jar");
        EntryClassInformationProvider informationProvider = DefaultPackagedProgramRetriever.createEntryClassInformationProvider(null, (File)jarFile, (String)"SomeJobClassName", (String[])new String[0]);
        MatcherAssert.assertThat((Object)informationProvider.getJobClassName().isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat(informationProvider.getJobClassName().get(), (Matcher)Is.is((Object)"SomeJobClassName"));
        MatcherAssert.assertThat((Object)informationProvider.getJarFile().isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat(informationProvider.getJarFile().get(), (Matcher)Is.is((Object)jarFile));
    }

    @Test
    public void testDeriveEntryClassInformationFromSystemClasspathWithNonExistingJobClassName() throws IOException, FlinkException {
        this.singleEntryClassClasspathProvider.setSystemClasspath();
        String jobClassName = "SomeJobClassNotBeingOnTheSystemClasspath";
        EntryClassInformationProvider informationProvider = DefaultPackagedProgramRetriever.createEntryClassInformationProvider(null, null, (String)"SomeJobClassNotBeingOnTheSystemClasspath", (String[])new String[0]);
        MatcherAssert.assertThat((Object)informationProvider.getJobClassName().isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat(informationProvider.getJobClassName().get(), (Matcher)Is.is((Object)"SomeJobClassNotBeingOnTheSystemClasspath"));
        MatcherAssert.assertThat((Object)informationProvider.getJarFile().isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testDeriveEntryClassInformationFromSystemClasspathWithExistingJobClassName() throws IOException, FlinkException {
        this.singleEntryClassClasspathProvider.setSystemClasspath();
        EntryClassInformationProvider informationProvider = DefaultPackagedProgramRetriever.createEntryClassInformationProvider(null, null, (String)this.singleEntryClassClasspathProvider.getJobClassName(), (String[])new String[0]);
        MatcherAssert.assertThat((Object)informationProvider.getJobClassName().isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat(informationProvider.getJobClassName().get(), (Matcher)Is.is((Object)this.singleEntryClassClasspathProvider.getJobClassName()));
        MatcherAssert.assertThat((Object)informationProvider.getJarFile().isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testDeriveEntryClassInformationFromSystemClasspathExtractingTheJobClassFromThere() throws IOException, FlinkException {
        this.singleEntryClassClasspathProvider.setSystemClasspath();
        EntryClassInformationProvider informationProvider = DefaultPackagedProgramRetriever.createEntryClassInformationProvider(null, null, null, (String[])new String[0]);
        MatcherAssert.assertThat((Object)informationProvider.getJobClassName().isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat(informationProvider.getJobClassName().get(), (Matcher)Is.is((Object)this.singleEntryClassClasspathProvider.getJobClassName()));
        MatcherAssert.assertThat((Object)informationProvider.getJarFile().isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testDeriveEntryClassInformationFromClasspathWithJobClass() throws IOException, FlinkException {
        EntryClassInformationProvider informationProvider = DefaultPackagedProgramRetriever.createEntryClassInformationProvider(this.multipleEntryClassesClasspathProvider.getURLUserClasspath(), null, (String)this.multipleEntryClassesClasspathProvider.getJobClassName(), (String[])new String[0]);
        MatcherAssert.assertThat((Object)informationProvider.getJobClassName().isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat(informationProvider.getJobClassName().get(), (Matcher)Is.is((Object)this.multipleEntryClassesClasspathProvider.getJobClassName()));
        MatcherAssert.assertThat((Object)informationProvider.getJarFile().isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testDeriveEntryClassInformationFromClasspathWithNoJobClass() throws IOException, FlinkException {
        EntryClassInformationProvider informationProvider = DefaultPackagedProgramRetriever.createEntryClassInformationProvider(this.singleEntryClassClasspathProvider.getURLUserClasspath(), null, null, (String[])new String[0]);
        MatcherAssert.assertThat((Object)informationProvider.getJobClassName().isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat(informationProvider.getJobClassName().get(), (Matcher)Is.is((Object)this.singleEntryClassClasspathProvider.getJobClassName()));
        MatcherAssert.assertThat((Object)informationProvider.getJarFile().isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testCreateWithUserLibDir() throws FlinkException {
        DefaultPackagedProgramRetriever retriever = DefaultPackagedProgramRetriever.create((File)this.singleEntryClassClasspathProvider.getDirectory(), null, (String)this.singleEntryClassClasspathProvider.getJobClassName(), (String[])new String[0], (Configuration)new Configuration());
        MatcherAssert.assertThat((Object)retriever.getPackagedProgram().getMainClassName(), (Matcher)Is.is((Object)this.singleEntryClassClasspathProvider.getJobClassName()));
    }

    @Test
    public void testJobGraphRetrieval() throws IOException, FlinkException, ProgramInvocationException {
        int parallelism = 42;
        JobID jobId = new JobID();
        Configuration configuration = new Configuration();
        configuration.setInteger(CoreOptions.DEFAULT_PARALLELISM, 42);
        configuration.set(PipelineOptionsInternal.PIPELINE_FIXED_JOB_ID, (Object)jobId.toHexString());
        String expectedSuffix = "suffix";
        DefaultPackagedProgramRetriever retriever = DefaultPackagedProgramRetriever.create(null, (String)this.testJobEntryClassClasspathProvider.getJobClassName(), (String[])ClasspathProvider.parametersForTestJob("suffix"), (Configuration)new Configuration());
        JobGraph jobGraph = this.retrieveJobGraph((PackagedProgramRetriever)retriever, configuration);
        MatcherAssert.assertThat((Object)jobGraph.getName(), (Matcher)Is.is((Object)(this.testJobEntryClassClasspathProvider.getJobClassName() + "-" + "suffix")));
        MatcherAssert.assertThat((Object)jobGraph.getSavepointRestoreSettings(), (Matcher)Is.is((Object)SavepointRestoreSettings.none()));
        MatcherAssert.assertThat((Object)jobGraph.getMaximumParallelism(), (Matcher)Is.is((Object)42));
        MatcherAssert.assertThat((Object)jobGraph.getJobID(), (Matcher)Is.is((Object)jobId));
    }

    @Test
    public void testJobGraphRetrievalFromJar() throws IOException, FlinkException, ProgramInvocationException {
        String expectedSuffix = "suffix";
        DefaultPackagedProgramRetriever retrieverUnderTest = DefaultPackagedProgramRetriever.create((File)this.testJobEntryClassClasspathProvider.getDirectory(), null, null, (String[])ClasspathProvider.parametersForTestJob("suffix"), (Configuration)new Configuration());
        JobGraph jobGraph = this.retrieveJobGraph((PackagedProgramRetriever)retrieverUnderTest, new Configuration());
        MatcherAssert.assertThat((Object)jobGraph.getName(), (Matcher)Is.is((Object)(this.testJobEntryClassClasspathProvider.getJobClassName() + "-" + "suffix")));
    }

    @Test
    public void testParameterConsiderationForMultipleJobsOnSystemClasspath() throws IOException, FlinkException, ProgramInvocationException {
        String expectedSuffix = "suffix";
        DefaultPackagedProgramRetriever retrieverUnderTest = DefaultPackagedProgramRetriever.create(null, (String)this.testJobEntryClassClasspathProvider.getJobClassName(), (String[])ClasspathProvider.parametersForTestJob("suffix"), (Configuration)new Configuration());
        JobGraph jobGraph = this.retrieveJobGraph((PackagedProgramRetriever)retrieverUnderTest, new Configuration());
        MatcherAssert.assertThat((Object)jobGraph.getName(), (Matcher)Is.is((Object)(this.testJobEntryClassClasspathProvider.getJobClassName() + "-suffix")));
    }

    @Test
    public void testSavepointRestoreSettings() throws FlinkException, IOException, ProgramInvocationException {
        Configuration configuration = new Configuration();
        SavepointRestoreSettings savepointRestoreSettings = SavepointRestoreSettings.forPath((String)"foobar", (boolean)true);
        JobID jobId = new JobID();
        configuration.setString(PipelineOptionsInternal.PIPELINE_FIXED_JOB_ID, jobId.toHexString());
        SavepointRestoreSettings.toConfiguration((SavepointRestoreSettings)savepointRestoreSettings, (Configuration)configuration);
        String expectedSuffix = "suffix";
        DefaultPackagedProgramRetriever retrieverUnderTest = DefaultPackagedProgramRetriever.create(null, (String)this.testJobEntryClassClasspathProvider.getJobClassName(), (String[])ClasspathProvider.parametersForTestJob("suffix"), (Configuration)new Configuration());
        JobGraph jobGraph = this.retrieveJobGraph((PackagedProgramRetriever)retrieverUnderTest, configuration);
        MatcherAssert.assertThat((Object)jobGraph.getSavepointRestoreSettings(), (Matcher)Is.is((Object)savepointRestoreSettings));
        MatcherAssert.assertThat((Object)jobGraph.getJobID(), (Matcher)Is.is((Object)jobId));
    }

    @Test
    public void testFailIfJobDirDoesNotHaveEntryClass() {
        try {
            DefaultPackagedProgramRetriever.create((File)this.noEntryClassClasspathProvider.getDirectory(), (String)this.testJobEntryClassClasspathProvider.getJobClassName(), (String[])ClasspathProvider.parametersForTestJob("suffix"), (Configuration)new Configuration());
            Assert.fail((String)"This case should throw exception !");
        }
        catch (FlinkException e) {
            MatcherAssert.assertThat((Object)((Object)e), (Matcher)FlinkMatchers.containsMessage((String)String.format("Could not find the provided job class (%s) in the user lib directory.", this.testJobEntryClassClasspathProvider.getJobClassName())));
        }
    }

    @Test(expected=FlinkException.class)
    public void testEntryClassNotFoundOnSystemClasspath() throws FlinkException {
        DefaultPackagedProgramRetriever testInstance = DefaultPackagedProgramRetriever.create(null, (String)"NotExistingClass", (String[])new String[0], (Configuration)new Configuration());
        testInstance.getPackagedProgram();
    }

    @Test(expected=FlinkException.class)
    public void testEntryClassNotFoundOnUserClasspath() throws FlinkException {
        DefaultPackagedProgramRetriever.create((File)this.noEntryClassClasspathProvider.getDirectory(), (String)"NotExistingClass", (String[])new String[0], (Configuration)new Configuration());
    }

    @Test(expected=FlinkException.class)
    public void testWithoutJobClassAndMultipleEntryClassesOnUserClasspath() throws FlinkException {
        DefaultPackagedProgramRetriever.create((File)this.multipleEntryClassesClasspathProvider.getDirectory(), null, (String[])new String[0], (Configuration)new Configuration());
    }

    @Test(expected=FlinkException.class)
    public void testWithoutJobClassAndMultipleEntryClassesOnSystemClasspath() throws FlinkException {
        DefaultPackagedProgramRetriever.create(null, null, (String[])new String[0], (Configuration)new Configuration());
    }

    @Test
    public void testWithJobClassAndMultipleEntryClassesOnUserClasspath() throws FlinkException {
        DefaultPackagedProgramRetriever retriever = DefaultPackagedProgramRetriever.create((File)this.multipleEntryClassesClasspathProvider.getDirectory(), (String)this.multipleEntryClassesClasspathProvider.getJobClassName(), (String[])new String[0], (Configuration)new Configuration());
        MatcherAssert.assertThat((Object)retriever.getPackagedProgram().getMainClassName(), (Matcher)Is.is((Object)this.multipleEntryClassesClasspathProvider.getJobClassName()));
    }

    @Test
    public void testWithJobClassAndMultipleEntryClassesOnSystemClasspath() throws FlinkException, MalformedURLException {
        this.multipleEntryClassesClasspathProvider.setSystemClasspath();
        DefaultPackagedProgramRetriever retriever = DefaultPackagedProgramRetriever.create(null, (String)this.multipleEntryClassesClasspathProvider.getJobClassName(), (String[])new String[0], (Configuration)new Configuration());
        MatcherAssert.assertThat((Object)retriever.getPackagedProgram().getMainClassName(), (Matcher)Is.is((Object)this.multipleEntryClassesClasspathProvider.getJobClassName()));
    }

    @Test
    public void testRetrieveCorrectUserClasspathsWithoutSpecifiedEntryClass() throws IOException, FlinkException, ProgramInvocationException {
        DefaultPackagedProgramRetriever retrieverUnderTest = DefaultPackagedProgramRetriever.create((File)this.singleEntryClassClasspathProvider.getDirectory(), null, (String[])ClasspathProvider.parametersForTestJob("suffix"), (Configuration)new Configuration());
        JobGraph jobGraph = this.retrieveJobGraph((PackagedProgramRetriever)retrieverUnderTest, new Configuration());
        List actualClasspath = jobGraph.getClasspaths().stream().map(URL::toString).collect(Collectors.toList());
        List<String> expectedClasspath = DefaultPackagedProgramRetrieverTest.extractRelativizedURLsForJarsFromDirectory(this.singleEntryClassClasspathProvider.getDirectory());
        MatcherAssert.assertThat(actualClasspath, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])expectedClasspath.toArray()));
    }

    @Test
    public void testRetrieveCorrectUserClasspathsWithSpecifiedEntryClass() throws IOException, FlinkException, ProgramInvocationException {
        DefaultPackagedProgramRetriever retrieverUnderTest = DefaultPackagedProgramRetriever.create((File)this.singleEntryClassClasspathProvider.getDirectory(), (String)this.singleEntryClassClasspathProvider.getJobClassName(), (String[])ClasspathProvider.parametersForTestJob("suffix"), (Configuration)new Configuration());
        JobGraph jobGraph = this.retrieveJobGraph((PackagedProgramRetriever)retrieverUnderTest, new Configuration());
        List actualClasspath = jobGraph.getClasspaths().stream().map(URL::toString).collect(Collectors.toList());
        List<String> expectedClasspath = DefaultPackagedProgramRetrieverTest.extractRelativizedURLsForJarsFromDirectory(this.singleEntryClassClasspathProvider.getDirectory());
        MatcherAssert.assertThat(actualClasspath, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])expectedClasspath.toArray()));
    }

    @Test
    public void testRetrieveCorrectUserClasspathsWithPipelineClasspaths() throws Exception {
        Configuration configuration = new Configuration();
        ArrayList<String> pipelineJars = new ArrayList<String>();
        ArrayList<URL> expectedMergedURLs = new ArrayList<URL>();
        for (URL jarFile : this.singleEntryClassClasspathProvider.getURLUserClasspath()) {
            pipelineJars.add(jarFile.toString());
            expectedMergedURLs.add(jarFile);
        }
        configuration.set(PipelineOptions.CLASSPATHS, pipelineJars);
        DefaultPackagedProgramRetriever retrieverUnderTest = DefaultPackagedProgramRetriever.create(null, (String)this.singleEntryClassClasspathProvider.getJobClassName(), (String[])ClasspathProvider.parametersForTestJob("suffix"), (Configuration)configuration);
        JobGraph jobGraph = this.retrieveJobGraph((PackagedProgramRetriever)retrieverUnderTest, new Configuration());
        MatcherAssert.assertThat((Object)jobGraph.getClasspaths(), (Matcher)Matchers.containsInAnyOrder((Object[])expectedMergedURLs.toArray()));
    }

    @Test
    public void testRetrieveFromJarFileWithoutUserLib() throws IOException, FlinkException, ProgramInvocationException {
        DefaultPackagedProgramRetriever retrieverUnderTest = DefaultPackagedProgramRetriever.create(null, (File)this.testJobEntryClassClasspathProvider.getJobJar(), null, (String[])ClasspathProvider.parametersForTestJob("suffix"), (Configuration)new Configuration());
        JobGraph jobGraph = this.retrieveJobGraph((PackagedProgramRetriever)retrieverUnderTest, new Configuration());
        MatcherAssert.assertThat((Object)jobGraph.getUserJars(), (Matcher)Matchers.containsInAnyOrder((Object[])new Path[]{new Path(this.testJobEntryClassClasspathProvider.getJobJar().toURI())}));
        MatcherAssert.assertThat((Object)jobGraph.getClasspaths().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testRetrieveFromJarFileWithUserLib() throws IOException, FlinkException, ProgramInvocationException {
        DefaultPackagedProgramRetriever retrieverUnderTest = DefaultPackagedProgramRetriever.create((File)this.singleEntryClassClasspathProvider.getDirectory(), (File)this.testJobEntryClassClasspathProvider.getJobJar(), null, (String[])ClasspathProvider.parametersForTestJob("suffix"), (Configuration)new Configuration());
        JobGraph jobGraph = this.retrieveJobGraph((PackagedProgramRetriever)retrieverUnderTest, new Configuration());
        MatcherAssert.assertThat((Object)jobGraph.getUserJars(), (Matcher)Matchers.containsInAnyOrder((Object[])new Path[]{new Path(this.testJobEntryClassClasspathProvider.getJobJar().toURI())}));
        List actualClasspath = jobGraph.getClasspaths().stream().map(URL::toString).collect(Collectors.toList());
        List<String> expectedClasspath = DefaultPackagedProgramRetrieverTest.extractRelativizedURLsForJarsFromDirectory(this.singleEntryClassClasspathProvider.getDirectory());
        MatcherAssert.assertThat(actualClasspath, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])expectedClasspath.toArray()));
    }

    @Test
    public void testChildFirstDefaultConfiguration() throws FlinkException {
        Configuration configuration = new Configuration();
        configuration.set(CoreOptions.CHECK_LEAKED_CLASSLOADER, (Object)false);
        DefaultPackagedProgramRetriever retriever = DefaultPackagedProgramRetriever.create((File)this.singleEntryClassClasspathProvider.getDirectory(), null, (String)this.singleEntryClassClasspathProvider.getJobClassName(), (String[])new String[0], (Configuration)configuration);
        MatcherAssert.assertThat((Object)retriever.getPackagedProgram().getUserCodeClassLoader(), (Matcher)IsInstanceOf.instanceOf(ChildFirstClassLoader.class));
    }

    @Test
    public void testConfigurationIsConsidered() throws FlinkException {
        String parentFirstConfigValue = "parent-first";
        MatcherAssert.assertThat((Object)CoreOptions.CLASSLOADER_RESOLVE_ORDER.defaultValue(), (Matcher)IsNot.not((Matcher)Is.is((Object)"parent-first")));
        Configuration configuration = new Configuration();
        configuration.set(CoreOptions.CLASSLOADER_RESOLVE_ORDER, (Object)"parent-first");
        configuration.set(CoreOptions.CHECK_LEAKED_CLASSLOADER, (Object)false);
        DefaultPackagedProgramRetriever retriever = DefaultPackagedProgramRetriever.create((File)this.singleEntryClassClasspathProvider.getDirectory(), null, (String)this.singleEntryClassClasspathProvider.getJobClassName(), (String[])new String[0], (Configuration)configuration);
        MatcherAssert.assertThat((Object)retriever.getPackagedProgram().getUserCodeClassLoader(), (Matcher)IsInstanceOf.instanceOf(FlinkUserCodeClassLoaders.ParentFirstClassLoader.class));
    }

    private JobGraph retrieveJobGraph(PackagedProgramRetriever retrieverUnderTest, Configuration configuration) throws FlinkException, ProgramInvocationException, MalformedURLException {
        PackagedProgram packagedProgram = retrieverUnderTest.getPackagedProgram();
        int defaultParallelism = configuration.getInteger(CoreOptions.DEFAULT_PARALLELISM);
        ConfigUtils.encodeCollectionToConfig((WritableConfig)configuration, (ConfigOption)PipelineOptions.JARS, (Collection)packagedProgram.getJobJarAndDependencies(), URL::toString);
        ConfigUtils.encodeCollectionToConfig((WritableConfig)configuration, (ConfigOption)PipelineOptions.CLASSPATHS, (Collection)packagedProgram.getClasspaths(), URL::toString);
        Pipeline pipeline = PackagedProgramUtils.getPipelineFromProgram((PackagedProgram)packagedProgram, (Configuration)configuration, (int)defaultParallelism, (boolean)false);
        return PipelineExecutorUtils.getJobGraph((Pipeline)pipeline, (Configuration)configuration);
    }

    private static List<String> extractRelativizedURLsForJarsFromDirectory(File directory) throws MalformedURLException {
        Preconditions.checkArgument((directory.listFiles() != null ? 1 : 0) != 0, (Object)("The passed File does not seem to be a directory or is not acessible: " + directory.getAbsolutePath()));
        ArrayList<String> relativizedURLs = new ArrayList<String>();
        java.nio.file.Path workingDirectory = FileUtils.getCurrentWorkingDirectory();
        for (File file : (File[])Preconditions.checkNotNull((Object)directory.listFiles())) {
            if (!FileUtils.isJarFile((java.nio.file.Path)file.toPath())) continue;
            java.nio.file.Path relativePath = FileUtils.relativizePath((java.nio.file.Path)workingDirectory, (java.nio.file.Path)file.toPath());
            relativizedURLs.add(FileUtils.toURL((java.nio.file.Path)relativePath).toString());
        }
        return relativizedURLs;
    }
}

