/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.io.Serializable;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.LocalEnvironment;
import org.apache.flink.api.java.aggregation.Aggregations;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.AggregateOperator;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class ExecutionPlanAfterExecutionTest
extends TestLogger
implements Serializable {
    @Test
    public void testExecuteAfterGetExecutionPlan() {
        LocalEnvironment env = new LocalEnvironment();
        DataSource baseSet = env.fromElements((Object[])new Integer[]{1, 2});
        MapOperator result = baseSet.map((MapFunction)new MapFunction<Integer, Integer>(){

            public Integer map(Integer value) throws Exception {
                return value * 2;
            }
        });
        result.output((OutputFormat)new DiscardingOutputFormat());
        try {
            env.getExecutionPlan();
            env.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Cannot run both #getExecutionPlan and #execute.");
        }
    }

    @Test
    public void testCreatePlanAfterGetExecutionPlan() {
        LocalEnvironment env = new LocalEnvironment();
        DataSource baseSet = env.fromElements((Object[])new Integer[]{1, 2});
        MapOperator result = baseSet.map((MapFunction)new MapFunction<Integer, Integer>(){

            public Integer map(Integer value) throws Exception {
                return value * 2;
            }
        });
        result.output((OutputFormat)new DiscardingOutputFormat());
        try {
            env.getExecutionPlan();
            env.createProgramPlan();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Cannot run both #getExecutionPlan and #execute. Message: " + e.getMessage()));
        }
    }

    @Test
    public void testGetExecutionPlanOfRangePartition() {
        LocalEnvironment env = new LocalEnvironment();
        DataSource baseSet = env.fromElements((Object[])new Integer[]{1, 2});
        AggregateOperator result = baseSet.map((MapFunction)new MapFunction<Integer, Tuple2<Integer, Integer>>(){

            public Tuple2<Integer, Integer> map(Integer value) throws Exception {
                return new Tuple2((Object)value, (Object)(value * 2));
            }
        }).partitionByRange(new int[]{0}).aggregate(Aggregations.MAX, 1);
        result.output((OutputFormat)new DiscardingOutputFormat());
        try {
            env.getExecutionPlan();
            env.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Cannot run both #getExecutionPlan and #execute.");
        }
    }
}

