/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.ProgramDescription;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.PackagedProgramUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.Optimizer;
import org.apache.flink.optimizer.costs.CostEstimator;
import org.apache.flink.optimizer.costs.DefaultCostEstimator;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plandump.PlanJSONDumpGenerator;
import org.junit.Assert;
import org.junit.Test;

public class ExecutionPlanCreationTest {
    @Test
    public void testGetExecutionPlan() {
        try {
            PackagedProgram prg = PackagedProgram.newBuilder().setEntryPointClassName(TestOptimizerPlan.class.getName()).setArguments(new String[]{"/dev/random", "/tmp"}).build();
            InetAddress mockAddress = InetAddress.getLocalHost();
            InetSocketAddress mockJmAddress = new InetSocketAddress(mockAddress, 12345);
            Configuration config = new Configuration();
            config.setString(JobManagerOptions.ADDRESS, mockJmAddress.getHostName());
            config.setInteger(JobManagerOptions.PORT, mockJmAddress.getPort());
            Optimizer optimizer = new Optimizer(new DataStatistics(), (CostEstimator)new DefaultCostEstimator(), config);
            Plan plan = (Plan)PackagedProgramUtils.getPipelineFromProgram((PackagedProgram)prg, (Configuration)config, (int)-1, (boolean)true);
            OptimizedPlan op = optimizer.compile(plan);
            Assert.assertNotNull((Object)op);
            PlanJSONDumpGenerator dumper = new PlanJSONDumpGenerator();
            Assert.assertNotNull((Object)dumper.getOptimizerPlanAsJSON(op));
            PlanJSONDumpGenerator dumper2 = new PlanJSONDumpGenerator();
            dumper2.setEncodeForHTML(true);
            String htmlEscaped = dumper2.getOptimizerPlanAsJSON(op);
            Assert.assertEquals((long)-1L, (long)htmlEscaped.indexOf(92));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public static class TestOptimizerPlan
    implements ProgramDescription {
        public static void main(String[] args) throws Exception {
            if (args.length < 2) {
                System.err.println("Usage: TestOptimizerPlan <input-file-path> <output-file-path>");
                return;
            }
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource input = env.readCsvFile(args[0]).fieldDelimiter("\t").types(Long.class, Long.class);
            MapOperator result = input.map((MapFunction)new MapFunction<Tuple2<Long, Long>, Tuple2<Long, Long>>(){

                public Tuple2<Long, Long> map(Tuple2<Long, Long> value) {
                    return new Tuple2(value.f0, (Object)((Long)value.f1 + 1L));
                }
            });
            result.writeAsCsv(args[1], "\n", "\t");
            env.execute();
        }

        public String getDescription() {
            return "TestOptimizerPlan <input-file-path> <output-file-path>";
        }
    }
}

