/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.PackagedProgramUtils;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.configuration.Configuration;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class OptimizerPlanEnvironmentTest {
    @Test
    public void testStdOutStdErrHandling() throws Exception {
        this.runOutputTest(true, new String[]{"System.out: hello out!", "System.err: hello err!"});
        this.runOutputTest(false, new String[]{"System.out: (none)", "System.err: (none)"});
    }

    private void runOutputTest(boolean suppressOutput, String[] expectedCapturedOutput) throws ProgramInvocationException {
        PackagedProgram packagedProgram = PackagedProgram.newBuilder().setEntryPointClassName(this.getClass().getName()).build();
        try {
            PackagedProgramUtils.getPipelineFromProgram((PackagedProgram)packagedProgram, (Configuration)new Configuration(), (int)1, (boolean)suppressOutput);
            Assert.fail((String)"This should have failed to create the Flink Plan.");
        }
        catch (ProgramInvocationException e) {
            for (String expected : expectedCapturedOutput) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)expected));
            }
        }
    }

    public static void main(String[] args) {
        System.out.println("hello out!");
        System.err.println("hello err!");
    }
}

