/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.flink.client.cli.CliFrontendTestUtils;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.configuration.ConfigConstants;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class PackagedProgramTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testExtractContainedLibraries() throws Exception {
        String s = "testExtractContainedLibraries";
        byte[] nestedJarContent = s.getBytes(ConfigConstants.DEFAULT_CHARSET);
        File fakeJar = this.temporaryFolder.newFile("test.jar");
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(fakeJar));){
            ZipEntry entry = new ZipEntry("lib/internalTest.jar");
            zos.putNextEntry(entry);
            zos.write(nestedJarContent);
            zos.closeEntry();
        }
        List files = PackagedProgram.extractContainedLibraries((URL)fakeJar.toURI().toURL());
        Assert.assertEquals((long)1L, (long)files.size());
        Assert.assertArrayEquals((byte[])nestedJarContent, (byte[])Files.readAllBytes(((File)files.iterator().next()).toPath()));
    }

    @Test
    public void testNotThrowExceptionWhenJarFileIsNull() throws Exception {
        PackagedProgram.newBuilder().setUserClassPaths(Collections.singletonList(new File(CliFrontendTestUtils.getTestJarPath()).toURI().toURL())).setEntryPointClassName("org.apache.flink.client.testjar.TestJob");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBuilderThrowExceptionIfjarFileAndEntryPointClassNameAreBothNull() throws ProgramInvocationException {
        PackagedProgram.newBuilder().build();
    }
}

