/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.PackagedProgramUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.testutils.ClassLoaderUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PackagedProgramUtilsPipelineTest {
    @Parameterized.Parameter
    public TestParameter testParameter;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Parameterized.Parameters
    public static Collection<TestParameter> parameters() {
        return Arrays.asList(TestParameter.of(DataSetTestProgram.class, pipeline -> ((Plan)pipeline).getExecutionConfig()), TestParameter.of(DataStreamTestProgram.class, pipeline -> ((StreamGraph)pipeline).getExecutionConfig()));
    }

    @Test
    public void testConfigurationForwarding() throws Exception {
        Assert.assertThat((Object)ExecutionEnvironment.getExecutionEnvironment().getConfig().isAutoTypeRegistrationDisabled(), (Matcher)Matchers.is((Object)false));
        PackagedProgram packagedProgram = PackagedProgram.newBuilder().setEntryPointClassName(this.testParameter.entryClass().getName()).build();
        Configuration config = new Configuration();
        config.set(PipelineOptions.AUTO_TYPE_REGISTRATION, (Object)false);
        Pipeline pipeline = PackagedProgramUtils.getPipelineFromProgram((PackagedProgram)packagedProgram, (Configuration)config, (int)1, (boolean)false);
        ExecutionConfig executionConfig = this.testParameter.extractExecutionConfig(pipeline);
        Assert.assertThat((Object)executionConfig.isAutoTypeRegistrationDisabled(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testUserClassloaderForConfiguration() throws Exception {
        String userSerializerClassName = "UserSerializer";
        List<URL> userUrls = this.getClassUrls(userSerializerClassName);
        PackagedProgram packagedProgram = PackagedProgram.newBuilder().setUserClassPaths(userUrls).setEntryPointClassName(this.testParameter.entryClass().getName()).build();
        Configuration config = new Configuration();
        config.set(PipelineOptions.KRYO_DEFAULT_SERIALIZERS, Collections.singletonList(String.format("class:%s,serializer:%s", PackagedProgramUtilsPipelineTest.class.getName(), userSerializerClassName)));
        Pipeline pipeline = PackagedProgramUtils.getPipelineFromProgram((PackagedProgram)packagedProgram, (Configuration)config, (int)1, (boolean)false);
        ExecutionConfig executionConfig = this.testParameter.extractExecutionConfig(pipeline);
        Assert.assertThat((Object)((Class)executionConfig.getDefaultKryoSerializerClasses().get(PackagedProgramUtilsPipelineTest.class)).getName(), (Matcher)Matchers.is((Object)userSerializerClassName));
    }

    private List<URL> getClassUrls(String className) throws IOException {
        URLClassLoader urlClassLoader = ClassLoaderUtils.compileAndLoadJava((File)this.temporaryFolder.newFolder(), (String)(className + ".java"), (String)("import com.esotericsoftware.kryo.Kryo;\nimport com.esotericsoftware.kryo.Serializer;\nimport com.esotericsoftware.kryo.io.Input;\nimport com.esotericsoftware.kryo.io.Output;\npublic class " + className + " extends Serializer {\n\t@Override\n\tpublic void write(\n\t\tKryo kryo,\n\t\tOutput output,\n\t\tObject object) {\n\t}\n\n\t@Override\n\tpublic Object read(Kryo kryo, Input input, Class type) {\n\t\treturn null;\n\t}\n}"));
        return Arrays.asList(urlClassLoader.getURLs());
    }

    public static class DataStreamTestProgram {
        public static void main(String[] args) throws Exception {
            StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
            env.fromElements((Object[])new String[]{"hello"}).print();
            env.execute();
        }
    }

    public static class DataSetTestProgram {
        public static void main(String[] args) throws Exception {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            env.fromElements((Object[])new String[]{"hello"}).print();
            env.execute();
        }
    }

    private static interface TestParameter {
        public Class<?> entryClass();

        public ExecutionConfig extractExecutionConfig(Pipeline var1);

        public static TestParameter of(final Class<?> entryClass, final Function<Pipeline, ExecutionConfig> executionConfigExtractor) {
            return new TestParameter(){

                @Override
                public Class<?> entryClass() {
                    return entryClass;
                }

                @Override
                public ExecutionConfig extractExecutionConfig(Pipeline pipeline) {
                    return (ExecutionConfig)executionConfigExtractor.apply(pipeline);
                }
            };
        }
    }
}

