/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.io.File;
import java.net.URISyntaxException;
import org.apache.flink.client.program.PackagedProgramUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class PackagedProgramUtilsTest {
    @Test
    public void testResolveURI() throws URISyntaxException {
        String relativeFile = "path/of/user.jar";
        Assert.assertThat((Object)PackagedProgramUtils.resolveURI((String)"path/of/user.jar").getScheme(), (Matcher)Matchers.is((Object)"file"));
        Assert.assertThat((Object)PackagedProgramUtils.resolveURI((String)"path/of/user.jar").getPath(), (Matcher)Matchers.is((Object)new File(System.getProperty("user.dir"), "path/of/user.jar").getAbsolutePath()));
        String absoluteFile = "/path/of/user.jar";
        Assert.assertThat((Object)PackagedProgramUtils.resolveURI((String)"path/of/user.jar").getScheme(), (Matcher)Matchers.is((Object)"file"));
        Assert.assertThat((Object)PackagedProgramUtils.resolveURI((String)"/path/of/user.jar").getPath(), (Matcher)Matchers.is((Object)"/path/of/user.jar"));
        String fileSchemaFile = "file:///path/of/user.jar";
        Assert.assertThat((Object)PackagedProgramUtils.resolveURI((String)"file:///path/of/user.jar").getScheme(), (Matcher)Matchers.is((Object)"file"));
        Assert.assertThat((Object)PackagedProgramUtils.resolveURI((String)"file:///path/of/user.jar").toString(), (Matcher)Matchers.is((Object)"file:///path/of/user.jar"));
        String localSchemaFile = "local:///path/of/user.jar";
        Assert.assertThat((Object)PackagedProgramUtils.resolveURI((String)"local:///path/of/user.jar").getScheme(), (Matcher)Matchers.is((Object)"local"));
        Assert.assertThat((Object)PackagedProgramUtils.resolveURI((String)"local:///path/of/user.jar").toString(), (Matcher)Matchers.is((Object)"local:///path/of/user.jar"));
    }
}

