/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.client.JobStatusMessage;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.operators.coordination.CoordinationRequest;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;
import org.apache.flink.util.function.TriFunction;

public class TestingClusterClient<T>
implements ClusterClient<T> {
    private Function<JobID, CompletableFuture<Acknowledge>> cancelFunction = ignore -> CompletableFuture.completedFuture(Acknowledge.get());
    private BiFunction<JobID, String, CompletableFuture<String>> cancelWithSavepointFunction = (ignore, savepointPath) -> CompletableFuture.completedFuture(savepointPath);
    private TriFunction<JobID, Boolean, String, CompletableFuture<String>> stopWithSavepointFunction = (ignore1, ignore2, savepointPath) -> CompletableFuture.completedFuture(savepointPath);
    private BiFunction<JobID, String, CompletableFuture<String>> triggerSavepointFunction = (ignore, savepointPath) -> CompletableFuture.completedFuture(savepointPath);

    public void setCancelFunction(Function<JobID, CompletableFuture<Acknowledge>> cancelFunction) {
        this.cancelFunction = cancelFunction;
    }

    public void setCancelWithSavepointFunction(BiFunction<JobID, String, CompletableFuture<String>> cancelWithSavepointFunction) {
        this.cancelWithSavepointFunction = cancelWithSavepointFunction;
    }

    public void setStopWithSavepointFunction(TriFunction<JobID, Boolean, String, CompletableFuture<String>> stopWithSavepointFunction) {
        this.stopWithSavepointFunction = stopWithSavepointFunction;
    }

    public void setTriggerSavepointFunction(BiFunction<JobID, String, CompletableFuture<String>> triggerSavepointFunction) {
        this.triggerSavepointFunction = triggerSavepointFunction;
    }

    public T getClusterId() {
        throw new UnsupportedOperationException();
    }

    public Configuration getFlinkConfiguration() {
        throw new UnsupportedOperationException();
    }

    public void shutDownCluster() {
        throw new UnsupportedOperationException();
    }

    public String getWebInterfaceURL() {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Collection<JobStatusMessage>> listJobs() {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Acknowledge> disposeSavepoint(String savepointPath) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<JobID> submitJob(@Nonnull JobGraph jobGraph) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<JobStatus> getJobStatus(JobID jobId) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<JobResult> requestJobResult(@Nonnull JobID jobId) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Map<String, Object>> getAccumulators(JobID jobID, ClassLoader loader) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Acknowledge> cancel(JobID jobId) {
        return this.cancelFunction.apply(jobId);
    }

    public CompletableFuture<String> cancelWithSavepoint(JobID jobId, @Nullable String savepointDirectory) {
        return this.cancelWithSavepointFunction.apply(jobId, savepointDirectory);
    }

    public CompletableFuture<String> stopWithSavepoint(JobID jobId, boolean advanceToEndOfEventTime, @Nullable String savepointDirectory) {
        return (CompletableFuture)this.stopWithSavepointFunction.apply((Object)jobId, (Object)advanceToEndOfEventTime, (Object)savepointDirectory);
    }

    public CompletableFuture<String> triggerSavepoint(JobID jobId, @Nullable String savepointDirectory) {
        return this.triggerSavepointFunction.apply(jobId, savepointDirectory);
    }

    public CompletableFuture<CoordinationResponse> sendCoordinationRequest(JobID jobId, OperatorID operatorId, CoordinationRequest request) {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }
}

