/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program.rest.retry;

import org.apache.flink.client.program.rest.retry.ExponentialWaitStrategy;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ExponentialWaitStrategyTest
extends TestLogger {
    @Test
    public void testNegativeInitialWait() {
        try {
            new ExponentialWaitStrategy(0L, 1L);
            Assert.fail((String)"Expected exception not thrown.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"initialWait must be positive"));
        }
    }

    @Test
    public void testNegativeMaxWait() {
        try {
            new ExponentialWaitStrategy(1L, -1L);
            Assert.fail((String)"Expected exception not thrown.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"maxWait must be positive"));
        }
    }

    @Test
    public void testInitialWaitGreaterThanMaxWait() {
        try {
            new ExponentialWaitStrategy(2L, 1L);
            Assert.fail((String)"Expected exception not thrown.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"initialWait must be lower than or equal to maxWait"));
        }
    }

    @Test
    public void testMaxSleepTime() {
        long sleepTime = new ExponentialWaitStrategy(1L, 1L).sleepTime(100L);
        Assert.assertThat((Object)sleepTime, (Matcher)Matchers.equalTo((Object)1L));
    }

    @Test
    public void testExponentialGrowth() {
        ExponentialWaitStrategy exponentialWaitStrategy = new ExponentialWaitStrategy(1L, 1000L);
        Assert.assertThat((Object)(exponentialWaitStrategy.sleepTime(3L) / exponentialWaitStrategy.sleepTime(2L)), (Matcher)Matchers.equalTo((Object)2L));
    }

    @Test
    public void testMaxAttempts() {
        long maxWait = 1000L;
        ExponentialWaitStrategy exponentialWaitStrategy = new ExponentialWaitStrategy(1L, 1000L);
        Assert.assertThat((Object)exponentialWaitStrategy.sleepTime(Long.MAX_VALUE), (Matcher)Matchers.equalTo((Object)1000L));
    }

    @Test
    public void test64Attempts() {
        long maxWait = 1000L;
        ExponentialWaitStrategy exponentialWaitStrategy = new ExponentialWaitStrategy(1L, 1000L);
        Assert.assertThat((Object)exponentialWaitStrategy.sleepTime(64L), (Matcher)Matchers.equalTo((Object)1000L));
    }
}

