/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.testjar;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.client.cli.CliFrontendTestUtils;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.util.FlinkException;

public class BlockingJob {
    private static final ConcurrentMap<String, CountDownLatch> RUNNING = new ConcurrentHashMap<String, CountDownLatch>();
    private static final ConcurrentMap<String, CountDownLatch> BLOCKED = new ConcurrentHashMap<String, CountDownLatch>();

    public static PackagedProgram getProgram(String blockId) throws FlinkException {
        try {
            return PackagedProgram.newBuilder().setUserClassPaths(Collections.singletonList(new File(CliFrontendTestUtils.getTestJarPath()).toURI().toURL())).setEntryPointClassName(BlockingJob.class.getName()).setArguments(new String[]{blockId}).build();
        }
        catch (FileNotFoundException | MalformedURLException | ProgramInvocationException e) {
            throw new FlinkException("Could not load the provided entrypoint class.", e);
        }
    }

    public static void cleanUp(String blockId) {
        RUNNING.remove(blockId);
        BLOCKED.remove(blockId);
    }

    public static void awaitRunning(String blockId) throws InterruptedException {
        RUNNING.computeIfAbsent(blockId, ignored -> new CountDownLatch(1)).await();
    }

    public static void unblock(String blockId) {
        BLOCKED.computeIfAbsent(blockId, ignored -> new CountDownLatch(1)).countDown();
    }

    public static void main(String[] args) throws Exception {
        String blockId = args[0];
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.fromCollection(Arrays.asList(1, 2, 3)).map((MapFunction & Serializable)element -> element + 1).map((MapFunction & Serializable)element -> {
            RUNNING.computeIfAbsent(blockId, ignored -> new CountDownLatch(1)).countDown();
            BLOCKED.computeIfAbsent(blockId, ignored -> new CountDownLatch(1)).await();
            return element;
        }).output((OutputFormat)new DiscardingOutputFormat());
        env.execute();
    }
}

