/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.testjar;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.flink.client.deployment.application.JarManifestParser;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.ThrowingConsumer;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;

public class ClasspathProvider
extends ExternalResource {
    private static final String CLASSPATH_PROPERTY_NAME = "java.class.path";
    private static final Path TEST_JOB_JAR_PATH = Paths.get("target", "maven-test-jar.jar");
    private static final Path JOB_JAR_PATH = Paths.get("target", "maven-test-user-classloader-job-jar.jar");
    private static final Path JOB_LIB_JAR_PATH = Paths.get("target", "maven-test-user-classloader-job-lib-jar.jar");
    private final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private final String directoryNameSuffix;
    private final ThrowingConsumer<File, IOException> directoryContentCreator;
    @Nullable
    private final String jobClassName;
    @Nullable
    private final File jarFile;
    private File directory;
    private final String originalSystemClasspath;

    public static ClasspathProvider createWithNoEntryClass() {
        return new ClasspathProvider("_user_dir_with_no_entry_class", (ThrowingConsumer<File, IOException>)((ThrowingConsumer)directory -> {
            ClasspathProvider.copyJar(JOB_LIB_JAR_PATH, directory);
            ClasspathProvider.createTestFile(directory);
        }));
    }

    public static ClasspathProvider createWithSingleEntryClass() {
        return new ClasspathProvider("_user_dir_with_single_entry_class", (ThrowingConsumer<File, IOException>)((ThrowingConsumer)directory -> {
            ClasspathProvider.copyJar(JOB_LIB_JAR_PATH, directory);
            ClasspathProvider.copyJar(JOB_JAR_PATH, directory);
            ClasspathProvider.createTestFile(directory);
        }), JOB_JAR_PATH.toFile());
    }

    public static ClasspathProvider createWithMultipleEntryClasses() {
        return new ClasspathProvider("_user_dir_with_multiple_entry_classes", (ThrowingConsumer<File, IOException>)((ThrowingConsumer)directory -> {
            ClasspathProvider.copyJar(JOB_LIB_JAR_PATH, directory);
            ClasspathProvider.copyJar(JOB_JAR_PATH, directory);
            ClasspathProvider.copyJar(TEST_JOB_JAR_PATH, directory);
            ClasspathProvider.createTestFile(directory);
        }), TEST_JOB_JAR_PATH.toFile());
    }

    public static ClasspathProvider createWithTestJobOnly() {
        return new ClasspathProvider("_user_dir_with_testjob_entry_class_only", (ThrowingConsumer<File, IOException>)((ThrowingConsumer)directory -> ClasspathProvider.copyJar(TEST_JOB_JAR_PATH, directory)), TEST_JOB_JAR_PATH.toFile());
    }

    public static String[] parametersForTestJob(String strValue) {
        return new String[]{"--arg", strValue};
    }

    public static ClasspathProvider createWithTextFileOnly() {
        return new ClasspathProvider("_user_dir_with_text_file_only", (ThrowingConsumer<File, IOException>)((ThrowingConsumer)ClasspathProvider::createTestFile));
    }

    private static void copyJar(Path sourcePath, File targetDir) throws IOException {
        Files.copy(sourcePath, targetDir.toPath().resolve(sourcePath.toFile().getName()), new CopyOption[0]);
    }

    private static void createTestFile(File targetDir) throws IOException {
        Files.createFile(targetDir.toPath().resolve("test.txt"), new FileAttribute[0]);
    }

    private ClasspathProvider(String directoryNameSuffix, ThrowingConsumer<File, IOException> directoryContentCreator) {
        this(directoryNameSuffix, directoryContentCreator, null, null);
    }

    private ClasspathProvider(String directoryNameSuffix, ThrowingConsumer<File, IOException> directoryContentCreator, File jarFile) {
        this(directoryNameSuffix, directoryContentCreator, jarFile, ClasspathProvider.extractEntryClassNameFromJar(jarFile));
    }

    private ClasspathProvider(String directoryNameSuffix, ThrowingConsumer<File, IOException> directoryContentCreator, @Nullable File jarFile, @Nullable String jobClassName) {
        this.directoryNameSuffix = (String)Preconditions.checkNotNull((Object)directoryNameSuffix, (String)"No directory specified.");
        this.directoryContentCreator = (ThrowingConsumer)Preconditions.checkNotNull(directoryContentCreator, (String)"No logic for filling the directory specified.");
        this.jarFile = jarFile;
        this.jobClassName = jobClassName;
        this.originalSystemClasspath = System.getProperty(CLASSPATH_PROPERTY_NAME);
    }

    public void before() throws IOException {
        this.temporaryFolder.create();
        this.directory = this.temporaryFolder.newFolder(this.directoryNameSuffix);
        this.directoryContentCreator.accept((Object)this.directory);
    }

    protected void after() {
        this.temporaryFolder.delete();
        this.resetSystemClasspath();
    }

    @Nullable
    public String getJobClassName() {
        return this.jobClassName;
    }

    public File getJobJar() {
        if (this.jarFile == null) {
            throw new UnsupportedOperationException("There's no job jar specified for " + this.directory.getName());
        }
        return this.jarFile;
    }

    private static String extractEntryClassNameFromJar(File f) {
        try {
            return (String)JarManifestParser.findFirstManifestAttribute((File)f, (String[])new String[]{"Main-Class"}).orElseThrow(() -> new IllegalArgumentException("The passed file does not contain a main class: " + f.getAbsolutePath()));
        }
        catch (Throwable t) {
            throw new AssertionError("Something went wrong with retrieving the main class from " + f.getAbsolutePath(), t);
        }
    }

    public File getDirectory() {
        return this.directory;
    }

    public Iterable<URL> getURLUserClasspath() throws MalformedURLException {
        ArrayList<URL> list = new ArrayList<URL>();
        for (File file : ClasspathProvider.getFileUserClasspath(this.getDirectory())) {
            list.add(file.toURI().toURL());
        }
        return list;
    }

    public void setSystemClasspath() throws MalformedURLException {
        String classpathStr = ClasspathProvider.generateClasspathString(this.getURLUserClasspath());
        System.setProperty(CLASSPATH_PROPERTY_NAME, classpathStr);
    }

    public void resetSystemClasspath() {
        System.setProperty(CLASSPATH_PROPERTY_NAME, this.originalSystemClasspath);
    }

    private static String generateClasspathString(Iterable<URL> classpath) {
        String pathSeparator = System.getProperty("path.separator");
        return StreamSupport.stream(classpath.spliterator(), false).map(URL::toString).collect(Collectors.joining(pathSeparator));
    }

    private static List<File> getFileUserClasspath(File parentFolder) {
        return Arrays.asList((Object[])Objects.requireNonNull(parentFolder.listFiles()));
    }
}

