/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.testjar;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.client.cli.CliFrontendTestUtils;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.util.FlinkException;

public class MultiExecuteJob {
    public static PackagedProgram getProgram(int noOfJobs, boolean attached) throws FlinkException {
        try {
            return PackagedProgram.newBuilder().setUserClassPaths(Collections.singletonList(new File(CliFrontendTestUtils.getTestJarPath()).toURI().toURL())).setEntryPointClassName(MultiExecuteJob.class.getName()).setArguments(new String[]{String.valueOf(noOfJobs), Boolean.toString(attached)}).build();
        }
        catch (FileNotFoundException | MalformedURLException | ProgramInvocationException e) {
            throw new FlinkException("Could not load the provided entrypoint class.", e);
        }
    }

    public static void main(String[] args) throws Exception {
        int noOfExecutes = Integer.parseInt(args[0]);
        boolean attached = args.length > 1 && Boolean.parseBoolean(args[1]);
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        for (int i = 0; i < noOfExecutes; ++i) {
            ArrayList<Integer> input = new ArrayList<Integer>();
            input.add(1);
            input.add(2);
            input.add(3);
            env.fromCollection(input).map((MapFunction & Serializable)element -> element + 1).output((OutputFormat)new DiscardingOutputFormat());
            if (attached) {
                env.execute();
                continue;
            }
            env.executeAsync();
        }
    }
}

