/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.testjar;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.DiscardingSink;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;

public class TestJob {
    public static void main(String[] args) throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DataStreamSource source = env.fromElements((Object[])new Integer[]{1, 2, 3, 4});
        SingleOutputStreamOperator mapper = source.map((MapFunction & Serializable)element -> 2 * element);
        mapper.addSink((SinkFunction)new DiscardingSink());
        ParameterTool parameterTool = ParameterTool.fromArgs((String[])args);
        env.execute(TestJob.class.getCanonicalName() + "-" + parameterTool.getRequired("arg"));
    }

    public static File getTestJobJar() throws FileNotFoundException {
        File f = new File("target/maven-test-jar.jar");
        if (!f.exists()) {
            throw new FileNotFoundException("Test jar not present. Invoke tests using Maven or build the jar using 'mvn process-test-classes' in flink-clients");
        }
        return f;
    }
}

