/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.connector.hbase.util.HBaseConfigurationUtil;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.hadoop.conf.Configuration;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class HBaseConfigLoadingTest {
    private static final String IN_HBASE_CONFIG_KEY = "hbase_conf_key";
    private static final String IN_HBASE_CONFIG_VALUE = "hbase_conf_value!";
    @TempDir
    Path tmpDir;

    HBaseConfigLoadingTest() {
    }

    @Test
    void loadFromClasspathByDefault() {
        Configuration hbaseConf = HBaseConfigurationUtil.getHBaseConfiguration();
        Assertions.assertThat((String)hbaseConf.get(IN_HBASE_CONFIG_KEY, null)).isEqualTo(IN_HBASE_CONFIG_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void loadFromEnvVariables() throws Exception {
        Configuration hbaseConf;
        String k1 = "where?";
        String v1 = "I'm on a boat";
        String k2 = "when?";
        String v2 = "midnight";
        String k3 = "why?";
        String v3 = "what do you think?";
        String k4 = "which way?";
        String v4 = "south, always south...";
        File hbaseConfDir = this.tmpDir.toFile();
        File hbaseHome = Files.createTempDirectory(this.tmpDir, "junit_hbaseHome_", new FileAttribute[0]).toFile();
        File hbaseHomeConf = new File(hbaseHome, "conf");
        Assertions.assertThat((boolean)hbaseHomeConf.mkdirs()).isTrue();
        File file1 = new File(hbaseConfDir, "hbase-default.xml");
        File file2 = new File(hbaseConfDir, "hbase-site.xml");
        File file3 = new File(hbaseHomeConf, "hbase-default.xml");
        File file4 = new File(hbaseHomeConf, "hbase-site.xml");
        HBaseConfigLoadingTest.printConfig(file1, "where?", "I'm on a boat");
        HBaseConfigLoadingTest.printConfig(file2, "when?", "midnight");
        HBaseConfigLoadingTest.printConfig(file3, "why?", "what do you think?");
        HBaseConfigLoadingTest.printConfig(file4, "which way?", "south, always south...");
        Map<String, String> originalEnv = System.getenv();
        HashMap<String, String> newEnv = new HashMap<String, String>(originalEnv);
        newEnv.put("HBASE_CONF_DIR", hbaseConfDir.getAbsolutePath());
        newEnv.put("HBASE_HOME", hbaseHome.getAbsolutePath());
        try {
            CommonTestUtils.setEnv(newEnv);
            hbaseConf = HBaseConfigurationUtil.getHBaseConfiguration();
        }
        finally {
            CommonTestUtils.setEnv(originalEnv);
        }
        Assertions.assertThat((String)hbaseConf.get("where?", null)).isEqualTo("I'm on a boat");
        Assertions.assertThat((String)hbaseConf.get("when?", null)).isEqualTo("midnight");
        Assertions.assertThat((String)hbaseConf.get("why?", null)).isEqualTo("what do you think?");
        Assertions.assertThat((String)hbaseConf.get("which way?", null)).isEqualTo("south, always south...");
        Assertions.assertThat((String)hbaseConf.get(IN_HBASE_CONFIG_KEY, null)).isEqualTo(IN_HBASE_CONFIG_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void loadOverlappingConfig() throws Exception {
        Configuration hbaseConf;
        String k1 = "key1";
        String v1 = "from HBASE_HOME/conf";
        String v2 = "from HBASE_CONF_DIR";
        File hbaseHome = this.tmpDir.resolve("hbaseHome").toFile();
        File hbaseHomeConf = new File(hbaseHome, "conf");
        File hbaseConfDir = this.tmpDir.resolve("hbaseConfDir").toFile();
        Assertions.assertThat((boolean)hbaseHomeConf.mkdirs()).isTrue();
        File file1 = new File(hbaseHomeConf, "hbase-site.xml");
        HashMap<String, String> properties1 = new HashMap<String, String>();
        properties1.put("key1", "from HBASE_HOME/conf");
        HBaseConfigLoadingTest.printConfigs(file1, properties1);
        Assertions.assertThat((boolean)hbaseConfDir.mkdirs()).isTrue();
        File file2 = new File(hbaseConfDir, "hbase-site.xml");
        HashMap<String, String> properties2 = new HashMap<String, String>();
        properties2.put("key1", "from HBASE_CONF_DIR");
        HBaseConfigLoadingTest.printConfigs(file2, properties2);
        Map<String, String> originalEnv = System.getenv();
        HashMap<String, String> newEnv = new HashMap<String, String>(originalEnv);
        newEnv.put("HBASE_CONF_DIR", hbaseConfDir.getAbsolutePath());
        newEnv.put("HBASE_HOME", hbaseHome.getAbsolutePath());
        try {
            CommonTestUtils.setEnv(newEnv);
            hbaseConf = HBaseConfigurationUtil.getHBaseConfiguration();
        }
        finally {
            CommonTestUtils.setEnv(originalEnv);
        }
        Assertions.assertThat((String)hbaseConf.get("key1", null)).isEqualTo("from HBASE_CONF_DIR");
        Assertions.assertThat((String)hbaseConf.get(IN_HBASE_CONFIG_KEY, null)).isEqualTo(IN_HBASE_CONFIG_VALUE);
    }

    private static void printConfig(File file, String key, String value) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put(key, value);
        HBaseConfigLoadingTest.printConfigs(file, map);
    }

    private static void printConfigs(File file, Map<String, String> properties) throws IOException {
        try (PrintStream out = new PrintStream(new FileOutputStream(file));){
            out.println("<?xml version=\"1.0\"?>");
            out.println("<?xml-stylesheet type=\"text/xsl\" href=\"configuration.xsl\"?>");
            out.println("<configuration>");
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                out.println("\t<property>");
                out.println("\t\t<name>" + entry.getKey() + "</name>");
                out.println("\t\t<value>" + entry.getValue() + "</value>");
                out.println("\t</property>");
            }
            out.println("</configuration>");
        }
    }
}

