/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.connector.hbase.util.HBaseSerde;
import org.apache.flink.connector.hbase.util.HBaseTableSchema;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class HBaseSerdeTest {
    private static final String ROW_KEY = "rowkey";
    private static final String FAMILY1 = "family1";
    private static final String F1COL1 = "col1";
    private static final String FAMILY2 = "family2";
    private static final String F2COL1 = "col1";
    private static final String F2COL2 = "col2";
    private static final String FAMILY3 = "family3";
    private static final String F3COL1 = "col1";
    private static final String F3COL2 = "col2";
    private static final String F3COL3 = "col3";

    HBaseSerdeTest() {
    }

    @Test
    void convertToNewRowTest() {
        HBaseSerde serde = this.createHBaseSerde();
        List<List<Cell>> cellsList = this.prepareCells();
        ArrayList<RowData> resultRowDatas = new ArrayList<RowData>();
        ArrayList<String> resultRowDataStr = new ArrayList<String>();
        for (List<Cell> cells : cellsList) {
            RowData row = serde.convertToNewRow(Result.create(cells));
            resultRowDatas.add(row);
            resultRowDataStr.add(row.toString());
        }
        ((ObjectAssert)Assertions.assertThat(resultRowDatas.get(0)).as("RowData should not be reused", new Object[0])).isNotSameAs(resultRowDatas.get(1));
        Assertions.assertThat(resultRowDataStr).containsExactly((Object[])new String[]{"+I(1,+I(10),+I(Hello-1,100),+I(1.01,false,Welt-1))", "+I(2,+I(20),+I(Hello-2,200),+I(2.02,true,Welt-2))"});
    }

    @Test
    void convertToReusedRowTest() {
        HBaseSerde serde = this.createHBaseSerde();
        List<List<Cell>> cellsList = this.prepareCells();
        ArrayList<RowData> resultRowDatas = new ArrayList<RowData>();
        ArrayList<String> resultRowDataStr = new ArrayList<String>();
        for (List<Cell> cells : cellsList) {
            RowData row = serde.convertToReusedRow(Result.create(cells));
            resultRowDatas.add(row);
            resultRowDataStr.add(row.toString());
        }
        ((ObjectAssert)Assertions.assertThat(resultRowDatas.get(0)).as("RowData should be reused", new Object[0])).isSameAs(resultRowDatas.get(1));
        Assertions.assertThat(resultRowDataStr).containsExactly((Object[])new String[]{"+I(1,+I(10),+I(Hello-1,100),+I(1.01,false,Welt-1))", "+I(2,+I(20),+I(Hello-2,200),+I(2.02,true,Welt-2))"});
    }

    private HBaseSerde createHBaseSerde() {
        DataType dataType = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)ROW_KEY, (DataType)DataTypes.INT()), DataTypes.FIELD((String)FAMILY1, (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"col1", (DataType)DataTypes.INT())})), DataTypes.FIELD((String)FAMILY2, (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"col1", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"col2", (DataType)DataTypes.BIGINT())})), DataTypes.FIELD((String)FAMILY3, (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"col1", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"col2", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)F3COL3, (DataType)DataTypes.STRING())}))});
        HBaseTableSchema hbaseSchema = HBaseTableSchema.fromDataType((DataType)dataType);
        return new HBaseSerde(hbaseSchema, "null");
    }

    private List<List<Cell>> prepareCells() {
        ArrayList<List<Cell>> cellList = new ArrayList<List<Cell>>();
        byte[] fam1 = Bytes.toBytes((String)FAMILY1);
        byte[] f1c1 = Bytes.toBytes((String)"col1");
        byte[] fam2 = Bytes.toBytes((String)FAMILY2);
        byte[] f2c1 = Bytes.toBytes((String)"col1");
        byte[] f2c2 = Bytes.toBytes((String)"col2");
        byte[] fam3 = Bytes.toBytes((String)FAMILY3);
        byte[] f3c1 = Bytes.toBytes((String)"col1");
        byte[] f3c2 = Bytes.toBytes((String)"col2");
        byte[] f3c3 = Bytes.toBytes((String)F3COL3);
        byte[] row1 = Bytes.toBytes((int)1);
        byte[] row2 = Bytes.toBytes((int)2);
        KeyValue kv111 = new KeyValue(row1, fam1, f1c1, Bytes.toBytes((int)10));
        KeyValue kv121 = new KeyValue(row1, fam2, f2c1, Bytes.toBytes((String)"Hello-1"));
        KeyValue kv122 = new KeyValue(row1, fam2, f2c2, Bytes.toBytes((long)100L));
        KeyValue kv131 = new KeyValue(row1, fam3, f3c1, Bytes.toBytes((double)1.01));
        KeyValue kv132 = new KeyValue(row1, fam3, f3c2, Bytes.toBytes((boolean)false));
        KeyValue kv133 = new KeyValue(row1, fam3, f3c3, Bytes.toBytes((String)"Welt-1"));
        KeyValue kv211 = new KeyValue(row2, fam1, f1c1, Bytes.toBytes((int)20));
        KeyValue kv221 = new KeyValue(row2, fam2, f2c1, Bytes.toBytes((String)"Hello-2"));
        KeyValue kv222 = new KeyValue(row2, fam2, f2c2, Bytes.toBytes((long)200L));
        KeyValue kv231 = new KeyValue(row2, fam3, f3c1, Bytes.toBytes((double)2.02));
        KeyValue kv232 = new KeyValue(row2, fam3, f3c2, Bytes.toBytes((boolean)true));
        KeyValue kv233 = new KeyValue(row2, fam3, f3c3, Bytes.toBytes((String)"Welt-2"));
        ArrayList<KeyValue> cells1 = new ArrayList<KeyValue>();
        cells1.add(kv111);
        cells1.add(kv121);
        cells1.add(kv122);
        cells1.add(kv131);
        cells1.add(kv132);
        cells1.add(kv133);
        ArrayList<KeyValue> cells2 = new ArrayList<KeyValue>();
        cells2.add(kv211);
        cells2.add(kv221);
        cells2.add(kv222);
        cells2.add(kv231);
        cells2.add(kv232);
        cells2.add(kv233);
        cellList.add(cells1);
        cellList.add(cells2);
        return cellList;
    }
}

