/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive;

import com.google.common.base.Predicate;
import com.klarna.hiverunner.HiveServerContainer;
import com.klarna.hiverunner.HiveServerContext;
import com.klarna.hiverunner.HiveShell;
import com.klarna.hiverunner.HiveShellContainer;
import com.klarna.hiverunner.annotations.HiveProperties;
import com.klarna.hiverunner.annotations.HiveResource;
import com.klarna.hiverunner.annotations.HiveRunnerSetup;
import com.klarna.hiverunner.annotations.HiveSQL;
import com.klarna.hiverunner.annotations.HiveSetupScript;
import com.klarna.hiverunner.builder.HiveShellBuilder;
import com.klarna.hiverunner.config.HiveRunnerConfig;
import com.klarna.reflection.ReflectionUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.connectors.hive.FlinkEmbeddedHiveServerContext;
import org.apache.flink.connectors.hive.HiveRunnerShim;
import org.apache.flink.connectors.hive.HiveRunnerShimLoader;
import org.apache.flink.shaded.guava30.com.google.common.io.Resources;
import org.apache.flink.util.Preconditions;
import org.junit.Ignore;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkEmbeddedHiveRunner
extends BlockJUnit4ClassRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlinkEmbeddedHiveRunner.class);
    private HiveShellContainer container;
    private final HiveRunnerConfig config = new HiveRunnerConfig();
    protected HiveServerContext context;

    public FlinkEmbeddedHiveRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    protected List<TestRule> classRules() {
        this.loadAnnotatesHiveRunnerConfig(this.getTestClass().getJavaClass());
        TemporaryFolder temporaryFolder = new TemporaryFolder();
        this.context = new FlinkEmbeddedHiveServerContext(temporaryFolder, this.config);
        List rules = super.classRules();
        ExternalResource hiveShell = new ExternalResource(){

            protected void before() throws Throwable {
                FlinkEmbeddedHiveRunner.this.container = FlinkEmbeddedHiveRunner.this.createHiveServerContainer(FlinkEmbeddedHiveRunner.this.getTestClass().getJavaClass(), FlinkEmbeddedHiveRunner.this.context);
            }

            protected void after() {
                FlinkEmbeddedHiveRunner.this.tearDown();
            }
        };
        rules.add(hiveShell);
        rules.add(temporaryFolder);
        return rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        Description description = this.describeChild(method);
        if (method.getAnnotation(Ignore.class) != null) {
            notifier.fireTestIgnored(description);
        } else {
            EachTestNotifier eachNotifier = new EachTestNotifier(notifier, description);
            eachNotifier.fireTestStarted();
            try {
                this.runTestMethod(method, eachNotifier);
            }
            finally {
                eachNotifier.fireTestFinished();
            }
        }
    }

    private void runTestMethod(FrameworkMethod method, EachTestNotifier notifier) {
        Statement statement = this.methodBlock(method);
        try {
            statement.evaluate();
        }
        catch (AssumptionViolatedException e) {
            notifier.addFailedAssumption(e);
        }
        catch (Throwable e) {
            notifier.addFailure(e);
        }
    }

    private void tearDown() {
        if (this.container != null) {
            LOGGER.info("Tearing down {}", (Object)this.getName());
            try {
                this.container.tearDown();
            }
            catch (Throwable e) {
                LOGGER.warn("Tear down failed: " + e.getMessage(), e);
            }
        }
    }

    private HiveShellContainer createHiveServerContainer(Class testClass, HiveServerContext context) throws Exception {
        context.init();
        HiveServerContainer hiveServerContainer = new HiveServerContainer(context);
        HiveShellBuilder hiveShellBuilder = new HiveShellBuilder();
        HiveRunnerShim hiveRunnerShim = HiveRunnerShimLoader.load();
        hiveRunnerShim.setCommandShellEmulation(hiveShellBuilder, this.config);
        HiveShellField shellSetter = this.loadScriptsUnderTest(testClass, hiveShellBuilder);
        hiveShellBuilder.setHiveServerContainer(hiveServerContainer);
        this.loadAnnotatedResources(testClass, hiveShellBuilder);
        this.loadAnnotatedProperties(testClass, hiveShellBuilder);
        this.loadAnnotatedSetupScripts(testClass, hiveShellBuilder);
        HiveShellContainer shell = hiveShellBuilder.buildShell();
        shellSetter.setShell((HiveShell)shell);
        if (shellSetter.isAutoStart()) {
            shell.start();
        }
        return shell;
    }

    private void loadAnnotatesHiveRunnerConfig(Class testClass) {
        Set fields = ReflectionUtils.getAllFields((Class)testClass, (Predicate)org.reflections.ReflectionUtils.withAnnotation(HiveRunnerSetup.class));
        Preconditions.checkState((fields.size() <= 1 ? 1 : 0) != 0, (Object)"Exact one field of type HiveRunnerConfig should to be annotated with @HiveRunnerSetup");
        if (!fields.isEmpty()) {
            Field field = (Field)fields.iterator().next();
            Preconditions.checkState((boolean)ReflectionUtils.isOfType((Field)field, HiveRunnerConfig.class), (Object)"Field annotated with @HiveRunnerSetup should be of type HiveRunnerConfig");
            this.config.override((HiveRunnerConfig)ReflectionUtils.getStaticFieldValue((Class)testClass, (String)field.getName(), HiveRunnerConfig.class));
        }
    }

    private HiveShellField loadScriptsUnderTest(final Class testClass, HiveShellBuilder hiveShellBuilder) {
        try {
            Set fields = ReflectionUtils.getAllFields((Class)testClass, (Predicate)org.reflections.ReflectionUtils.withAnnotation(HiveSQL.class));
            Preconditions.checkState((fields.size() == 1 ? 1 : 0) != 0, (Object)"Exactly one field should to be annotated with @HiveSQL");
            final Field field = (Field)fields.iterator().next();
            ArrayList<Path> scripts = new ArrayList<Path>();
            HiveSQL annotation = field.getAnnotation(HiveSQL.class);
            for (String scriptFilePath : annotation.files()) {
                Path file = Paths.get(Resources.getResource((String)scriptFilePath).toURI());
                Preconditions.checkState((boolean)Files.exists(file, new LinkOption[0]), (Object)("File " + file + " does not exist"));
                scripts.add(file);
            }
            Charset charset = annotation.encoding().equals("") ? Charset.defaultCharset() : Charset.forName(annotation.encoding());
            final boolean isAutoStart = annotation.autoStart();
            hiveShellBuilder.setScriptsUnderTest(scripts, charset);
            return new HiveShellField(){

                @Override
                public void setShell(HiveShell shell) {
                    ReflectionUtils.setStaticField((Class)testClass, (String)field.getName(), (Object)shell);
                }

                @Override
                public boolean isAutoStart() {
                    return isAutoStart;
                }
            };
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Failed to init field annotated with @HiveSQL: " + t.getMessage(), t);
        }
    }

    private void loadAnnotatedSetupScripts(Class testClass, HiveShellBuilder hiveShellBuilder) {
        Set setupScriptFields = ReflectionUtils.getAllFields((Class)testClass, (Predicate)org.reflections.ReflectionUtils.withAnnotation(HiveSetupScript.class));
        for (Field setupScriptField : setupScriptFields) {
            if (ReflectionUtils.isOfType((Field)setupScriptField, String.class)) {
                String script = (String)ReflectionUtils.getStaticFieldValue((Class)testClass, (String)setupScriptField.getName(), String.class);
                hiveShellBuilder.addSetupScript(script);
                continue;
            }
            if (ReflectionUtils.isOfType((Field)setupScriptField, File.class) || ReflectionUtils.isOfType((Field)setupScriptField, Path.class)) {
                Path path = this.getMandatoryPathFromField(testClass, setupScriptField);
                hiveShellBuilder.addSetupScript(FlinkEmbeddedHiveRunner.readAll(path));
                continue;
            }
            throw new IllegalArgumentException("Field annotated with @HiveSetupScript currently only supports type String, File and Path");
        }
    }

    private static String readAll(Path path) {
        try {
            return new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read " + path + ": " + e.getMessage(), e);
        }
    }

    private void loadAnnotatedResources(Class testClass, HiveShellBuilder workFlowBuilder) throws IOException {
        Set fields = ReflectionUtils.getAllFields((Class)testClass, (Predicate)org.reflections.ReflectionUtils.withAnnotation(HiveResource.class));
        for (Field resourceField : fields) {
            HiveResource annotation = resourceField.getAnnotation(HiveResource.class);
            String targetFile = annotation.targetFile();
            if (ReflectionUtils.isOfType((Field)resourceField, String.class)) {
                String data = (String)ReflectionUtils.getStaticFieldValue((Class)testClass, (String)resourceField.getName(), String.class);
                workFlowBuilder.addResource(targetFile, data);
                continue;
            }
            if (ReflectionUtils.isOfType((Field)resourceField, File.class) || ReflectionUtils.isOfType((Field)resourceField, Path.class)) {
                Path dataFile = this.getMandatoryPathFromField(testClass, resourceField);
                workFlowBuilder.addResource(targetFile, dataFile);
                continue;
            }
            throw new IllegalArgumentException("Fields annotated with @HiveResource currently only supports field type String, File or Path");
        }
    }

    private Path getMandatoryPathFromField(Class testClass, Field resourceField) {
        Path path;
        if (ReflectionUtils.isOfType((Field)resourceField, File.class)) {
            File dataFile = (File)ReflectionUtils.getStaticFieldValue((Class)testClass, (String)resourceField.getName(), File.class);
            path = Paths.get(dataFile.toURI());
        } else if (ReflectionUtils.isOfType((Field)resourceField, Path.class)) {
            path = (Path)ReflectionUtils.getStaticFieldValue((Class)testClass, (String)resourceField.getName(), Path.class);
        } else {
            throw new IllegalArgumentException("Only Path or File type is allowed on annotated field " + resourceField);
        }
        Preconditions.checkArgument((boolean)Files.exists(path, new LinkOption[0]), (String)"File %s does not exist", (Object[])new Object[]{path});
        return path;
    }

    private void loadAnnotatedProperties(Class testClass, HiveShellBuilder workFlowBuilder) {
        for (Field hivePropertyField : ReflectionUtils.getAllFields((Class)testClass, (Predicate)org.reflections.ReflectionUtils.withAnnotation(HiveProperties.class))) {
            Preconditions.checkState((boolean)ReflectionUtils.isOfType((Field)hivePropertyField, Map.class), (Object)"Field annotated with @HiveProperties should be of type Map<String, String>");
            workFlowBuilder.putAllProperties((Map)ReflectionUtils.getStaticFieldValue((Class)testClass, (String)hivePropertyField.getName(), Map.class));
        }
    }

    static interface HiveShellField {
        public void setShell(HiveShell var1);

        public boolean isAutoStart();
    }
}

