/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.connectors.hive.HiveRunnerShim;
import org.apache.flink.connectors.hive.HiveRunnerShimV3;
import org.apache.flink.connectors.hive.HiveRunnerShimV4;
import org.apache.flink.table.catalog.hive.client.HiveShimLoader;

public class HiveRunnerShimLoader {
    private static final Map<String, HiveRunnerShim> hiveRunnerShims = new ConcurrentHashMap<String, HiveRunnerShim>();

    private HiveRunnerShimLoader() {
    }

    public static HiveRunnerShim load() {
        String hiveVersion = HiveShimLoader.getHiveVersion();
        return hiveRunnerShims.computeIfAbsent(hiveVersion, v -> {
            switch (v) {
                case "1.0.0": 
                case "1.0.1": 
                case "1.1.0": 
                case "1.1.1": 
                case "1.2.0": 
                case "1.2.1": 
                case "1.2.2": {
                    return new HiveRunnerShimV3();
                }
                case "2.0.0": 
                case "2.0.1": 
                case "2.1.0": 
                case "2.1.1": 
                case "2.2.0": 
                case "2.3.0": 
                case "2.3.1": 
                case "2.3.2": 
                case "2.3.3": 
                case "2.3.4": 
                case "2.3.5": 
                case "2.3.6": 
                case "2.3.7": 
                case "3.1.0": 
                case "3.1.1": 
                case "3.1.2": {
                    return new HiveRunnerShimV4();
                }
            }
            throw new RuntimeException("Unsupported Hive version " + v);
        });
    }
}

