/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connectors.hive.HiveSource;
import org.apache.flink.connectors.hive.HiveSourceBuilder;
import org.apache.flink.connectors.hive.HiveTablePartition;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.hive.HiveCatalog;
import org.apache.flink.table.catalog.hive.HiveTestUtils;
import org.apache.flink.table.catalog.hive.client.HiveShimLoader;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.util.CollectionUtil;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.mapred.JobConf;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class HiveSourceITCase {
    private static HiveCatalog hiveCatalog;

    @BeforeClass
    public static void setup() {
        hiveCatalog = HiveTestUtils.createHiveCatalog();
        hiveCatalog.open();
    }

    @AfterClass
    public static void tearDown() {
        if (hiveCatalog != null) {
            hiveCatalog.close();
        }
    }

    @Test
    public void testRegularRead() throws Exception {
        ObjectPath tablePath = new ObjectPath("default", "tbl1");
        HashMap<String, String> tableOptions = new HashMap<String, String>();
        tableOptions.put(FactoryUtil.CONNECTOR.key(), "hive");
        hiveCatalog.createTable(tablePath, (CatalogBaseTable)new CatalogTableImpl(TableSchema.builder().field("i", DataTypes.INT()).build(), tableOptions, null), false);
        HiveTestUtils.createTextTableInserter(hiveCatalog, tablePath.getDatabaseName(), tablePath.getObjectName()).addRow(new Object[]{1}).addRow(new Object[]{2}).commit();
        StreamExecutionEnvironment streamEnv = StreamExecutionEnvironment.getExecutionEnvironment();
        streamEnv.setParallelism(1);
        HiveSource hiveSource = new HiveSourceBuilder(new JobConf((org.apache.hadoop.conf.Configuration)hiveCatalog.getHiveConf()), (ReadableConfig)new Configuration(), HiveShimLoader.getHiveVersion(), tablePath.getDatabaseName(), tablePath.getObjectName(), Collections.emptyMap()).buildWithDefaultBulkFormat();
        List results = CollectionUtil.iteratorToList((Iterator)streamEnv.fromSource((Source)hiveSource, WatermarkStrategy.noWatermarks(), "HiveSource-tbl1").executeAndCollect());
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((long)1L, (long)((RowData)results.get(0)).getInt(0));
        Assert.assertEquals((long)2L, (long)((RowData)results.get(1)).getInt(0));
        hiveCatalog.dropTable(tablePath, false);
        tablePath = new ObjectPath("default", "tbl2");
        hiveCatalog.createTable(tablePath, (CatalogBaseTable)new CatalogTableImpl(TableSchema.builder().field("i", DataTypes.INT()).field("p", DataTypes.STRING()).build(), Collections.singletonList("p"), tableOptions, null), false);
        HiveTestUtils.createTextTableInserter(hiveCatalog, tablePath.getDatabaseName(), tablePath.getObjectName()).addRow(new Object[]{1}).addRow(new Object[]{2}).commit("p='a'");
        hiveSource = new HiveSourceBuilder(new JobConf((org.apache.hadoop.conf.Configuration)hiveCatalog.getHiveConf()), (ReadableConfig)new Configuration(), HiveShimLoader.getHiveVersion(), tablePath.getDatabaseName(), tablePath.getObjectName(), Collections.emptyMap()).setLimit(Long.valueOf(1L)).buildWithDefaultBulkFormat();
        results = CollectionUtil.iteratorToList((Iterator)streamEnv.fromSource((Source)hiveSource, WatermarkStrategy.noWatermarks(), "HiveSource-tbl2").executeAndCollect());
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)1L, (long)((RowData)results.get(0)).getInt(0));
        Assert.assertEquals((Object)"a", (Object)((RowData)results.get(0)).getString(1).toString());
        HiveTestUtils.createTextTableInserter(hiveCatalog, tablePath.getDatabaseName(), tablePath.getObjectName()).addRow(new Object[]{3}).commit("p='b'");
        LinkedHashMap<String, String> spec = new LinkedHashMap<String, String>();
        spec.put("p", "b");
        hiveSource = new HiveSourceBuilder(new JobConf((org.apache.hadoop.conf.Configuration)hiveCatalog.getHiveConf()), (ReadableConfig)new Configuration(), null, tablePath.getDatabaseName(), tablePath.getObjectName(), Collections.emptyMap()).setPartitions(Collections.singletonList(HiveTablePartition.ofPartition((HiveConf)hiveCatalog.getHiveConf(), (String)hiveCatalog.getHiveVersion(), (String)tablePath.getDatabaseName(), (String)tablePath.getObjectName(), spec))).buildWithDefaultBulkFormat();
        results = CollectionUtil.iteratorToList((Iterator)streamEnv.fromSource((Source)hiveSource, WatermarkStrategy.noWatermarks(), "HiveSource-tbl2").executeAndCollect());
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)3L, (long)((RowData)results.get(0)).getInt(0));
        Assert.assertEquals((Object)"b", (Object)((RowData)results.get(0)).getString(1).toString());
        hiveCatalog.dropTable(tablePath, false);
    }
}

