/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive;

import java.util.HashMap;
import java.util.Optional;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connectors.hive.HiveTableFactory;
import org.apache.flink.connectors.hive.HiveTableSink;
import org.apache.flink.connectors.hive.HiveTableSource;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.hive.HiveCatalog;
import org.apache.flink.table.catalog.hive.HiveTestUtils;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.TableSinkFactory;
import org.apache.flink.table.factories.TableSinkFactoryContextImpl;
import org.apache.flink.table.factories.TableSourceFactory;
import org.apache.flink.table.factories.TableSourceFactoryContextImpl;
import org.apache.flink.table.sinks.StreamTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.types.DataType;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class HiveTableFactoryTest {
    private static HiveCatalog catalog;

    @BeforeClass
    public static void init() {
        catalog = HiveTestUtils.createHiveCatalog();
        catalog.open();
    }

    @AfterClass
    public static void close() {
        catalog.close();
    }

    @Test
    public void testGenericTable() throws Exception {
        TableSchema schema = TableSchema.builder().field("name", DataTypes.STRING()).field("age", DataTypes.INT()).build();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(FactoryUtil.CONNECTOR.key(), "COLLECTION");
        catalog.createDatabase("mydb", (CatalogDatabase)new CatalogDatabaseImpl(new HashMap(), ""), true);
        ObjectPath path = new ObjectPath("mydb", "mytable");
        CatalogTableImpl table = new CatalogTableImpl(schema, properties, "csv table");
        catalog.createTable(path, (CatalogBaseTable)table, true);
        Optional opt = catalog.getTableFactory();
        Assert.assertTrue((boolean)opt.isPresent());
        HiveTableFactory tableFactory = (HiveTableFactory)opt.get();
        TableSource tableSource = tableFactory.createTableSource((TableSourceFactory.Context)new TableSourceFactoryContextImpl(ObjectIdentifier.of((String)"mycatalog", (String)"mydb", (String)"mytable"), (CatalogTable)table, (ReadableConfig)new Configuration(), false));
        Assert.assertTrue((boolean)(tableSource instanceof StreamTableSource));
        TableSink tableSink = tableFactory.createTableSink((TableSinkFactory.Context)new TableSinkFactoryContextImpl(ObjectIdentifier.of((String)"mycatalog", (String)"mydb", (String)"mytable"), (CatalogTable)table, (ReadableConfig)new Configuration(), true, false));
        Assert.assertTrue((boolean)(tableSink instanceof StreamTableSink));
    }

    @Test
    public void testHiveTable() throws Exception {
        ResolvedSchema schema = ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"name", (DataType)DataTypes.STRING()), Column.physical((String)"age", (DataType)DataTypes.INT())});
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(FactoryUtil.CONNECTOR.key(), "hive");
        catalog.createDatabase("mydb", (CatalogDatabase)new CatalogDatabaseImpl(new HashMap(), ""), true);
        ObjectPath path = new ObjectPath("mydb", "mytable");
        CatalogTableImpl table = new CatalogTableImpl(TableSchema.fromResolvedSchema((ResolvedSchema)schema), properties, "hive table");
        catalog.createTable(path, (CatalogBaseTable)table, true);
        DynamicTableSource tableSource = FactoryUtil.createTableSource((Catalog)catalog, (ObjectIdentifier)ObjectIdentifier.of((String)"mycatalog", (String)"mydb", (String)"mytable"), (ResolvedCatalogTable)new ResolvedCatalogTable((CatalogTable)table, schema), (ReadableConfig)new Configuration(), (ClassLoader)Thread.currentThread().getContextClassLoader(), (boolean)false);
        Assert.assertTrue((boolean)(tableSource instanceof HiveTableSource));
        DynamicTableSink tableSink = FactoryUtil.createTableSink((Catalog)catalog, (ObjectIdentifier)ObjectIdentifier.of((String)"mycatalog", (String)"mydb", (String)"mytable"), (ResolvedCatalogTable)new ResolvedCatalogTable((CatalogTable)table, schema), (ReadableConfig)new Configuration(), (ClassLoader)Thread.currentThread().getContextClassLoader(), (boolean)false);
        Assert.assertTrue((boolean)(tableSink instanceof HiveTableSink));
    }
}

