/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive;

import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.flink.table.HiveVersionTestUtil;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.hive.HiveCatalog;
import org.apache.flink.table.catalog.hive.HiveTestUtils;
import org.apache.flink.table.filesystem.FileSystemConnectorOptions;
import org.apache.flink.table.planner.factories.utils.TestCollectionTableFactory;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.types.Row;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class HiveTemporalJoinITCase
extends TableTestBase {
    private static TableEnvironment tableEnv;
    private static HiveCatalog hiveCatalog;

    @BeforeClass
    public static void setup() {
        if (!HiveVersionTestUtil.HIVE_310_OR_LATER) {
            return;
        }
        tableEnv = TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.inStreamingMode());
        hiveCatalog = HiveTestUtils.createHiveCatalog();
        hiveCatalog = HiveTestUtils.createHiveCatalog("test-catalog", "3.1.2");
        tableEnv.registerCatalog(hiveCatalog.getName(), (Catalog)hiveCatalog);
        tableEnv.useCatalog(hiveCatalog.getName());
        TestCollectionTableFactory.initData(Arrays.asList(Row.of((Object[])new Object[]{1, "a", Timestamp.valueOf("1970-01-01 00:00:00.001")}), Row.of((Object[])new Object[]{1, "c", Timestamp.valueOf("1970-01-01 00:00:00.002")}), Row.of((Object[])new Object[]{2, "b", Timestamp.valueOf("1970-01-01 00:00:00.003")}), Row.of((Object[])new Object[]{2, "c", Timestamp.valueOf("1970-01-01 00:00:00.004")}), Row.of((Object[])new Object[]{3, "c", Timestamp.valueOf("1970-01-01 00:00:00.005")}), Row.of((Object[])new Object[]{4, "d", Timestamp.valueOf("1970-01-01 00:00:00.006")})));
        tableEnv.executeSql("create table default_catalog.default_database.probe ( x int, y string, rowtime timestamp(3), p as proctime(), watermark for rowtime as rowtime) with ('connector'='COLLECTION','is-bounded' = 'false')");
        tableEnv.getConfig().setSqlDialect(SqlDialect.HIVE);
        tableEnv.executeSql(String.format("create table build ( x int,  y string,  z int,  primary key(x,y) disable novalidate rely) tblproperties ('%s' = 'true', '%s'='5min')", FileSystemConnectorOptions.STREAMING_SOURCE_ENABLE.key(), FileSystemConnectorOptions.STREAMING_SOURCE_MONITOR_INTERVAL.key()));
        tableEnv.getConfig().setSqlDialect(SqlDialect.DEFAULT);
    }

    @Test
    public void testProcTimeTemporalJoinHiveTable() throws Exception {
        if (!HiveVersionTestUtil.HIVE_310_OR_LATER) {
            return;
        }
        tableEnv.getConfig().setSqlDialect(SqlDialect.DEFAULT);
        tableEnv.executeSql("insert into build values (1,'a',10),(2,'a',21),(2,'b',22),(3,'c',33)").await();
        this.expectedException().expect(TableException.class);
        this.expectedException().expectMessage("Processing-time temporal join is not supported yet.");
        tableEnv.executeSql("select p.x, p.y, b.z from  default_catalog.default_database.probe as p  join build for system_time as of p.p as b on p.x=b.x and p.y=b.y");
    }

    @Test
    public void testRowTimeTemporalJoinHiveTable() throws Exception {
        if (!HiveVersionTestUtil.HIVE_310_OR_LATER) {
            return;
        }
        tableEnv.getConfig().setSqlDialect(SqlDialect.DEFAULT);
        tableEnv.executeSql("insert into build values (1,'a',10),(2,'a',21),(2,'b',22),(3,'c',33)").await();
        this.expectedException().expect(ValidationException.class);
        this.expectedException().expectMessage("Event-Time Temporal Table Join requires both primary key and row time attribute in versioned table, but no row time attribute can be found.");
        tableEnv.executeSql("select p.x, p.y, b.z from  default_catalog.default_database.probe as p  join build for system_time as of p.rowtime as b on p.x=b.x and p.y=b.y");
    }

    @AfterClass
    public static void tearDown() {
        if (!HiveVersionTestUtil.HIVE_310_OR_LATER) {
            return;
        }
        tableEnv.executeSql("drop table build");
        if (hiveCatalog != null) {
            hiveCatalog.close();
        }
    }
}

