/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.flink.connectors.hive.util.HiveConfUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.junit.Assert;
import org.junit.Test;

public class HiveConfUtilsTest {
    private static final String HIVE_SITE_CONTENT = "<?xml version=\"1.0\"?>\n<?xml-stylesheet type=\"text/xsl\" href=\"configuration.xsl\"?>\n<configuration>\n  <property>\n    <name>hive.metastore.sasl.enabled</name>\n    <value>true</value>\n  </property>\n</configuration>\n";

    @Test
    public void testCreateHiveConf() {
        HiveConf hiveConf = this.createHiveConf();
        Assert.assertTrue((boolean)hiveConf.getBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL));
        Assert.assertFalse((boolean)new HiveConf((Configuration)hiveConf, HiveConf.class).getBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL));
        Assert.assertTrue((boolean)HiveConfUtils.create((Configuration)hiveConf).getBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL));
    }

    private HiveConf createHiveConf() {
        HiveConf hiveConf = new HiveConf();
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(HIVE_SITE_CONTENT.getBytes(StandardCharsets.UTF_8));){
            hiveConf.addResource((InputStream)inputStream, "for_test");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return hiveConf;
    }
}

