/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.hive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.sql.parser.hive.ddl.SqlAlterHiveTable;
import org.apache.flink.table.HiveVersionTestUtil;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogFunctionImpl;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.CatalogTestUtil;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.hive.HiveCatalog;
import org.apache.flink.table.catalog.hive.HiveCatalogMetadataTestBase;
import org.apache.flink.table.catalog.hive.HiveTestUtils;
import org.apache.flink.table.catalog.hive.util.HiveTypeUtil;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataBinary;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataBoolean;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataDate;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataDouble;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataLong;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataString;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.catalog.stats.Date;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.StringUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.udf.UDFRand;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFAbs;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class HiveCatalogHiveMetadataTest
extends HiveCatalogMetadataTestBase {
    @BeforeClass
    public static void init() {
        catalog = HiveTestUtils.createHiveCatalog();
        catalog.open();
    }

    public void testCreateTable_Streaming() throws Exception {
    }

    @Test
    public void testCreateTable_StorageFormatSet() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.createTable(this.path1, (CatalogBaseTable)this.createTable(), false);
        org.apache.hadoop.hive.metastore.api.Table hiveTable = ((HiveCatalog)catalog).getHiveTable(this.path1);
        String inputFormat = hiveTable.getSd().getInputFormat();
        String outputFormat = hiveTable.getSd().getOutputFormat();
        String serde = hiveTable.getSd().getSerdeInfo().getSerializationLib();
        Assert.assertFalse((boolean)StringUtils.isNullOrWhitespaceOnly((String)inputFormat));
        Assert.assertFalse((boolean)StringUtils.isNullOrWhitespaceOnly((String)outputFormat));
        Assert.assertFalse((boolean)StringUtils.isNullOrWhitespaceOnly((String)serde));
    }

    @Test
    public void testViewCompatibility() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        org.apache.hadoop.hive.metastore.api.Table hiveView = Table.getEmptyTable((String)this.path1.getDatabaseName(), (String)this.path1.getObjectName());
        hiveView.setTableType(TableType.VIRTUAL_VIEW.name());
        String originQuery = "view origin query";
        String expandedQuery = "view expanded query";
        hiveView.setViewOriginalText("view origin query");
        hiveView.setViewExpandedText("view expanded query");
        Schema schema = Schema.newBuilder().fromFields(new String[]{"i", "s"}, new AbstractDataType[]{DataTypes.INT(), DataTypes.STRING()}).build();
        ArrayList<FieldSchema> fields = new ArrayList<FieldSchema>();
        for (Schema.UnresolvedColumn column : schema.getColumns()) {
            String name = column.getName();
            DataType type = (DataType)((Schema.UnresolvedPhysicalColumn)column).getDataType();
            fields.add(new FieldSchema(name, HiveTypeUtil.toHiveTypeInfo((DataType)type, (boolean)true).getTypeName(), null));
        }
        hiveView.getSd().setCols(fields);
        hiveView.getParameters().put("is_generic", "false");
        hiveView.getParameters().put("k1", "v1");
        ((HiveCatalog)HiveCatalogHiveMetadataTest.catalog).client.createTable(hiveView);
        CatalogBaseTable baseTable = catalog.getTable(this.path1);
        Assert.assertTrue((boolean)(baseTable instanceof CatalogView));
        CatalogView catalogView = (CatalogView)baseTable;
        Assert.assertEquals((Object)schema, (Object)catalogView.getUnresolvedSchema());
        Assert.assertEquals((Object)"view origin query", (Object)catalogView.getOriginalQuery());
        Assert.assertEquals((Object)"view expanded query", (Object)catalogView.getExpandedQuery());
        Assert.assertEquals((Object)"v1", catalogView.getOptions().get("k1"));
        hiveView.setDbName(this.path3.getDatabaseName());
        hiveView.setTableName(this.path3.getObjectName());
        hiveView.getParameters().remove("is_generic");
        hiveView.getParameters().put(FactoryUtil.CONNECTOR.key(), "hive");
        ((HiveCatalog)HiveCatalogHiveMetadataTest.catalog).client.createTable(hiveView);
        baseTable = catalog.getTable(this.path3);
        Assert.assertTrue((boolean)(baseTable instanceof CatalogView));
        catalogView = (CatalogView)baseTable;
        Assert.assertEquals((Object)schema, (Object)catalogView.getUnresolvedSchema());
        Assert.assertEquals((Object)"view origin query", (Object)catalogView.getOriginalQuery());
        Assert.assertEquals((Object)"view expanded query", (Object)catalogView.getExpandedQuery());
        Assert.assertEquals((Object)"v1", catalogView.getOptions().get("k1"));
    }

    @Test
    public void testAlterTableColumnStatistics() throws Exception {
        String hiveVersion = ((HiveCatalog)catalog).getHiveVersion();
        boolean supportDateStats = hiveVersion.compareTo("1.2.0") >= 0;
        catalog.createDatabase("db1", this.createDb(), false);
        TableSchema.Builder builder = TableSchema.builder().field("first", DataTypes.STRING()).field("second", DataTypes.INT()).field("third", DataTypes.BOOLEAN()).field("fourth", DataTypes.DOUBLE()).field("fifth", DataTypes.BIGINT()).field("sixth", DataTypes.BYTES()).field("seventh", DataTypes.DECIMAL((int)10, (int)3)).field("eighth", DataTypes.DECIMAL((int)30, (int)3));
        if (supportDateStats) {
            builder.field("ninth", DataTypes.DATE());
        }
        TableSchema tableSchema = builder.build();
        CatalogTableImpl catalogTable = new CatalogTableImpl(tableSchema, this.getBatchTableProperties(), "test comment");
        catalog.createTable(this.path1, (CatalogBaseTable)catalogTable, false);
        HashMap<String, Object> columnStatisticsDataBaseMap = new HashMap<String, Object>();
        columnStatisticsDataBaseMap.put("first", new CatalogColumnStatisticsDataString(Long.valueOf(10L), Double.valueOf(5.2), Long.valueOf(3L), Long.valueOf(100L)));
        columnStatisticsDataBaseMap.put("second", new CatalogColumnStatisticsDataLong(Long.valueOf(0L), Long.valueOf(1000L), Long.valueOf(3L), Long.valueOf(0L)));
        columnStatisticsDataBaseMap.put("third", new CatalogColumnStatisticsDataBoolean(Long.valueOf(15L), Long.valueOf(20L), Long.valueOf(3L)));
        columnStatisticsDataBaseMap.put("fourth", new CatalogColumnStatisticsDataDouble(Double.valueOf(15.02), Double.valueOf(20.01), Long.valueOf(3L), Long.valueOf(10L)));
        columnStatisticsDataBaseMap.put("fifth", new CatalogColumnStatisticsDataLong(Long.valueOf(0L), Long.valueOf(20L), Long.valueOf(3L), Long.valueOf(2L)));
        columnStatisticsDataBaseMap.put("sixth", new CatalogColumnStatisticsDataBinary(Long.valueOf(150L), Double.valueOf(20.0), Long.valueOf(3L)));
        columnStatisticsDataBaseMap.put("seventh", new CatalogColumnStatisticsDataDouble(Double.valueOf(1.23), Double.valueOf(99.456), Long.valueOf(100L), Long.valueOf(0L)));
        columnStatisticsDataBaseMap.put("eighth", new CatalogColumnStatisticsDataDouble(Double.valueOf(0.123), Double.valueOf(123456.789), Long.valueOf(5723L), Long.valueOf(19L)));
        if (supportDateStats) {
            columnStatisticsDataBaseMap.put("ninth", new CatalogColumnStatisticsDataDate(new Date(71L), new Date(17923L), Long.valueOf(132L), Long.valueOf(0L)));
        }
        CatalogColumnStatistics catalogColumnStatistics = new CatalogColumnStatistics(columnStatisticsDataBaseMap);
        catalog.alterTableColumnStatistics(this.path1, catalogColumnStatistics, false);
        this.checkEquals(catalogColumnStatistics, catalog.getTableColumnStatistics(this.path1));
    }

    @Test
    public void testAlterPartitionColumnStatistics() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        CatalogTable catalogTable = this.createPartitionedTable();
        catalog.createTable(this.path1, (CatalogBaseTable)catalogTable, false);
        CatalogPartitionSpec partitionSpec = new CatalogPartitionSpec((Map)new HashMap<String, String>(){
            {
                this.put("second", "2010-04-21 09:45:00");
                this.put("third", "2000");
            }
        });
        catalog.createPartition(this.path1, partitionSpec, this.createPartition(), true);
        HashMap<String, CatalogColumnStatisticsDataString> columnStatisticsDataBaseMap = new HashMap<String, CatalogColumnStatisticsDataString>();
        columnStatisticsDataBaseMap.put("first", new CatalogColumnStatisticsDataString(Long.valueOf(10L), Double.valueOf(5.2), Long.valueOf(3L), Long.valueOf(100L)));
        CatalogColumnStatistics catalogColumnStatistics = new CatalogColumnStatistics(columnStatisticsDataBaseMap);
        catalog.alterPartitionColumnStatistics(this.path1, partitionSpec, catalogColumnStatistics, false);
        this.checkEquals(catalogColumnStatistics, catalog.getPartitionColumnStatistics(this.path1, partitionSpec));
    }

    @Test
    public void testHiveStatistics() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        this.checkStatistics(0, -1);
        this.checkStatistics(1, 1);
        this.checkStatistics(1000, 1000);
    }

    @Test
    public void testCreateTableWithConstraints() throws Exception {
        Assume.assumeTrue((boolean)HiveVersionTestUtil.HIVE_310_OR_LATER);
        HiveCatalog hiveCatalog = (HiveCatalog)catalog;
        hiveCatalog.createDatabase("db1", this.createDb(), false);
        TableSchema.Builder builder = TableSchema.builder();
        builder.fields(new String[]{"x", "y", "z"}, new DataType[]{(DataType)DataTypes.INT().notNull(), (DataType)DataTypes.TIMESTAMP((int)9).notNull(), DataTypes.BIGINT()});
        builder.primaryKey("pk_name", new String[]{"x"});
        hiveCatalog.createTable(this.path1, (CatalogBaseTable)new CatalogTableImpl(builder.build(), this.getBatchTableProperties(), null), false);
        CatalogTable catalogTable = (CatalogTable)hiveCatalog.getTable(this.path1);
        Assert.assertTrue((String)"PK not present", (boolean)catalogTable.getSchema().getPrimaryKey().isPresent());
        UniqueConstraint pk = (UniqueConstraint)catalogTable.getSchema().getPrimaryKey().get();
        Assert.assertEquals((Object)"pk_name", (Object)pk.getName());
        Assert.assertEquals(Collections.singletonList("x"), (Object)pk.getColumns());
        Assert.assertFalse((boolean)catalogTable.getSchema().getFieldDataTypes()[0].getLogicalType().isNullable());
        Assert.assertFalse((boolean)catalogTable.getSchema().getFieldDataTypes()[1].getLogicalType().isNullable());
        Assert.assertTrue((boolean)catalogTable.getSchema().getFieldDataTypes()[2].getLogicalType().isNullable());
        hiveCatalog.dropDatabase("db1", false, true);
    }

    @Test
    public void testAlterPartition() throws Exception {
        catalog.createDatabase("db1", this.createDb(), false);
        catalog.createTable(this.path1, (CatalogBaseTable)this.createPartitionedTable(), false);
        catalog.createPartition(this.path1, this.createPartitionSpec(), this.createPartition(), false);
        Assert.assertEquals(Collections.singletonList(this.createPartitionSpec()), (Object)catalog.listPartitions(this.path1));
        CatalogPartition cp = catalog.getPartition(this.path1, this.createPartitionSpec());
        CatalogTestUtil.checkEquals((CatalogPartition)this.createPartition(), (CatalogPartition)cp);
        Assert.assertNull(cp.getProperties().get("k"));
        CatalogPartition another = this.createPartition();
        another.getProperties().put("k", "v");
        another.getProperties().put("alter.table.op", SqlAlterHiveTable.AlterTableOp.CHANGE_TBL_PROPS.name());
        catalog.alterPartition(this.path1, this.createPartitionSpec(), another, false);
        Assert.assertEquals(Collections.singletonList(this.createPartitionSpec()), (Object)catalog.listPartitions(this.path1));
        cp = catalog.getPartition(this.path1, this.createPartitionSpec());
        CatalogTestUtil.checkEquals((CatalogPartition)another, (CatalogPartition)cp);
        Assert.assertEquals((Object)"v", cp.getProperties().get("k"));
    }

    private void checkStatistics(int inputStat, int expectStat) throws Exception {
        catalog.dropTable(this.path1, true);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(FactoryUtil.CONNECTOR.key(), "hive");
        properties.put("numRows", String.valueOf(inputStat));
        properties.put("numFiles", String.valueOf(inputStat));
        properties.put("totalSize", String.valueOf(inputStat));
        properties.put("rawDataSize", String.valueOf(inputStat));
        CatalogTableImpl catalogTable = new CatalogTableImpl(TableSchema.builder().field("f0", DataTypes.INT()).build(), properties, "");
        catalog.createTable(this.path1, (CatalogBaseTable)catalogTable, false);
        CatalogTableStatistics statistics = catalog.getTableStatistics(this.path1);
        Assert.assertEquals((long)expectStat, (long)statistics.getRowCount());
        Assert.assertEquals((long)expectStat, (long)statistics.getFileCount());
        Assert.assertEquals((long)expectStat, (long)statistics.getRawDataSize());
        Assert.assertEquals((long)expectStat, (long)statistics.getTotalSize());
    }

    protected boolean isGeneric() {
        return false;
    }

    public CatalogTable createStreamingTable() {
        throw new UnsupportedOperationException("Hive table cannot be streaming.");
    }

    protected CatalogFunction createFunction() {
        return new CatalogFunctionImpl(GenericUDFAbs.class.getName());
    }

    protected CatalogFunction createAnotherFunction() {
        return new CatalogFunctionImpl(UDFRand.class.getName());
    }
}

