/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.hive;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.hive.HiveCatalog;
import org.apache.flink.table.catalog.hive.HiveTestUtils;
import org.apache.flink.table.catalog.hive.util.HiveTableUtil;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Table;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class HiveCatalogTest {
    TableSchema schema = TableSchema.builder().field("name", DataTypes.STRING()).field("age", DataTypes.INT()).build();
    private static HiveCatalog hiveCatalog;

    @BeforeClass
    public static void createCatalog() {
        hiveCatalog = HiveTestUtils.createHiveCatalog();
        hiveCatalog.open();
    }

    @AfterClass
    public static void closeCatalog() {
        if (hiveCatalog != null) {
            hiveCatalog.close();
        }
    }

    @Test
    public void testCreateGenericTable() {
        Table hiveTable = HiveTableUtil.instantiateHiveTable((ObjectPath)new ObjectPath("test", "test"), (CatalogBaseTable)new CatalogTableImpl(this.schema, HiveCatalogTest.getLegacyFileSystemConnectorOptions("/test_path"), null), (HiveConf)HiveTestUtils.createHiveConf());
        Map prop = hiveTable.getParameters();
        Assert.assertFalse((boolean)HiveCatalog.isHiveTable((Map)prop));
        Assert.assertTrue((boolean)prop.keySet().stream().allMatch(k -> k.startsWith("flink.")));
    }

    @Test
    public void testCreateHiveTable() {
        Map<String, String> options = HiveCatalogTest.getLegacyFileSystemConnectorOptions("/test_path");
        options.put(FactoryUtil.CONNECTOR.key(), "hive");
        Table hiveTable = HiveTableUtil.instantiateHiveTable((ObjectPath)new ObjectPath("test", "test"), (CatalogBaseTable)new CatalogTableImpl(this.schema, options, null), (HiveConf)HiveTestUtils.createHiveConf());
        Map prop = hiveTable.getParameters();
        Assert.assertTrue((boolean)HiveCatalog.isHiveTable((Map)prop));
        Assert.assertTrue((boolean)prop.keySet().stream().noneMatch(k -> k.startsWith("flink.")));
    }

    @Test
    public void testRetrieveFlinkProperties() throws Exception {
        ObjectPath hiveObjectPath = new ObjectPath("default", "testRetrieveProperties");
        Map<String, String> options = HiveCatalogTest.getLegacyFileSystemConnectorOptions("/test_path");
        options.put(FactoryUtil.CONNECTOR.key(), "jdbc");
        options.put("url", "jdbc:clickhouse://host:port/testUrl1");
        options.put("flink.url", "jdbc:clickhouse://host:port/testUrl2");
        hiveCatalog.createTable(hiveObjectPath, (CatalogBaseTable)new CatalogTableImpl(this.schema, options, null), false);
        CatalogBaseTable hiveTable = hiveCatalog.getTable(hiveObjectPath);
        Assert.assertEquals(hiveTable.getOptions().get("url"), (Object)"jdbc:clickhouse://host:port/testUrl1");
        Assert.assertEquals(hiveTable.getOptions().get("flink.url"), (Object)"jdbc:clickhouse://host:port/testUrl2");
    }

    @Test
    public void testCreateHiveConf() {
        HiveConf hiveConf = HiveCatalog.createHiveConf(null, null);
        Assert.assertEquals((Object)"common-val", (Object)hiveConf.get("common-key"));
        String hiveConfDir = Thread.currentThread().getContextClassLoader().getResource("test-catalog-factory-conf").getPath();
        hiveConf = HiveCatalog.createHiveConf((String)hiveConfDir, null);
        Assert.assertNull((Object)hiveConf.get("common-key", null));
    }

    @Test
    public void testGetNoSchemaGenericTable() throws Exception {
        ObjectPath hiveObjectPath = new ObjectPath("default", "testGetNoSchemaGenericTable");
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(FactoryUtil.CONNECTOR.key(), "jdbc");
        hiveCatalog.createTable(hiveObjectPath, (CatalogBaseTable)new CatalogTableImpl(TableSchema.builder().build(), properties, null), false);
        CatalogBaseTable catalogTable = hiveCatalog.getTable(hiveObjectPath);
        Assert.assertEquals((Object)TableSchema.builder().build(), (Object)catalogTable.getSchema());
    }

    private static Map<String, String> getLegacyFileSystemConnectorOptions(String path) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("connector.type", "filesystem");
        options.put("connector.path", path);
        return options;
    }
}

