/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.hive.util;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.catalog.hive.client.HiveShimLoader;
import org.apache.flink.table.catalog.hive.util.HiveTableUtil;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.junit.Assert;
import org.junit.Test;

public class HiveTableUtilTest {
    private static final HiveShim hiveShim = HiveShimLoader.loadHiveShim((String)HiveShimLoader.getHiveVersion());

    @Test
    public void testMakePartitionFilter() {
        List<String> partColNames = Arrays.asList("p1", "p2", "p3");
        FieldReferenceExpression p1Ref = new FieldReferenceExpression("p1", DataTypes.INT(), 0, 2);
        FieldReferenceExpression p2Ref = new FieldReferenceExpression("p2", DataTypes.STRING(), 0, 3);
        FieldReferenceExpression p3Ref = new FieldReferenceExpression("p3", DataTypes.DOUBLE(), 0, 4);
        CallExpression p1Exp = new CallExpression((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, Arrays.asList(p1Ref, ApiExpressionUtils.valueLiteral((Object)1)), DataTypes.BOOLEAN());
        CallExpression p2Exp = new CallExpression((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, Arrays.asList(p2Ref, ApiExpressionUtils.valueLiteral((Object)"a", (DataType)((DataType)DataTypes.STRING().notNull()))), DataTypes.BOOLEAN());
        CallExpression p3Exp = new CallExpression((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, Arrays.asList(p3Ref, ApiExpressionUtils.valueLiteral((Object)1.1)), DataTypes.BOOLEAN());
        Optional filter = HiveTableUtil.makePartitionFilter((int)2, partColNames, Arrays.asList(p1Exp), (HiveShim)hiveShim);
        Assert.assertEquals((Object)"(p1 = 1)", filter.orElse(null));
        filter = HiveTableUtil.makePartitionFilter((int)2, partColNames, Arrays.asList(p1Exp, p3Exp), (HiveShim)hiveShim);
        Assert.assertEquals((Object)"(p1 = 1) and (p3 = 1.1)", filter.orElse(null));
        filter = HiveTableUtil.makePartitionFilter((int)2, partColNames, Arrays.asList(p2Exp, new CallExpression((FunctionDefinition)BuiltInFunctionDefinitions.OR, Arrays.asList(p1Exp, p3Exp), DataTypes.BOOLEAN())), (HiveShim)hiveShim);
        Assert.assertEquals((Object)"(p2 = 'a') and ((p1 = 1) or (p3 = 1.1))", filter.orElse(null));
    }
}

