/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions.hive;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.flink.table.HiveVersionTestUtil;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.catalog.hive.client.HiveShimLoader;
import org.apache.flink.table.functions.hive.HiveFunctionWrapper;
import org.apache.flink.table.functions.hive.HiveGenericUDF;
import org.apache.flink.table.functions.hive.HiveSimpleUDF;
import org.apache.flink.table.functions.hive.HiveSimpleUDFTest;
import org.apache.flink.table.functions.hive.util.TestGenericUDFArray;
import org.apache.flink.table.functions.hive.util.TestGenericUDFStructSize;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.types.Row;
import org.apache.hadoop.hive.ql.udf.UDFUnhex;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFAbs;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCase;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCeil;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCoalesce;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateDiff;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDecode;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFMapKeys;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFStringToMap;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFStruct;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class HiveGenericUDFTest {
    private static HiveShim hiveShim = HiveShimLoader.loadHiveShim((String)HiveShimLoader.getHiveVersion());

    @Test
    public void testAbs() {
        HiveGenericUDF udf = HiveGenericUDFTest.init(GenericUDFAbs.class, new Object[]{null}, new DataType[]{DataTypes.DOUBLE()});
        Assert.assertEquals((Object)10.0, (Object)udf.eval(new Object[]{-10.0}));
        udf = HiveGenericUDFTest.init(GenericUDFAbs.class, new Object[]{null}, new DataType[]{DataTypes.INT()});
        Assert.assertEquals((Object)10, (Object)udf.eval(new Object[]{-10}));
        udf = HiveGenericUDFTest.init(GenericUDFAbs.class, new Object[]{null}, new DataType[]{DataTypes.STRING()});
        Assert.assertEquals((Object)10.0, (Object)udf.eval(new Object[]{"-10.0"}));
    }

    @Test
    public void testAddMonths() throws Exception {
        Assume.assumeTrue((boolean)HiveVersionTestUtil.HIVE_110_OR_LATER);
        HiveGenericUDF udf = HiveGenericUDFTest.init(Class.forName("org.apache.hadoop.hive.ql.udf.generic.GenericUDFAddMonths"), new Object[]{null, 1}, new DataType[]{DataTypes.STRING(), DataTypes.INT()});
        Assert.assertEquals((Object)"2009-09-30", (Object)udf.eval(new Object[]{"2009-08-31", 1}));
        Assert.assertEquals((Object)"2009-09-30", (Object)udf.eval(new Object[]{"2009-08-31 11:11:11", 1}));
    }

    @Test
    public void testDateFormat() throws Exception {
        Assume.assumeTrue((boolean)HiveVersionTestUtil.HIVE_120_OR_LATER);
        String constYear = "y";
        String constMonth = "M";
        HiveGenericUDF udf = HiveGenericUDFTest.init(Class.forName("org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateFormat"), new Object[]{null, constYear}, new DataType[]{DataTypes.STRING(), DataTypes.STRING()});
        Assert.assertEquals((Object)"2009", (Object)udf.eval(new Object[]{"2009-08-31", constYear}));
        udf = HiveGenericUDFTest.init(Class.forName("org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateFormat"), new Object[]{null, constMonth}, new DataType[]{DataTypes.DATE(), DataTypes.STRING()});
        Assert.assertEquals((Object)"8", (Object)udf.eval(new Object[]{Date.valueOf("2019-08-31"), constMonth}));
    }

    @Test
    public void testDecode() {
        String constDecoding = "UTF-8";
        HiveGenericUDF udf = HiveGenericUDFTest.init(GenericUDFDecode.class, new Object[]{null, constDecoding}, new DataType[]{DataTypes.BYTES(), DataTypes.STRING()});
        HiveSimpleUDF simpleUDF = HiveSimpleUDFTest.init(UDFUnhex.class, new DataType[]{DataTypes.STRING()});
        Assert.assertEquals((Object)"MySQL", (Object)udf.eval(new Object[]{simpleUDF.eval(new Object[]{"4D7953514C"}), constDecoding}));
    }

    @Test
    public void testCase() {
        HiveGenericUDF udf = HiveGenericUDFTest.init(GenericUDFCase.class, new Object[]{null, "1", "a", "b"}, new DataType[]{DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()});
        Assert.assertEquals((Object)"a", (Object)udf.eval(new Object[]{"1", "1", "a", "b"}));
        Assert.assertEquals((Object)"b", (Object)udf.eval(new Object[]{"2", "1", "a", "b"}));
    }

    @Test
    public void testCeil() {
        HiveGenericUDF udf = HiveGenericUDFTest.init(GenericUDFCeil.class, new Object[]{null}, new DataType[]{DataTypes.DOUBLE()});
        Assert.assertEquals((Object)0L, (Object)udf.eval(new Object[]{-0.1}));
        udf = HiveGenericUDFTest.init(GenericUDFCeil.class, new Object[]{null}, new DataType[]{DataTypes.DECIMAL((int)2, (int)1)});
        Assert.assertEquals((Object)BigDecimal.valueOf(4L), (Object)udf.eval(new Object[]{BigDecimal.valueOf(3.1)}));
    }

    @Test
    public void testCoalesce() {
        HiveGenericUDF udf = HiveGenericUDFTest.init(GenericUDFCoalesce.class, new Object[]{null, 1, null}, new DataType[]{DataTypes.INT(), DataTypes.INT(), DataTypes.INT()});
        Assert.assertEquals((Object)1, (Object)udf.eval(new Object[]{null, 1, null}));
    }

    @Test
    public void testDateDiff() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String d = "1969-07-20";
        String t1 = "1969-07-20 00:00:00";
        String t2 = "1980-12-31 12:59:59";
        HiveGenericUDF udf = HiveGenericUDFTest.init(GenericUDFDateDiff.class, new Object[]{null, null}, new DataType[]{DataTypes.VARCHAR((int)20), DataTypes.CHAR((int)20)});
        Assert.assertEquals((Object)-4182, (Object)udf.eval(new Object[]{t1, t2}));
        udf = HiveGenericUDFTest.init(GenericUDFDateDiff.class, new Object[]{null, null}, new DataType[]{DataTypes.DATE(), DataTypes.TIMESTAMP()});
        Assert.assertEquals((Object)-4182, (Object)udf.eval(new Object[]{Date.valueOf(d), Timestamp.valueOf(t2)}));
        udf = HiveGenericUDFTest.init(GenericUDFDateDiff.class, new Object[]{null, null}, new DataType[]{DataTypes.CHAR((int)2), DataTypes.VARCHAR((int)2)});
        Assert.assertEquals(null, (Object)udf.eval(new Object[]{t1, t2}));
    }

    @Test
    public void testArray() {
        HiveGenericUDF udf = HiveGenericUDFTest.init(TestGenericUDFArray.class, new Object[]{null}, new DataType[]{DataTypes.ARRAY((DataType)DataTypes.INT())});
        Assert.assertEquals((Object)6, (Object)udf.eval(new Object[]{1, 2, 3}));
        Assert.assertEquals((Object)6, (Object)udf.eval((Object[])new Integer[]{1, 2, 3}));
    }

    @Test
    public void testMap() {
        String testInput = "1:1,2:2,3:3";
        HiveGenericUDF udf = HiveGenericUDFTest.init(GenericUDFStringToMap.class, new Object[]{null}, new DataType[]{DataTypes.VARCHAR((int)testInput.length())});
        Assert.assertEquals((Object)new HashMap<String, String>(){
            {
                this.put("1", "1");
                this.put("2", "2");
                this.put("3", "3");
            }
        }, (Object)udf.eval(new Object[]{testInput}));
        HiveGenericUDF udf2 = HiveGenericUDFTest.init(GenericUDFMapKeys.class, new Object[]{null}, new DataType[]{DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.STRING())});
        Object[] result = (Object[])udf2.eval(new Object[]{udf.eval(new Object[]{testInput})});
        Assert.assertEquals((long)3L, (long)result.length);
        MatcherAssert.assertThat(Arrays.asList(result), (Matcher)Matchers.containsInAnyOrder((Object[])new Object[]{"1", "2", "3"}));
    }

    @Test
    public void testStruct() {
        HiveGenericUDF udf = HiveGenericUDFTest.init(GenericUDFStruct.class, new Object[]{null, null, null}, new DataType[]{DataTypes.INT(), DataTypes.CHAR((int)2), DataTypes.VARCHAR((int)10)});
        Row result = (Row)udf.eval(new Object[]{1, "222", "3"});
        Assert.assertEquals((Object)Row.of((Object[])new Object[]{1, "22", "3"}), (Object)result);
        udf = HiveGenericUDFTest.init(TestGenericUDFStructSize.class, new Object[]{null}, new DataType[]{DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"1", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"2", (DataType)DataTypes.CHAR((int)2)), DataTypes.FIELD((String)"3", (DataType)DataTypes.VARCHAR((int)10))})});
        Assert.assertEquals((Object)3, (Object)udf.eval(new Object[]{result}));
    }

    private static HiveGenericUDF init(Class hiveUdfClass, Object[] constantArgs, DataType[] argTypes) {
        HiveGenericUDF udf = new HiveGenericUDF(new HiveFunctionWrapper(hiveUdfClass.getName()), hiveShim);
        HiveSimpleUDFTest.HiveUDFCallContext callContext = new HiveSimpleUDFTest.HiveUDFCallContext(constantArgs, argTypes);
        udf.getTypeInference(null).getOutputTypeStrategy().inferType((CallContext)callContext);
        udf.open(null);
        return udf;
    }
}

