/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions.hive;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.catalog.hive.client.HiveShimLoader;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.hive.FlinkHiveUDFException;
import org.apache.flink.table.functions.hive.HiveFunctionWrapper;
import org.apache.flink.table.functions.hive.HiveSimpleUDF;
import org.apache.flink.table.functions.hive.util.TestHiveUDFArray;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.udf.UDFBase64;
import org.apache.hadoop.hive.ql.udf.UDFBin;
import org.apache.hadoop.hive.ql.udf.UDFConv;
import org.apache.hadoop.hive.ql.udf.UDFJson;
import org.apache.hadoop.hive.ql.udf.UDFRand;
import org.apache.hadoop.hive.ql.udf.UDFRegExpExtract;
import org.apache.hadoop.hive.ql.udf.UDFToInteger;
import org.apache.hadoop.hive.ql.udf.UDFUnhex;
import org.apache.hadoop.hive.ql.udf.UDFWeekOfYear;
import org.junit.Assert;
import org.junit.Test;

public class HiveSimpleUDFTest {
    private static HiveShim hiveShim = HiveShimLoader.loadHiveShim((String)HiveShimLoader.getHiveVersion());

    @Test
    public void testBooleanUDF() {
        HiveSimpleUDF udf = HiveSimpleUDFTest.init(BooleanUDF.class, new DataType[]{DataTypes.INT()});
        Assert.assertTrue((boolean)((Boolean)udf.eval(new Object[]{1})));
    }

    @Test
    public void testFloatUDF() {
        HiveSimpleUDF udf = HiveSimpleUDFTest.init(FloatUDF.class, new DataType[]{DataTypes.FLOAT()});
        Assert.assertEquals((float)3.0f, (float)((Float)udf.eval(new Object[]{Float.valueOf(3.0f)})).floatValue(), (float)0.0f);
    }

    @Test
    public void testIntUDF() {
        HiveSimpleUDF udf = HiveSimpleUDFTest.init(IntUDF.class, new DataType[]{DataTypes.INT()});
        Assert.assertEquals((long)3L, (long)((Integer)udf.eval(new Object[]{3})).intValue());
    }

    @Test
    public void testStringUDF() {
        HiveSimpleUDF udf = HiveSimpleUDFTest.init(StringUDF.class, new DataType[]{DataTypes.STRING()});
        Assert.assertEquals((Object)"test", (Object)udf.eval(new Object[]{"test"}));
    }

    @Test
    public void testUDFRand() {
        HiveSimpleUDF udf = HiveSimpleUDFTest.init(UDFRand.class, new DataType[0]);
        double result = (Double)udf.eval(new Object[0]);
        Assert.assertTrue((result >= 0.0 && result < 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void testUDFBin() {
        HiveSimpleUDF udf = HiveSimpleUDFTest.init(UDFBin.class, new DataType[]{DataTypes.INT()});
        Assert.assertEquals((Object)"1100", (Object)udf.eval(new Object[]{12}));
    }

    @Test
    public void testUDFConv() {
        HiveSimpleUDF udf = HiveSimpleUDFTest.init(UDFConv.class, new DataType[]{DataTypes.STRING(), DataTypes.INT(), DataTypes.INT()});
        Assert.assertEquals((Object)"1", (Object)udf.eval(new Object[]{"12", 2, 10}));
        Assert.assertEquals((Object)"-16", (Object)udf.eval(new Object[]{-10, 16, -10}));
    }

    @Test
    public void testUDFJson() {
        String pattern = "$.owner";
        String json = "{\"store\": \"test\", \"owner\": \"amy\"}";
        String expected = "amy";
        HiveSimpleUDF udf = HiveSimpleUDFTest.init(UDFJson.class, new DataType[]{DataTypes.STRING(), DataTypes.STRING()});
        Assert.assertEquals((Object)expected, (Object)udf.eval(new Object[]{json, pattern}));
        udf = HiveSimpleUDFTest.init(UDFJson.class, new DataType[]{DataTypes.CHAR((int)100), DataTypes.CHAR((int)pattern.length())});
        Assert.assertEquals((Object)expected, (Object)udf.eval(new Object[]{json, pattern}));
        udf = HiveSimpleUDFTest.init(UDFJson.class, new DataType[]{DataTypes.VARCHAR((int)100), DataTypes.VARCHAR((int)pattern.length())});
        Assert.assertEquals((Object)expected, (Object)udf.eval(new Object[]{json, pattern}));
        udf = HiveSimpleUDFTest.init(UDFJson.class, new DataType[]{DataTypes.CHAR((int)100), DataTypes.CHAR((int)(pattern.length() - 1))});
        Assert.assertEquals(null, (Object)udf.eval(new Object[]{json, pattern}));
    }

    @Test
    public void testUDFWeekOfYear() throws FlinkHiveUDFException {
        HiveSimpleUDF udf = HiveSimpleUDFTest.init(UDFWeekOfYear.class, new DataType[]{DataTypes.STRING()});
        Assert.assertEquals((Object)29, (Object)udf.eval(new Object[]{"1969-07-20"}));
        Assert.assertEquals((Object)29, (Object)udf.eval(new Object[]{Date.valueOf("1969-07-20")}));
        Assert.assertEquals((Object)29, (Object)udf.eval(new Object[]{Timestamp.valueOf("1969-07-20 00:00:00")}));
        Assert.assertEquals((Object)1, (Object)udf.eval(new Object[]{"1980-12-31 12:59:59"}));
    }

    @Test
    public void testUDFRegExpExtract() {
        HiveSimpleUDF udf = HiveSimpleUDFTest.init(UDFRegExpExtract.class, new DataType[]{DataTypes.STRING(), DataTypes.STRING(), DataTypes.INT()});
        Assert.assertEquals((Object)"100", (Object)udf.eval(new Object[]{"100-200", "(\\d+)-(\\d+)", 1}));
    }

    @Test
    public void testUDFUnbase64() {
        HiveSimpleUDF udf = HiveSimpleUDFTest.init(UDFBase64.class, new DataType[]{DataTypes.BYTES()});
        Assert.assertEquals((Object)"Cg==", (Object)udf.eval(new Object[]{new byte[]{10}}));
    }

    @Test
    public void testUDFUnhex() throws UnsupportedEncodingException {
        HiveSimpleUDF udf = HiveSimpleUDFTest.init(UDFUnhex.class, new DataType[]{DataTypes.STRING()});
        Assert.assertEquals((Object)"MySQL", (Object)new String((byte[])udf.eval(new Object[]{"4D7953514C"}), "UTF-8"));
    }

    @Test
    public void testUDFToInteger() {
        HiveSimpleUDF udf = HiveSimpleUDFTest.init(UDFToInteger.class, new DataType[]{DataTypes.DECIMAL((int)5, (int)3)});
        Assert.assertEquals((Object)1, (Object)udf.eval(new Object[]{BigDecimal.valueOf(1.1)}));
    }

    @Test
    public void testUDFArray_singleArray() {
        Object[] testInputs = new Double[]{1.1, 2.2};
        HiveSimpleUDF udf = HiveSimpleUDFTest.init(TestHiveUDFArray.class, new DataType[]{DataTypes.ARRAY((DataType)DataTypes.DOUBLE())});
        Assert.assertEquals((Object)3, (Object)udf.eval(new Object[]{1.1, 2.2}));
        Assert.assertEquals((Object)3, (Object)udf.eval(testInputs));
        udf = HiveSimpleUDFTest.init(TestHiveUDFArray.class, new DataType[]{DataTypes.INT(), DataTypes.ARRAY((DataType)DataTypes.DOUBLE())});
        Assert.assertEquals((Object)8, (Object)udf.eval(new Object[]{5, testInputs}));
        udf = HiveSimpleUDFTest.init(TestHiveUDFArray.class, new DataType[]{DataTypes.INT(), DataTypes.ARRAY((DataType)DataTypes.DOUBLE()), DataTypes.ARRAY((DataType)DataTypes.DOUBLE())});
        Assert.assertEquals((Object)11, (Object)udf.eval(new Object[]{5, testInputs, testInputs}));
    }

    protected static HiveSimpleUDF init(Class hiveUdfClass, DataType[] argTypes) {
        HiveSimpleUDF udf = new HiveSimpleUDF(new HiveFunctionWrapper(hiveUdfClass.getName()), hiveShim);
        HiveUDFCallContext callContext = new HiveUDFCallContext(new Object[0], argTypes);
        udf.getTypeInference(null).getOutputTypeStrategy().inferType((CallContext)callContext);
        udf.open(null);
        return udf;
    }

    public static class HiveUDFCallContext
    implements CallContext {
        private final Object[] constantArgs;
        private final DataType[] argTypes;

        public HiveUDFCallContext(Object[] constantArgs, DataType[] argTypes) {
            this.constantArgs = constantArgs;
            this.argTypes = argTypes;
        }

        public DataTypeFactory getDataTypeFactory() {
            return null;
        }

        public FunctionDefinition getFunctionDefinition() {
            return null;
        }

        public boolean isArgumentLiteral(int pos) {
            return pos >= 0 && pos < this.constantArgs.length && this.constantArgs[pos] != null;
        }

        public boolean isArgumentNull(int pos) {
            return false;
        }

        public <T> Optional<T> getArgumentValue(int pos, Class<T> clazz) {
            return Optional.of(this.constantArgs[pos]);
        }

        public String getName() {
            return null;
        }

        public List<DataType> getArgumentDataTypes() {
            return Arrays.asList(this.argTypes);
        }

        public Optional<DataType> getOutputDataType() {
            return Optional.empty();
        }

        public boolean isGroupedAggregation() {
            return false;
        }
    }

    public static class StringUDF
    extends UDF {
        public String evaluate(String content) {
            return content;
        }
    }

    public static class IntUDF
    extends UDF {
        public int evaluate(int content) {
            return content;
        }
    }

    public static class FloatUDF
    extends UDF {
        public float evaluate(float content) {
            return content;
        }
    }

    public static class BooleanUDF
    extends UDF {
        public boolean evaluate(int content) {
            return content == 1;
        }
    }
}

