/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.module.hive;

import java.util.Iterator;
import java.util.List;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.catalog.hive.HiveTestUtils;
import org.apache.flink.table.catalog.hive.client.HiveShimLoader;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.hive.HiveSimpleUDF;
import org.apache.flink.table.functions.hive.HiveSimpleUDFTest;
import org.apache.flink.table.module.CoreModule;
import org.apache.flink.table.module.Module;
import org.apache.flink.table.module.hive.HiveModule;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.utils.LegacyRowResource;
import org.apache.flink.util.CollectionUtil;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class HiveModuleTest {
    @Rule
    public final LegacyRowResource usesLegacyRows = LegacyRowResource.INSTANCE;

    @Test
    public void testNumberOfBuiltinFunctions() {
        String hiveVersion = HiveShimLoader.getHiveVersion();
        HiveModule hiveModule = new HiveModule(hiveVersion);
        this.verifyNumBuiltInFunctions(hiveVersion, hiveModule);
        TableEnvironment tableEnv = HiveTestUtils.createTableEnvInBatchMode();
        tableEnv.executeSql("create function myudf as 'org.apache.hadoop.hive.ql.udf.UDFPI'");
        tableEnv.executeSql("create function mygenericudf as 'org.apache.hadoop.hive.ql.udf.generic.GenericUDFAbs'");
        tableEnv.executeSql("create function myudaf as 'org.apache.hadoop.hive.ql.udf.generic.GenericUDAFMax'");
        tableEnv.executeSql("create function myudtf as 'org.apache.hadoop.hive.ql.udf.generic.GenericUDTFExplode'");
        this.verifyNumBuiltInFunctions(hiveVersion, hiveModule);
        Assert.assertFalse((boolean)hiveModule.getFunctionDefinition("myudf").isPresent());
        Assert.assertFalse((boolean)hiveModule.getFunctionDefinition("mygenericudf").isPresent());
        Assert.assertFalse((boolean)hiveModule.getFunctionDefinition("myudaf").isPresent());
        Assert.assertFalse((boolean)hiveModule.getFunctionDefinition("myudtf").isPresent());
    }

    private void verifyNumBuiltInFunctions(String hiveVersion, HiveModule hiveModule) {
        switch (hiveVersion) {
            case "1.0.1": {
                Assert.assertEquals((long)196L, (long)hiveModule.listFunctions().size());
                break;
            }
            case "1.1.0": {
                Assert.assertEquals((long)201L, (long)hiveModule.listFunctions().size());
                break;
            }
            case "1.2.1": {
                Assert.assertEquals((long)221L, (long)hiveModule.listFunctions().size());
                break;
            }
            case "2.0.0": {
                Assert.assertEquals((long)232L, (long)hiveModule.listFunctions().size());
                break;
            }
            case "2.1.1": {
                Assert.assertEquals((long)242L, (long)hiveModule.listFunctions().size());
                break;
            }
            case "2.2.0": {
                Assert.assertEquals((long)257L, (long)hiveModule.listFunctions().size());
                break;
            }
            case "2.3.4": {
                Assert.assertEquals((long)275L, (long)hiveModule.listFunctions().size());
                break;
            }
            case "3.1.1": {
                Assert.assertEquals((long)294L, (long)hiveModule.listFunctions().size());
                break;
            }
            default: {
                Assert.fail((String)("Unknown test version " + hiveVersion));
            }
        }
    }

    @Test
    public void testHiveBuiltInFunction() {
        FunctionDefinition fd = (FunctionDefinition)new HiveModule().getFunctionDefinition("reverse").get();
        HiveSimpleUDF udf = (HiveSimpleUDF)fd;
        DataType[] inputType = new DataType[]{DataTypes.STRING()};
        HiveSimpleUDFTest.HiveUDFCallContext callContext = new HiveSimpleUDFTest.HiveUDFCallContext(new Object[0], inputType);
        udf.getTypeInference(null).getOutputTypeStrategy().inferType((CallContext)callContext);
        udf.open(null);
        Assert.assertEquals((Object)"cba", (Object)udf.eval(new Object[]{"abc"}));
    }

    @Test
    public void testNonExistFunction() {
        Assert.assertFalse((boolean)new HiveModule().getFunctionDefinition("nonexist").isPresent());
    }

    @Test
    public void testConstantArguments() {
        TableEnvironment tEnv = HiveTestUtils.createTableEnvInBatchMode();
        tEnv.unloadModule("core");
        tEnv.loadModule("hive", (Module)new HiveModule());
        List results = CollectionUtil.iteratorToList((Iterator)tEnv.sqlQuery("select concat('an', 'bn')").execute().collect());
        Assert.assertEquals((Object)"[anbn]", (Object)results.toString());
        results = CollectionUtil.iteratorToList((Iterator)tEnv.sqlQuery("select concat('ab', cast('cdefghi' as varchar(5)))").execute().collect());
        Assert.assertEquals((Object)"[abcdefg]", (Object)results.toString());
        results = CollectionUtil.iteratorToList((Iterator)tEnv.sqlQuery("select concat('ab',cast(12.34 as decimal(10,5)))").execute().collect());
        Assert.assertEquals((Object)"[ab12.34]", (Object)results.toString());
        results = CollectionUtil.iteratorToList((Iterator)tEnv.sqlQuery("select concat(cast('2018-01-19' as date),cast('2019-12-27 17:58:23.385' as timestamp))").execute().collect());
        Assert.assertEquals((Object)"[2018-01-192019-12-27 17:58:23.385]", (Object)results.toString());
        results = CollectionUtil.iteratorToList((Iterator)tEnv.sqlQuery("select concat('ab',cast(null as int))").execute().collect());
        Assert.assertEquals((Object)"[null]", (Object)results.toString());
    }

    @Test
    public void testDecimalReturnType() {
        TableEnvironment tEnv = HiveTestUtils.createTableEnvInBatchMode();
        tEnv.unloadModule("core");
        tEnv.loadModule("hive", (Module)new HiveModule());
        List results = CollectionUtil.iteratorToList((Iterator)tEnv.sqlQuery("select negative(5.1)").execute().collect());
        Assert.assertEquals((Object)"[-5.1]", (Object)results.toString());
    }

    @Test
    public void testBlackList() {
        HiveModule hiveModule = new HiveModule();
        Assert.assertFalse((boolean)hiveModule.listFunctions().removeAll(HiveModule.BUILT_IN_FUNC_BLACKLIST));
        for (String banned : HiveModule.BUILT_IN_FUNC_BLACKLIST) {
            Assert.assertFalse((boolean)hiveModule.getFunctionDefinition(banned).isPresent());
        }
    }

    @Test
    public void testConstantReturnValue() {
        TableEnvironment tableEnv = HiveTestUtils.createTableEnvInBatchMode();
        tableEnv.unloadModule("core");
        tableEnv.loadModule("hive", (Module)new HiveModule());
        List results = CollectionUtil.iteratorToList((Iterator)tableEnv.sqlQuery("select str_to_map('a:1,b:2,c:3',',',':')").execute().collect());
        Assert.assertEquals((Object)"[{a=1, b=2, c=3}]", (Object)results.toString());
    }

    @Test
    public void testEmptyStringLiteralParameters() {
        TableEnvironment tableEnv = HiveTestUtils.createTableEnvInBatchMode();
        tableEnv.unloadModule("core");
        tableEnv.loadModule("hive", (Module)new HiveModule());
        List results = CollectionUtil.iteratorToList((Iterator)tableEnv.sqlQuery("select regexp_replace('foobar','oo|ar','')").execute().collect());
        Assert.assertEquals((Object)"[fb]", (Object)results.toString());
        results = CollectionUtil.iteratorToList((Iterator)tableEnv.sqlQuery("select length('')").execute().collect());
        Assert.assertEquals((Object)"[0]", (Object)results.toString());
    }

    @Test
    public void testFunctionsNeedSessionState() {
        TableEnvironment tableEnv = HiveTestUtils.createTableEnvInBatchMode();
        tableEnv.unloadModule("core");
        tableEnv.loadModule("hive", (Module)new HiveModule());
        tableEnv.loadModule("core", (Module)CoreModule.INSTANCE);
        tableEnv.sqlQuery("select current_timestamp,current_date").execute().collect();
        List results = CollectionUtil.iteratorToList((Iterator)tableEnv.sqlQuery("select mod(-1,2),pmod(-1,2)").execute().collect());
        Assert.assertEquals((Object)"[-1,1]", (Object)results.toString());
    }

    @Test
    public void testCallUDFWithNoParam() {
        TableEnvironment tableEnv = HiveTestUtils.createTableEnvInBatchMode();
        tableEnv.unloadModule("core");
        tableEnv.loadModule("hive", (Module)new HiveModule());
        tableEnv.loadModule("core", (Module)CoreModule.INSTANCE);
        List results = CollectionUtil.iteratorToList((Iterator)tableEnv.sqlQuery("select `array`(),`map`()").execute().collect());
        Assert.assertEquals((Object)"[[],{}]", (Object)results.toString());
    }
}

