/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.apache.flink.connectors.hive.JobConfWrapper;
import org.apache.flink.connectors.hive.util.HiveConfUtils;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.catalog.hive.client.HiveMetastoreClientFactory;
import org.apache.flink.table.catalog.hive.client.HiveMetastoreClientWrapper;
import org.apache.flink.table.catalog.hive.util.HiveTableUtil;
import org.apache.flink.table.filesystem.TableMetaStoreFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.mapred.JobConf;
import org.apache.thrift.TException;

public class HiveTableMetaStoreFactory
implements TableMetaStoreFactory {
    private static final long serialVersionUID = 1L;
    private final JobConfWrapper conf;
    private final String hiveVersion;
    private final String database;
    private final String tableName;

    HiveTableMetaStoreFactory(JobConf conf, String hiveVersion, String database, String tableName) {
        this.conf = new JobConfWrapper(conf);
        this.hiveVersion = hiveVersion;
        this.database = database;
        this.tableName = tableName;
    }

    public HiveTableMetaStore createTableMetaStore() throws Exception {
        return new HiveTableMetaStore();
    }

    private class HiveTableMetaStore
    implements TableMetaStoreFactory.TableMetaStore {
        private HiveMetastoreClientWrapper client;
        private StorageDescriptor sd;

        private HiveTableMetaStore() throws TException {
            this.client = HiveMetastoreClientFactory.create(HiveConfUtils.create((Configuration)HiveTableMetaStoreFactory.this.conf.conf()), HiveTableMetaStoreFactory.this.hiveVersion);
            this.sd = this.client.getTable(HiveTableMetaStoreFactory.this.database, HiveTableMetaStoreFactory.this.tableName).getSd();
        }

        public Path getLocationPath() {
            return new Path(this.sd.getLocation());
        }

        public Optional<Path> getPartition(LinkedHashMap<String, String> partSpec) throws Exception {
            try {
                return Optional.of(new Path(this.client.getPartition(HiveTableMetaStoreFactory.this.database, HiveTableMetaStoreFactory.this.tableName, new ArrayList<String>(partSpec.values())).getSd().getLocation()));
            }
            catch (NoSuchObjectException ignore) {
                return Optional.empty();
            }
        }

        public void createOrAlterPartition(LinkedHashMap<String, String> partitionSpec, Path partitionPath) throws Exception {
            Partition partition;
            try {
                partition = this.client.getPartition(HiveTableMetaStoreFactory.this.database, HiveTableMetaStoreFactory.this.tableName, new ArrayList<String>(partitionSpec.values()));
            }
            catch (NoSuchObjectException e) {
                this.createPartition(partitionSpec, partitionPath);
                return;
            }
            this.alterPartition(partitionSpec, partitionPath, partition);
        }

        private void createPartition(LinkedHashMap<String, String> partSpec, Path path) throws Exception {
            StorageDescriptor newSd = new StorageDescriptor(this.sd);
            newSd.setLocation(path.toString());
            Partition partition = HiveTableUtil.createHivePartition(HiveTableMetaStoreFactory.this.database, HiveTableMetaStoreFactory.this.tableName, new ArrayList<String>(partSpec.values()), newSd, new HashMap<String, String>());
            partition.setValues(new ArrayList<String>(partSpec.values()));
            this.client.add_partition(partition);
        }

        private void alterPartition(LinkedHashMap<String, String> partitionSpec, Path partitionPath, Partition currentPartition) throws Exception {
            StorageDescriptor partSD = currentPartition.getSd();
            partSD.setOutputFormat(this.sd.getOutputFormat());
            partSD.setInputFormat(this.sd.getInputFormat());
            partSD.getSerdeInfo().setSerializationLib(this.sd.getSerdeInfo().getSerializationLib());
            partSD.getSerdeInfo().setParameters(this.sd.getSerdeInfo().getParameters());
            partSD.setBucketCols(this.sd.getBucketCols());
            partSD.setNumBuckets(this.sd.getNumBuckets());
            partSD.setSortCols(this.sd.getSortCols());
            partSD.setLocation(partitionPath.toString());
            this.client.alter_partition(HiveTableMetaStoreFactory.this.database, HiveTableMetaStoreFactory.this.tableName, currentPartition);
        }

        public void close() {
            this.client.close();
        }
    }
}

