/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive.util;

import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.flink.connectors.hive.FlinkHiveException;
import org.apache.flink.connectors.hive.HiveTablePartition;
import org.apache.flink.connectors.hive.util.HiveConfUtils;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.hive.client.HiveMetastoreClientFactory;
import org.apache.flink.table.catalog.hive.client.HiveMetastoreClientWrapper;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.catalog.hive.client.HiveShimLoader;
import org.apache.flink.table.catalog.hive.util.HiveReflectionUtils;
import org.apache.flink.table.functions.hive.conversion.HiveInspectors;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.mapred.JobConf;
import org.apache.thrift.TException;

public class HivePartitionUtils {
    public static Map<String, Object> parsePartitionValues(Map<String, String> partitionSpecs, String[] fieldNames, DataType[] fieldTypes, String defaultPartitionName, HiveShim shim) {
        Preconditions.checkArgument((fieldNames.length == fieldTypes.length ? 1 : 0) != 0);
        List<String> fieldNameList = Arrays.asList(fieldNames);
        HashMap<String, Object> partitionColValues = new HashMap<String, Object>();
        for (Map.Entry<String, String> spec : partitionSpecs.entrySet()) {
            String partitionKey = spec.getKey();
            String valueString = spec.getValue();
            int index = fieldNameList.indexOf(partitionKey);
            if (index < 0) {
                throw new IllegalStateException(String.format("Partition spec %s and column names %s doesn't match", partitionSpecs, fieldNameList));
            }
            LogicalType partitionType = fieldTypes[index].getLogicalType();
            Object value = HivePartitionUtils.restorePartitionValueFromType(shim, valueString, partitionType, defaultPartitionName);
            partitionColValues.put(partitionKey, value);
        }
        return partitionColValues;
    }

    public static Object restorePartitionValueFromType(HiveShim shim, String valStr, LogicalType partitionType, String defaultPartitionName) {
        if (defaultPartitionName.equals(valStr)) {
            if (LogicalTypeChecks.hasFamily((LogicalType)partitionType, (LogicalTypeFamily)LogicalTypeFamily.CHARACTER_STRING)) {
                return defaultPartitionName;
            }
            return null;
        }
        LogicalTypeRoot typeRoot = partitionType.getTypeRoot();
        switch (typeRoot) {
            case CHAR: 
            case VARCHAR: {
                return valStr;
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(valStr);
            }
            case TINYINT: {
                return Integer.valueOf(valStr).byteValue();
            }
            case SMALLINT: {
                return Short.valueOf(valStr);
            }
            case INTEGER: {
                return Integer.valueOf(valStr);
            }
            case BIGINT: {
                return Long.valueOf(valStr);
            }
            case FLOAT: {
                return Float.valueOf(valStr);
            }
            case DOUBLE: {
                return Double.valueOf(valStr);
            }
            case DATE: {
                return HiveInspectors.toFlinkObject(HiveInspectors.getObjectInspector(partitionType), shim.toHiveDate(Date.valueOf(valStr)), shim);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return HiveInspectors.toFlinkObject(HiveInspectors.getObjectInspector(partitionType), shim.toHiveTimestamp(Timestamp.valueOf(valStr)), shim);
            }
        }
        throw new FlinkHiveException(new IllegalArgumentException(String.format("Can not convert %s to type %s for partition value", valStr, partitionType)));
    }

    public static List<HiveTablePartition> getAllPartitions(JobConf jobConf, String hiveVersion, ObjectPath tablePath, List<String> partitionColNames, List<Map<String, String>> remainingPartitions) {
        ArrayList<HiveTablePartition> allHivePartitions = new ArrayList<HiveTablePartition>();
        try (HiveMetastoreClientWrapper client = HiveMetastoreClientFactory.create(HiveConfUtils.create((Configuration)jobConf), hiveVersion);){
            String dbName = tablePath.getDatabaseName();
            String tableName = tablePath.getObjectName();
            Table hiveTable = client.getTable(dbName, tableName);
            Properties tableProps = HiveReflectionUtils.getTableMetadata(HiveShimLoader.loadHiveShim(hiveVersion), hiveTable);
            if (partitionColNames != null && partitionColNames.size() > 0) {
                ArrayList<Partition> partitions = new ArrayList<Partition>();
                if (remainingPartitions != null) {
                    for (Map<String, String> spec : remainingPartitions) {
                        partitions.add(client.getPartition(dbName, tableName, HivePartitionUtils.partitionSpecToValues(spec, partitionColNames)));
                    }
                } else {
                    partitions.addAll(client.listPartitions(dbName, tableName, (short)-1));
                }
                for (Partition partition : partitions) {
                    HiveTablePartition hiveTablePartition = HivePartitionUtils.toHiveTablePartition(partitionColNames, tableProps, partition);
                    allHivePartitions.add(hiveTablePartition);
                }
            } else {
                allHivePartitions.add(new HiveTablePartition(hiveTable.getSd(), tableProps));
            }
        }
        catch (TException e) {
            throw new FlinkHiveException("Failed to collect all partitions from hive metaStore", e);
        }
        return allHivePartitions;
    }

    public static List<String> partitionSpecToValues(Map<String, String> spec, List<String> partitionColNames) {
        Preconditions.checkArgument((spec.size() == partitionColNames.size() && spec.keySet().containsAll(partitionColNames) ? 1 : 0) != 0, (String)"Partition spec (%s) and partition column names (%s) doesn't match", (Object[])new Object[]{spec, partitionColNames});
        return partitionColNames.stream().map(spec::get).collect(Collectors.toList());
    }

    public static HiveTablePartition toHiveTablePartition(List<String> partitionKeys, Properties tableProps, Partition partition) {
        StorageDescriptor sd = partition.getSd();
        HashMap<String, String> partitionSpec = new HashMap<String, String>();
        for (int i = 0; i < partitionKeys.size(); ++i) {
            String partitionColName = partitionKeys.get(i);
            String partitionValue = (String)partition.getValues().get(i);
            partitionSpec.put(partitionColName, partitionValue);
        }
        return new HiveTablePartition(sd, partitionSpec, tableProps);
    }

    public static FileStatus[] getFileStatusRecurse(Path path, int expectLevel, FileSystem fs) {
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        try {
            FileStatus fileStatus = fs.getFileStatus(path);
            HivePartitionUtils.listStatusRecursively(fs, fileStatus, 0, expectLevel, result);
        }
        catch (IOException ignore) {
            return new FileStatus[0];
        }
        return result.toArray(new FileStatus[0]);
    }

    private static void listStatusRecursively(FileSystem fs, FileStatus fileStatus, int level, int expectLevel, List<FileStatus> results) throws IOException {
        if (expectLevel == level) {
            results.add(fileStatus);
            return;
        }
        if (fileStatus.isDir()) {
            for (FileStatus stat : fs.listStatus(fileStatus.getPath())) {
                HivePartitionUtils.listStatusRecursively(fs, stat, level + 1, expectLevel, results);
            }
        }
    }
}

