/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive.write;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import org.apache.flink.connectors.hive.CachedSerializedValue;
import org.apache.flink.connectors.hive.FlinkHiveException;
import org.apache.flink.connectors.hive.JobConfWrapper;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.util.DataFormatConverters;
import org.apache.flink.table.functions.hive.conversion.HiveInspectors;
import org.apache.flink.table.functions.hive.conversion.HiveObjectConversion;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;

public class HiveWriterFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Class hiveOutputFormatClz;
    private final CachedSerializedValue<SerDeInfo> serDeInfo;
    private final String[] allColumns;
    private final DataType[] allTypes;
    private final String[] partitionColumns;
    private final Properties tableProperties;
    private final JobConfWrapper confWrapper;
    private final HiveShim hiveShim;
    private final boolean isCompressed;
    private transient Serializer recordSerDe;
    private transient int formatFields;
    private transient HiveObjectConversion[] hiveConversions;
    private transient DataFormatConverters.DataFormatConverter[] converters;
    private transient StructObjectInspector formatInspector;
    private transient boolean initialized;

    public HiveWriterFactory(JobConf jobConf, Class hiveOutputFormatClz, SerDeInfo serDeInfo, TableSchema schema, String[] partitionColumns, Properties tableProperties, HiveShim hiveShim, boolean isCompressed) {
        Preconditions.checkArgument((boolean)HiveOutputFormat.class.isAssignableFrom(hiveOutputFormatClz), (Object)"The output format should be an instance of HiveOutputFormat");
        this.confWrapper = new JobConfWrapper(jobConf);
        this.hiveOutputFormatClz = hiveOutputFormatClz;
        try {
            this.serDeInfo = new CachedSerializedValue<SerDeInfo>(serDeInfo);
        }
        catch (IOException e) {
            throw new FlinkHiveException("Failed to serialize SerDeInfo", e);
        }
        this.allColumns = schema.getFieldNames();
        this.allTypes = schema.getFieldDataTypes();
        this.partitionColumns = partitionColumns;
        this.tableProperties = tableProperties;
        this.hiveShim = hiveShim;
        this.isCompressed = isCompressed;
    }

    public FileSinkOperator.RecordWriter createRecordWriter(Path path) {
        try {
            this.checkInitialize();
            JobConf conf = new JobConf((Configuration)this.confWrapper.conf());
            if (this.isCompressed) {
                String typeStr;
                String codecStr = conf.get(HiveConf.ConfVars.COMPRESSINTERMEDIATECODEC.varname);
                if (!StringUtils.isNullOrWhitespaceOnly((String)codecStr)) {
                    Class<?> codec = Class.forName(codecStr, true, Thread.currentThread().getContextClassLoader());
                    FileOutputFormat.setOutputCompressorClass((JobConf)conf, codec);
                }
                if (!StringUtils.isNullOrWhitespaceOnly((String)(typeStr = conf.get(HiveConf.ConfVars.COMPRESSINTERMEDIATETYPE.varname)))) {
                    SequenceFile.CompressionType style = SequenceFile.CompressionType.valueOf((String)typeStr);
                    SequenceFileOutputFormat.setOutputCompressionType((JobConf)conf, (SequenceFile.CompressionType)style);
                }
            }
            return this.hiveShim.getHiveRecordWriter(conf, this.hiveOutputFormatClz, this.recordSerDe.getSerializedClass(), this.isCompressed, this.tableProperties, path);
        }
        catch (Exception e) {
            throw new FlinkHiveException(e);
        }
    }

    public JobConf getJobConf() {
        return this.confWrapper.conf();
    }

    private void checkInitialize() throws Exception {
        if (this.initialized) {
            return;
        }
        JobConf jobConf = this.confWrapper.conf();
        Object serdeLib = Class.forName(this.serDeInfo.deserializeValue().getSerializationLib()).newInstance();
        Preconditions.checkArgument((serdeLib instanceof Serializer && serdeLib instanceof Deserializer ? 1 : 0) != 0, (Object)("Expect a SerDe lib implementing both Serializer and Deserializer, but actually got " + serdeLib.getClass().getName()));
        this.recordSerDe = (Serializer)serdeLib;
        ReflectionUtils.setConf((Object)this.recordSerDe, (Configuration)jobConf);
        SerDeUtils.initializeSerDe((Deserializer)((Deserializer)this.recordSerDe), (Configuration)jobConf, (Properties)this.tableProperties, null);
        this.formatFields = this.allColumns.length - this.partitionColumns.length;
        this.hiveConversions = new HiveObjectConversion[this.formatFields];
        this.converters = new DataFormatConverters.DataFormatConverter[this.formatFields];
        ArrayList<ObjectInspector> objectInspectors = new ArrayList<ObjectInspector>(this.hiveConversions.length);
        for (int i = 0; i < this.formatFields; ++i) {
            DataType type = this.allTypes[i];
            ObjectInspector objectInspector = HiveInspectors.getObjectInspector(type);
            objectInspectors.add(objectInspector);
            this.hiveConversions[i] = HiveInspectors.getConversion(objectInspector, type.getLogicalType(), this.hiveShim);
            this.converters[i] = DataFormatConverters.getConverterForDataType((DataType)type);
        }
        this.formatInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList(this.allColumns).subList(0, this.formatFields), objectInspectors);
        this.initialized = true;
    }

    public Function<Row, Writable> createRowConverter() {
        return row -> {
            ArrayList<Object> fields = new ArrayList<Object>(this.formatFields);
            for (int i = 0; i < this.formatFields; ++i) {
                fields.add(this.hiveConversions[i].toHiveObject(row.getField(i)));
            }
            return this.serialize(fields);
        };
    }

    public Function<RowData, Writable> createRowDataConverter() {
        return row -> {
            ArrayList<Object> fields = new ArrayList<Object>(this.formatFields);
            for (int i = 0; i < this.formatFields; ++i) {
                fields.add(this.hiveConversions[i].toHiveObject(this.converters[i].toExternal(row, i)));
            }
            return this.serialize(fields);
        };
    }

    private Writable serialize(List<Object> fields) {
        try {
            return this.recordSerDe.serialize(fields, (ObjectInspector)this.formatInspector);
        }
        catch (SerDeException e) {
            throw new FlinkHiveException(e);
        }
    }
}

