/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.module.hive.udf.generic;

import java.util.BitSet;
import org.apache.flink.table.planner.delegation.hive.HiveParserUtils;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.io.LongWritable;

public class GenericUDFLegacyGroupingID
extends GenericUDF {
    public static final String NAME = "_legacy_grouping__id";
    private transient PrimitiveObjectInspector groupingIdOI;
    private int numExprs;
    private final LongWritable legacyValue = new LongWritable();

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("Expect 2 arguments but actually got " + arguments.length);
        }
        if (arguments[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "First argument should be primitive type");
        }
        if (arguments[1].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(1, "Second argument should be primitive type");
        }
        this.groupingIdOI = (PrimitiveObjectInspector)arguments[0];
        if (this.groupingIdOI.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.LONG) {
            throw new UDFArgumentTypeException(0, "First argument should be a long");
        }
        PrimitiveObjectInspector numExprOI = (PrimitiveObjectInspector)arguments[1];
        if (numExprOI.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.INT) {
            throw new UDFArgumentTypeException(1, "Second argument should be an int");
        }
        if (!(numExprOI instanceof ConstantObjectInspector)) {
            throw new UDFArgumentTypeException(1, "Second argument should be a constant");
        }
        this.numExprs = PrimitiveObjectInspectorUtils.getInt((Object)((ConstantObjectInspector)numExprOI).getWritableConstantValue(), (PrimitiveObjectInspector)numExprOI);
        if (this.numExprs < 1 || this.numExprs > 64) {
            throw new UDFArgumentException("Number of GROUP BY expressions out of range: " + this.numExprs);
        }
        return PrimitiveObjectInspectorFactory.writableLongObjectInspector;
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        long groupingId = PrimitiveObjectInspectorUtils.getLong((Object)arguments[0].get(), (PrimitiveObjectInspector)this.groupingIdOI);
        BitSet bitSet = BitSet.valueOf(new long[]{groupingId});
        bitSet.flip(0, this.numExprs);
        int i = 0;
        for (int j = this.numExprs - 1; i < j; ++i, --j) {
            bitSet.set(i, bitSet.get(i) ^ bitSet.get(j));
            bitSet.set(j, bitSet.get(i) ^ bitSet.get(j));
            bitSet.set(i, bitSet.get(i) ^ bitSet.get(j));
        }
        long[] words = bitSet.toLongArray();
        this.legacyValue.set(words.length == 0 ? 0L : words[0]);
        return this.legacyValue;
    }

    public String getDisplayString(String[] children) {
        return HiveParserUtils.getStandardDisplayString("grouping", children);
    }
}

