/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlCastFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ConversionUtil;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.TimestampString;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.catalog.hive.util.HiveReflectionUtils;
import org.apache.flink.table.planner.delegation.hive.HiveParserDMLHelper;
import org.apache.flink.table.planner.delegation.hive.HiveParserIN;
import org.apache.flink.table.planner.delegation.hive.HiveParserUtils;
import org.apache.flink.table.planner.delegation.hive.SqlFunctionConverter;
import org.apache.flink.table.planner.delegation.hive.SqlOperatorExprNodeDesc;
import org.apache.flink.table.planner.delegation.hive.copy.HiveASTParseUtils;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserExprNodeDescUtils;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserExprNodeSubQueryDesc;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserIntervalDayTime;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserIntervalYearMonth;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserRowResolver;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserSqlFunctionConverter;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserTypeConverter;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.hive.common.type.Decimal128;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.SettableUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseCompare;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseNumeric;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCase;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToBinary;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToChar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDecimal;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUnixTimeStamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToVarchar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUnixTimeStamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFWhen;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class HiveParserRexNodeConverter {
    private static final Class genericUDFBaseBinaryClz = HiveReflectionUtils.tryGetClass("org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseBinary");
    private static final BigInteger MIN_LONG_BI = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger MAX_LONG_BI = BigInteger.valueOf(Long.MAX_VALUE);
    private final RelOptCluster cluster;
    private final List<InputCtx> inputCtxs;
    private final boolean flattenExpr;
    private final SqlFunctionConverter funcConverter;
    private final HiveParserRowResolver outerRR;
    private final Map<String, Integer> outerNameToPos;
    private int correlatedId;

    public HiveParserRexNodeConverter(RelOptCluster cluster, RelDataType inpDataType, Map<String, Integer> outerNameToPos, Map<String, Integer> nameToPos, HiveParserRowResolver hiveRR, HiveParserRowResolver outerRR, int offset, boolean flattenExpr, int correlatedId, SqlFunctionConverter funcConverter) {
        this.cluster = cluster;
        this.inputCtxs = Collections.singletonList(new InputCtx(inpDataType, nameToPos, hiveRR, offset));
        this.flattenExpr = flattenExpr;
        this.outerRR = outerRR;
        this.outerNameToPos = outerNameToPos;
        this.correlatedId = correlatedId;
        this.funcConverter = funcConverter;
    }

    public HiveParserRexNodeConverter(RelOptCluster cluster, RelDataType inpDataType, Map<String, Integer> nameToPosMap, int offset, boolean flattenExpr, SqlFunctionConverter funcConverter) {
        this.cluster = cluster;
        this.inputCtxs = Collections.singletonList(new InputCtx(inpDataType, nameToPosMap, null, offset));
        this.flattenExpr = flattenExpr;
        this.outerRR = null;
        this.outerNameToPos = null;
        this.funcConverter = funcConverter;
    }

    private HiveParserRexNodeConverter(RelOptCluster cluster, List<InputCtx> inpCtxLst, boolean flattenExpr, SqlFunctionConverter funcConverter) {
        this.cluster = cluster;
        this.inputCtxs = Collections.unmodifiableList(new ArrayList<InputCtx>(inpCtxLst));
        this.flattenExpr = flattenExpr;
        this.outerRR = null;
        this.outerNameToPos = null;
        this.funcConverter = funcConverter;
    }

    public static RexNode convert(RelOptCluster cluster, ExprNodeDesc joinCondnExprNode, List<RelNode> inputRels, LinkedHashMap<RelNode, HiveParserRowResolver> relToHiveRR, Map<RelNode, Map<String, Integer>> relToHiveColNameCalcitePosMap, boolean flattenExpr, SqlFunctionConverter funcConverter) throws SemanticException {
        ArrayList<InputCtx> inputCtxLst = new ArrayList<InputCtx>();
        int offSet = 0;
        for (RelNode r : inputRels) {
            inputCtxLst.add(new InputCtx(r.getRowType(), relToHiveColNameCalcitePosMap.get(r), relToHiveRR.get(r), offSet));
            offSet += r.getRowType().getFieldCount();
        }
        return new HiveParserRexNodeConverter(cluster, inputCtxLst, flattenExpr, funcConverter).convert(joinCondnExprNode);
    }

    public RexNode convert(ExprNodeDesc expr) throws SemanticException {
        if (expr instanceof ExprNodeGenericFuncDesc) {
            return this.convertGenericFunc((ExprNodeGenericFuncDesc)expr);
        }
        if (expr instanceof ExprNodeConstantDesc) {
            return HiveParserRexNodeConverter.convertConstant((ExprNodeConstantDesc)expr, this.cluster);
        }
        if (expr instanceof ExprNodeColumnDesc) {
            return this.convertColumn((ExprNodeColumnDesc)expr);
        }
        if (expr instanceof ExprNodeFieldDesc) {
            return this.convertField((ExprNodeFieldDesc)expr);
        }
        if (expr instanceof HiveParserExprNodeSubQueryDesc) {
            return this.convertSubQuery((HiveParserExprNodeSubQueryDesc)expr);
        }
        if (expr instanceof SqlOperatorExprNodeDesc) {
            return this.convertSqlOperator((SqlOperatorExprNodeDesc)expr);
        }
        throw new RuntimeException("Unsupported Expression");
    }

    private RexNode convertSqlOperator(SqlOperatorExprNodeDesc desc) throws SemanticException {
        ArrayList<RexNode> operands = new ArrayList<RexNode>(desc.getChildren().size());
        for (ExprNodeDesc child : desc.getChildren()) {
            operands.add(this.convert(child));
        }
        return this.cluster.getRexBuilder().makeCall(desc.getSqlOperator(), operands);
    }

    private RexNode convertField(ExprNodeFieldDesc fieldDesc) throws SemanticException {
        RexNode rexNode = this.convert(fieldDesc.getDesc());
        if (rexNode.getType().isStruct()) {
            return this.cluster.getRexBuilder().makeFieldAccess(rexNode, fieldDesc.getFieldName(), true);
        }
        if (fieldDesc.getIsList().booleanValue()) {
            // empty if block
        }
        throw new SemanticException("Unexpected rexnode : " + rexNode.getClass().getCanonicalName());
    }

    private RexNode convertColumn(ExprNodeColumnDesc col) throws SemanticException {
        InputCtx ic = this.getInputCtx(col);
        if (ic == null) {
            RelDataType rowType = HiveParserTypeConverter.getType(this.cluster, this.outerRR, null);
            if (this.outerNameToPos.get(col.getColumn()) == null) {
                throw new SemanticException("Invalid column name " + col.getColumn());
            }
            int pos = this.outerNameToPos.get(col.getColumn());
            CorrelationId colCorr = new CorrelationId(this.correlatedId);
            RexNode corExpr = this.cluster.getRexBuilder().makeCorrel(rowType, colCorr);
            return this.cluster.getRexBuilder().makeFieldAccess(corExpr, pos);
        }
        int pos = (Integer)ic.hiveNameToPosMap.get(col.getColumn());
        return this.cluster.getRexBuilder().makeInputRef(((RelDataTypeField)ic.calciteInpDataType.getFieldList().get(pos)).getType(), pos + ic.offsetInCalciteSchema);
    }

    public static RexNode convertConstant(ExprNodeConstantDesc literal, RelOptCluster cluster) throws SemanticException {
        RexLiteral calciteLiteral;
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RelDataTypeFactory dtFactory = rexBuilder.getTypeFactory();
        PrimitiveTypeInfo hiveType = (PrimitiveTypeInfo)literal.getTypeInfo();
        RelDataType calciteDataType = HiveParserTypeConverter.convert(hiveType, dtFactory);
        PrimitiveObjectInspector.PrimitiveCategory hiveTypeCategory = hiveType.getPrimitiveCategory();
        ConstantObjectInspector coi = literal.getWritableObjectInspector();
        Object value = ObjectInspectorUtils.copyToStandardJavaObject((Object)coi.getWritableConstantValue(), (ObjectInspector)coi);
        HiveShim hiveShim = HiveParserUtils.getSessionHiveShim();
        if (value == null) {
            hiveTypeCategory = PrimitiveObjectInspector.PrimitiveCategory.VOID;
        }
        switch (hiveTypeCategory) {
            case BOOLEAN: {
                calciteLiteral = rexBuilder.makeLiteral(((Boolean)value).booleanValue());
                break;
            }
            case BYTE: {
                calciteLiteral = rexBuilder.makeExactLiteral(new BigDecimal(((Byte)value).byteValue()), calciteDataType);
                break;
            }
            case SHORT: {
                calciteLiteral = rexBuilder.makeExactLiteral(new BigDecimal(((Short)value).shortValue()), calciteDataType);
                break;
            }
            case INT: {
                calciteLiteral = rexBuilder.makeExactLiteral(new BigDecimal((Integer)value));
                break;
            }
            case LONG: {
                calciteLiteral = rexBuilder.makeBigintLiteral(new BigDecimal((Long)value));
                break;
            }
            case DECIMAL: {
                if (value instanceof HiveDecimal) {
                    value = ((HiveDecimal)value).bigDecimalValue();
                } else if (value instanceof Decimal128) {
                    value = ((Decimal128)value).toBigDecimal();
                }
                if (value == null) {
                    throw new SemanticException("Expression " + literal.getExprString() + " is not a valid decimal");
                }
                BigDecimal bd = (BigDecimal)value;
                BigInteger unscaled = bd.unscaledValue();
                if (unscaled.compareTo(MIN_LONG_BI) >= 0 && unscaled.compareTo(MAX_LONG_BI) <= 0) {
                    calciteLiteral = rexBuilder.makeExactLiteral(bd);
                    break;
                }
                RelDataType relType = cluster.getTypeFactory().createSqlType(SqlTypeName.DECIMAL, unscaled.toString().length(), bd.scale());
                calciteLiteral = rexBuilder.makeExactLiteral(bd, relType);
                break;
            }
            case FLOAT: {
                calciteLiteral = rexBuilder.makeApproxLiteral(new BigDecimal(Float.toString(((Float)value).floatValue())), calciteDataType);
                break;
            }
            case DOUBLE: {
                if (Double.isNaN((Double)value)) {
                    throw new SemanticException("NaN");
                }
                calciteLiteral = rexBuilder.makeApproxLiteral(new BigDecimal(Double.toString((Double)value)), calciteDataType);
                break;
            }
            case CHAR: {
                if (value instanceof HiveChar) {
                    value = ((HiveChar)value).getValue();
                }
                calciteLiteral = rexBuilder.makeCharLiteral(HiveParserRexNodeConverter.asUnicodeString((String)value));
                break;
            }
            case VARCHAR: {
                if (value instanceof HiveVarchar) {
                    value = ((HiveVarchar)value).getValue();
                }
                calciteLiteral = rexBuilder.makeCharLiteral(HiveParserRexNodeConverter.asUnicodeString((String)value));
                break;
            }
            case STRING: {
                Object constantDescVal = literal.getValue();
                constantDescVal = constantDescVal instanceof NlsString ? constantDescVal : HiveParserRexNodeConverter.asUnicodeString((String)value);
                RelDataType type = HiveParserTypeConverter.convert(hiveType, dtFactory);
                type = dtFactory.createTypeWithNullability(type, false);
                calciteLiteral = rexBuilder.makeLiteral(constantDescVal, type, true);
                break;
            }
            case DATE: {
                LocalDate localDate = HiveParserUtils.getSessionHiveShim().toFlinkDate(value);
                DateString dateString = new DateString(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth());
                calciteLiteral = rexBuilder.makeDateLiteral(dateString);
                break;
            }
            case TIMESTAMP: {
                TimestampString timestampString;
                if (value instanceof Calendar) {
                    timestampString = TimestampString.fromCalendarFields((Calendar)((Calendar)value));
                } else {
                    LocalDateTime localDateTime = HiveParserUtils.getSessionHiveShim().toFlinkTimestamp(value);
                    timestampString = new TimestampString(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond());
                    timestampString = timestampString.withNanos(localDateTime.getNano());
                }
                calciteLiteral = rexBuilder.makeTimestampLiteral(timestampString, 9);
                break;
            }
            case VOID: {
                calciteLiteral = cluster.getRexBuilder().makeLiteral(null, dtFactory.createSqlType(SqlTypeName.NULL), true);
                break;
            }
            default: {
                if (hiveShim.isIntervalYearMonthType(hiveTypeCategory)) {
                    BigDecimal totalMonths = BigDecimal.valueOf(((HiveParserIntervalYearMonth)value).getTotalMonths());
                    calciteLiteral = rexBuilder.makeIntervalLiteral(totalMonths, new SqlIntervalQualifier(TimeUnit.YEAR, TimeUnit.MONTH, new SqlParserPos(1, 1)));
                    break;
                }
                if (hiveShim.isIntervalDayTimeType(hiveTypeCategory)) {
                    BigDecimal secsValueBd = BigDecimal.valueOf(((HiveParserIntervalDayTime)value).getTotalSeconds() * 1000L);
                    BigDecimal nanosValueBd = BigDecimal.valueOf(((HiveParserIntervalDayTime)value).getNanos(), 6);
                    calciteLiteral = rexBuilder.makeIntervalLiteral(secsValueBd.add(nanosValueBd), new SqlIntervalQualifier(TimeUnit.MILLISECOND, null, new SqlParserPos(1, 1)));
                    break;
                }
                throw new RuntimeException("UnSupported Literal type " + hiveTypeCategory);
            }
        }
        return calciteLiteral;
    }

    private RexNode convertGenericFunc(ExprNodeGenericFuncDesc func) throws SemanticException {
        RexNode expr;
        RexNode cast;
        boolean isTransformableTimeStamp;
        List<RexNode> childRexNodeLst = new ArrayList<RexNode>();
        ArrayList<RelDataType> argTypes = new ArrayList<RelDataType>();
        TypeInfo tgtDT = null;
        GenericUDF tgtUdf = func.getGenericUDF();
        if (tgtUdf instanceof GenericUDFIn) {
            return this.convertIN(func);
        }
        boolean isNumeric = HiveParserRexNodeConverter.isNumericBinary(func);
        boolean isCompare = !isNumeric && tgtUdf instanceof GenericUDFBaseCompare;
        boolean isWhenCase = tgtUdf instanceof GenericUDFWhen || tgtUdf instanceof GenericUDFCase;
        boolean bl = isTransformableTimeStamp = func.getGenericUDF() instanceof GenericUDFUnixTimeStamp && func.getChildren().size() != 0;
        if (isNumeric) {
            tgtDT = func.getTypeInfo();
            assert (func.getChildren().size() == 2);
        } else if (isCompare && func.getChildren().size() == 2) {
            tgtDT = FunctionRegistry.getCommonClassForComparison((TypeInfo)((ExprNodeDesc)func.getChildren().get(0)).getTypeInfo(), (TypeInfo)((ExprNodeDesc)func.getChildren().get(1)).getTypeInfo());
        } else if (isWhenCase) {
            if (HiveParserRexNodeConverter.checkForStatefulFunctions(func.getChildren())) {
                throw new SemanticException("Stateful expressions cannot be used inside of CASE");
            }
        } else if (isTransformableTimeStamp) {
            func = ExprNodeGenericFuncDesc.newInstance((GenericUDF)new GenericUDFToUnixTimeStamp(), (List)func.getChildren());
        }
        Iterator iterator = func.getChildren().iterator();
        while (iterator.hasNext()) {
            ExprNodeDesc childExpr;
            ExprNodeDesc tmpExprNode = childExpr = (ExprNodeDesc)iterator.next();
            if (tgtDT != null && TypeInfoUtils.isConversionRequiredForComparison((TypeInfo)tgtDT, (TypeInfo)childExpr.getTypeInfo())) {
                if (isCompare) {
                    tmpExprNode = HiveASTParseUtils.createConversionCast(childExpr, (PrimitiveTypeInfo)tgtDT);
                } else if (isNumeric) {
                    PrimitiveTypeInfo minArgType = HiveParserExprNodeDescUtils.deriveMinArgumentCast(childExpr, tgtDT);
                    tmpExprNode = HiveASTParseUtils.createConversionCast(childExpr, minArgType);
                } else {
                    throw new AssertionError((Object)("Unexpected " + tgtDT + " - not a numeric op or compare"));
                }
            }
            argTypes.add(HiveParserTypeConverter.convert(tmpExprNode.getTypeInfo(), this.cluster.getTypeFactory()));
            RexNode tmpRN = this.convert(tmpExprNode);
            childRexNodeLst.add(tmpRN);
        }
        RelDataType retType = HiveParserTypeConverter.convert(func.getTypeInfo(), this.cluster.getTypeFactory());
        SqlOperator calciteOp = HiveParserSqlFunctionConverter.getCalciteOperator(func.getFuncText(), func.getGenericUDF(), argTypes, retType);
        if (calciteOp.getKind() == SqlKind.CASE) {
            childRexNodeLst = this.rewriteCaseChildren(func, childRexNodeLst);
        }
        if ((cast = this.handleExplicitCast(func, childRexNodeLst, ((RexCall)(expr = this.cluster.getRexBuilder().makeCall(calciteOp, childRexNodeLst))).getOperator())) != null) {
            expr = cast;
            retType = cast.getType();
        }
        if (this.flattenExpr && expr instanceof RexCall && !(((RexCall)expr).getOperator() instanceof SqlCastFunction)) {
            RexCall call = (RexCall)expr;
            expr = this.cluster.getRexBuilder().makeCall(retType, call.getOperator(), RexUtil.flatten((List)call.getOperands(), (SqlOperator)call.getOperator()));
        }
        return expr;
    }

    private RexNode convertSubQuery(HiveParserExprNodeSubQueryDesc subQueryDesc) throws SemanticException {
        if (subQueryDesc.getType() == HiveParserExprNodeSubQueryDesc.SubqueryType.IN) {
            TypeInfo rhsType;
            if (subQueryDesc.getRexSubQuery().getRowType().getFieldCount() > 1) {
                throw new SemanticException(ErrorMsg.INVALID_SUBQUERY_EXPRESSION.getMsg("SubQuery can contain only 1 item in Select List."));
            }
            ExprNodeDesc lhsDesc = subQueryDesc.getSubQueryLhs();
            TypeInfo lhsType = lhsDesc.getTypeInfo();
            TypeInfo commonType = FunctionRegistry.getCommonClassForComparison((TypeInfo)lhsType, (TypeInfo)(rhsType = HiveParserTypeConverter.convert(((RelDataTypeField)subQueryDesc.getRexSubQuery().getRowType().getFieldList().get(0)).getType())));
            if (commonType == null) {
                throw new SemanticException("Cannot do equality join on different types: " + lhsType.getTypeName() + " and " + rhsType.getTypeName());
            }
            if (TypeInfoUtils.isConversionRequiredForComparison((TypeInfo)lhsType, (TypeInfo)commonType)) {
                lhsDesc = HiveASTParseUtils.createConversionCast(lhsDesc, (PrimitiveTypeInfo)commonType);
            }
            RelNode rhsRel = HiveParserDMLHelper.addTypeConversions(this.cluster.getRexBuilder(), subQueryDesc.getRexSubQuery(), Collections.singletonList(HiveParserTypeConverter.convert(commonType, this.cluster.getTypeFactory())), Collections.singletonList(commonType), null);
            RexNode lhsRex = this.convert(lhsDesc);
            return HiveParserUtils.rexSubQueryIn(rhsRel, Collections.singletonList(lhsRex));
        }
        if (subQueryDesc.getType() == HiveParserExprNodeSubQueryDesc.SubqueryType.EXISTS) {
            return RexSubQuery.exists((RelNode)subQueryDesc.getRexSubQuery());
        }
        if (subQueryDesc.getType() == HiveParserExprNodeSubQueryDesc.SubqueryType.SCALAR) {
            if (subQueryDesc.getRexSubQuery().getRowType().getFieldCount() > 1) {
                throw new SemanticException(ErrorMsg.INVALID_SUBQUERY_EXPRESSION.getMsg("SubQuery can contain only 1 item in Select List."));
            }
            return RexSubQuery.scalar((RelNode)subQueryDesc.getRexSubQuery());
        }
        throw new SemanticException(ErrorMsg.INVALID_SUBQUERY_EXPRESSION.getMsg("Invalid subquery: " + (Object)((Object)subQueryDesc.getType())));
    }

    private RexNode convertIN(ExprNodeGenericFuncDesc func) throws SemanticException {
        ArrayList<RexNode> childRexNodes = new ArrayList<RexNode>();
        for (ExprNodeDesc childExpr : func.getChildren()) {
            childRexNodes.add(this.convert(childExpr));
        }
        if (this.funcConverter.hasOverloadedOp((SqlOperator)HiveParserIN.INSTANCE, SqlFunctionCategory.USER_DEFINED_FUNCTION)) {
            return this.cluster.getRexBuilder().makeCall((SqlOperator)HiveParserIN.INSTANCE, childRexNodes);
        }
        RexNode leftKey = (RexNode)childRexNodes.get(0);
        Preconditions.checkState((boolean)(leftKey instanceof RexInputRef), (Object)("Expecting LHS key of IN to be a RexInputRef, actually got " + leftKey));
        ArrayList<RexNode> comparisons = new ArrayList<RexNode>();
        for (int i = 1; i < childRexNodes.size(); ++i) {
            comparisons.add(this.cluster.getRexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{leftKey, (RexNode)childRexNodes.get(i)}));
        }
        return RexUtil.composeDisjunction((RexBuilder)this.cluster.getRexBuilder(), comparisons, (boolean)true);
    }

    private List<RexNode> rewriteCaseChildren(ExprNodeGenericFuncDesc func, List<RexNode> childRexNodeLst) throws SemanticException {
        ArrayList<RexNode> newChildRexNodeLst = new ArrayList<RexNode>();
        if (FunctionRegistry.getNormalizedFunctionName((String)func.getFuncText()).equals("case")) {
            RexNode firstPred = childRexNodeLst.get(0);
            int length = childRexNodeLst.size() % 2 == 1 ? childRexNodeLst.size() : childRexNodeLst.size() - 1;
            for (int i = 1; i < length; ++i) {
                if (i % 2 == 1) {
                    newChildRexNodeLst.add(this.cluster.getRexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{firstPred, childRexNodeLst.get(i)}));
                    continue;
                }
                newChildRexNodeLst.add(childRexNodeLst.get(i));
            }
            if (length != childRexNodeLst.size()) {
                newChildRexNodeLst.add(childRexNodeLst.get(childRexNodeLst.size() - 1));
            }
        } else {
            newChildRexNodeLst.addAll(childRexNodeLst);
        }
        if (newChildRexNodeLst.size() % 2 == 0) {
            newChildRexNodeLst.add(this.cluster.getRexBuilder().makeNullLiteral(((RexNode)newChildRexNodeLst.get(newChildRexNodeLst.size() - 1)).getType().getSqlTypeName()));
        }
        return newChildRexNodeLst;
    }

    private boolean castExprUsingUDFBridge(GenericUDF gUDF) {
        int sp;
        String udfClassName;
        boolean castExpr = false;
        if (gUDF instanceof GenericUDFBridge && (udfClassName = ((GenericUDFBridge)gUDF).getUdfClassName()) != null && (sp = udfClassName.lastIndexOf(46)) >= 0 & sp + 1 < udfClassName.length() && ((udfClassName = udfClassName.substring(sp + 1)).equals("UDFToBoolean") || udfClassName.equals("UDFToByte") || udfClassName.equals("UDFToDouble") || udfClassName.equals("UDFToInteger") || udfClassName.equals("UDFToLong") || udfClassName.equals("UDFToShort") || udfClassName.equals("UDFToFloat") || udfClassName.equals("UDFToString"))) {
            castExpr = true;
        }
        return castExpr;
    }

    private RexNode handleExplicitCast(ExprNodeGenericFuncDesc func, List<RexNode> childRexNodeLst, SqlOperator operator) throws SemanticException {
        GenericUDF udf = func.getGenericUDF();
        if (this.isExplicitCast(udf) && childRexNodeLst != null && childRexNodeLst.size() == 1 && (udf instanceof SettableUDF || !this.funcConverter.hasOverloadedOp(operator, SqlFunctionCategory.USER_DEFINED_FUNCTION))) {
            return this.cluster.getRexBuilder().makeAbstractCast(HiveParserTypeConverter.convert(func.getTypeInfo(), this.cluster.getTypeFactory()), childRexNodeLst.get(0));
        }
        return null;
    }

    private boolean isExplicitCast(GenericUDF udf) {
        return udf instanceof GenericUDFToChar || udf instanceof GenericUDFToVarchar || udf instanceof GenericUDFToDecimal || udf instanceof GenericUDFToDate || udf instanceof GenericUDFTimestamp || udf instanceof GenericUDFToBinary || this.castExprUsingUDFBridge(udf);
    }

    private InputCtx getInputCtx(ExprNodeColumnDesc col) throws SemanticException {
        InputCtx ctxLookingFor = null;
        if (this.inputCtxs.size() == 1 && this.inputCtxs.get(0).hiveRR == null) {
            ctxLookingFor = this.inputCtxs.get(0);
        } else {
            String tableAlias = col.getTabAlias();
            String colAlias = col.getColumn();
            int noInp = 0;
            for (InputCtx ic : this.inputCtxs) {
                if (tableAlias != null && !ic.hiveRR.hasTableAlias(tableAlias) || ic.hiveRR.getPosition(colAlias) < 0) continue;
                ctxLookingFor = ic;
                ++noInp;
            }
            if (noInp > 1) {
                throw new RuntimeException("Ambiguous column mapping");
            }
        }
        return ctxLookingFor;
    }

    private static NlsString asUnicodeString(String text) {
        return new NlsString(text, ConversionUtil.NATIVE_UTF16_CHARSET_NAME, SqlCollation.IMPLICIT);
    }

    private static boolean checkForStatefulFunctions(List<ExprNodeDesc> list) {
        for (ExprNodeDesc node : list) {
            if (!(node instanceof ExprNodeGenericFuncDesc)) continue;
            GenericUDF nodeUDF = ((ExprNodeGenericFuncDesc)node).getGenericUDF();
            if (FunctionRegistry.isStateful((GenericUDF)nodeUDF)) {
                return true;
            }
            if (node.getChildren() == null || node.getChildren().isEmpty() || !HiveParserRexNodeConverter.checkForStatefulFunctions(node.getChildren())) continue;
            return true;
        }
        return false;
    }

    private static boolean isNumericBinary(ExprNodeGenericFuncDesc func) {
        GenericUDF tgtUdf = func.getGenericUDF();
        boolean rightClz = genericUDFBaseBinaryClz != null ? genericUDFBaseBinaryClz.isInstance(tgtUdf) : tgtUdf instanceof GenericUDFBaseCompare || tgtUdf instanceof GenericUDFBaseNumeric;
        return rightClz && func.getTypeInfo().getCategory() == ObjectInspector.Category.PRIMITIVE && PrimitiveObjectInspectorUtils.PrimitiveGrouping.NUMERIC_GROUP == PrimitiveObjectInspectorUtils.getPrimitiveGrouping((PrimitiveObjectInspector.PrimitiveCategory)((PrimitiveTypeInfo)func.getTypeInfo()).getPrimitiveCategory());
    }

    private static class InputCtx {
        private final RelDataType calciteInpDataType;
        private final Map<String, Integer> hiveNameToPosMap;
        private final HiveParserRowResolver hiveRR;
        private final int offsetInCalciteSchema;

        private InputCtx(RelDataType calciteInpDataType, Map<String, Integer> hiveNameToPosMap, HiveParserRowResolver hiveRR, int offsetInCalciteSchema) {
            this.calciteInpDataType = calciteInpDataType;
            this.hiveNameToPosMap = hiveNameToPosMap;
            this.hiveRR = hiveRR;
            this.offsetInCalciteSchema = offsetInCalciteSchema;
        }
    }
}

