/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive.copy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.GraphWalker;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class HiveParserDefaultGraphWalker
implements GraphWalker {
    protected final Stack<Node> opStack;
    protected final Queue<Node> opQueue;
    protected final List<Node> toWalk = new ArrayList<Node>();
    protected final IdentityHashMap<Node, Object> retMap = new IdentityHashMap();
    protected final Dispatcher dispatcher;

    public HiveParserDefaultGraphWalker(Dispatcher disp) {
        this.dispatcher = disp;
        this.opStack = new Stack();
        this.opQueue = new LinkedList<Node>();
    }

    protected Set<Node> getDispatchedList() {
        return this.retMap.keySet();
    }

    public void dispatch(Node nd, Stack<Node> ndStack) throws SemanticException {
        this.dispatchAndReturn(nd, ndStack);
    }

    public <T> T dispatchAndReturn(Node nd, Stack<Node> ndStack) throws SemanticException {
        Object[] nodeOutputs = null;
        if (nd.getChildren() != null) {
            nodeOutputs = new Object[nd.getChildren().size()];
            int i = 0;
            for (Node child : nd.getChildren()) {
                nodeOutputs[i++] = this.retMap.get(child);
            }
        }
        Object retVal = this.dispatcher.dispatch(nd, ndStack, nodeOutputs);
        this.retMap.put(nd, retVal);
        return (T)retVal;
    }

    public void startWalking(Collection<Node> startNodes, HashMap<Node, Object> nodeOutput) throws SemanticException {
        this.toWalk.addAll(startNodes);
        while (this.toWalk.size() > 0) {
            Node nd = this.toWalk.remove(0);
            this.walk(nd);
            if (nodeOutput == null || !this.getDispatchedList().contains(nd)) continue;
            nodeOutput.put(nd, this.retMap.get(nd));
        }
        while (!this.opQueue.isEmpty()) {
            Node node = this.opQueue.poll();
            if (nodeOutput == null || !this.getDispatchedList().contains(node)) continue;
            nodeOutput.put(node, this.retMap.get(node));
        }
    }

    protected void walk(Node nd) throws SemanticException {
        this.opStack.push(nd);
        block0: while (!this.opStack.empty()) {
            Node node = this.opStack.peek();
            if (node.getChildren() == null || this.getDispatchedList().containsAll(node.getChildren())) {
                if (!this.getDispatchedList().contains(node)) {
                    this.dispatch(node, this.opStack);
                    this.opQueue.add(node);
                }
                this.opStack.pop();
                continue;
            }
            for (Node childNode : node.getChildren()) {
                if (this.getDispatchedList().contains(childNode)) continue;
                this.opStack.push(childNode);
                continue block0;
            }
        }
    }
}

