/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive.copy;

import java.util.List;
import java.util.Map;
import org.apache.flink.table.planner.delegation.hive.SqlOperatorExprNodeDesc;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserExprNodeColumnListDesc;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserExprNodeSubQueryDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.HiveDecimalUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class HiveParserExprNodeDescUtils {
    private HiveParserExprNodeDescUtils() {
    }

    public static void getExprNodeColumnDesc(List<ExprNodeDesc> exprDescList, Map<Integer, ExprNodeDesc> hashCodeToColumnDesc) {
        for (ExprNodeDesc exprNodeDesc : exprDescList) {
            HiveParserExprNodeDescUtils.getExprNodeColumnDesc(exprNodeDesc, hashCodeToColumnDesc);
        }
    }

    private static void getExprNodeColumnDesc(ExprNodeDesc exprDesc, Map<Integer, ExprNodeDesc> hashCodeToColumnDescMap) {
        if (exprDesc instanceof ExprNodeColumnDesc) {
            hashCodeToColumnDescMap.put(exprDesc.hashCode(), exprDesc);
        } else if (exprDesc instanceof HiveParserExprNodeColumnListDesc) {
            for (ExprNodeDesc child : exprDesc.getChildren()) {
                HiveParserExprNodeDescUtils.getExprNodeColumnDesc(child, hashCodeToColumnDescMap);
            }
        } else if (exprDesc instanceof ExprNodeGenericFuncDesc || exprDesc instanceof SqlOperatorExprNodeDesc) {
            for (ExprNodeDesc child : exprDesc.getChildren()) {
                HiveParserExprNodeDescUtils.getExprNodeColumnDesc(child, hashCodeToColumnDescMap);
            }
        } else if (exprDesc instanceof ExprNodeFieldDesc) {
            HiveParserExprNodeDescUtils.getExprNodeColumnDesc(((ExprNodeFieldDesc)exprDesc).getDesc(), hashCodeToColumnDescMap);
        } else if (exprDesc instanceof HiveParserExprNodeSubQueryDesc) {
            HiveParserExprNodeDescUtils.getExprNodeColumnDesc(((HiveParserExprNodeSubQueryDesc)exprDesc).getSubQueryLhs(), hashCodeToColumnDescMap);
        }
    }

    public static boolean isAllConstants(List<ExprNodeDesc> value) {
        for (ExprNodeDesc expr : value) {
            if (expr instanceof ExprNodeConstantDesc) continue;
            return false;
        }
        return true;
    }

    public static PrimitiveTypeInfo deriveMinArgumentCast(ExprNodeDesc childExpr, TypeInfo targetType) {
        assert (targetType instanceof PrimitiveTypeInfo) : "Not a primitive type" + targetType;
        PrimitiveTypeInfo pti = (PrimitiveTypeInfo)targetType;
        if (pti.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.DECIMAL || !(childExpr.getTypeInfo() instanceof PrimitiveTypeInfo)) {
            return pti;
        }
        PrimitiveTypeInfo childTi = (PrimitiveTypeInfo)childExpr.getTypeInfo();
        return HiveDecimalUtils.getDecimalTypeForPrimitiveCategory((PrimitiveTypeInfo)childTi);
    }
}

